<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    BusinessTech.fr
 * @copyright Business Tech
 * @license   Commercial
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

class facebookproductadAjaxModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    protected $jsonOutput = array();
    public $ajax = true;

    /**
     * init module front controller
     */
    public function init()
    {
        // exec parent
        parent::init();
        $this->ajax = true;
    }


    /**
     * set the ajax
     */
    public function displayAjax()
    {
        $sAction = Tools::getValue('action', 'undefined');

        if (!empty($sAction) && method_exists($this, 'ajaxProcess' . Tools::toCamelCase($sAction))) {
            $this->{'ajaxProcess' . Tools::toCamelCase($sAction)}();
        } else {
            $this->errors[] = $this->module->l('Undefined action', 'ajax');
        }
    }

    /**
     * handle ajax for handle the select promotion clicked
     */
    protected function ajaxProcessUpdateConsent()
    {
        $sToken = Tools::getValue('token');
        $sModuleToken = Tools::getToken(false);
        // Do not execute if token is missing or false
        if (!empty($sToken) && $sModuleToken == $sToken) {
            // Set the user cookie
            Context::getContext()->cookie->bt_fbda_consent_lvl = 3;

            die(\json_encode(true));
        }
    }

    /**
     * handle ajax for handle the select promotion clicked
     */
    protected function ajaxProcessAddToCart()
    {
        $token = Tools::getValue('token');
        $module_token = Tools::getToken(false);
        // Do not execute if token is missing or false
        if (!empty($token) && $module_token == $token) {
            $id_product = Tools::getValue('id_product');

            if (!empty($id_product)) {

                $product = new Product((int)$id_product, FacebookProductAd::$iCurrentLang);
                $price = Product::getPriceStatic((int)$product->id, true, false, 2, null, false, true);
                $lang_prefix = new \Language(\Context::getContext()->cookie->id_lang);
                $module_prefix = \Tools::strtoupper(\FacebookProductAd::$conf['FPA_ID_PREFIX']);

                //$this->jsonOutput['sPaymentMethod'] = $oCarrier->name;
                $this->jsonOutput['content_type'] = 'product';
                $this->jsonOutput['content_ids'] = $module_prefix . \Tools::strtoupper($lang_prefix->iso_code) . $product->id;;
                $this->jsonOutput['value'] = number_format($price, 2, '.', ',');
                $this->jsonOutput['currency'] = Context::getContext()->currency->iso_code;
            }

            die(json_encode($this->jsonOutput));
        }
    }

    /**
     * handle the ajax on product combination update
     */
    protected function ajaxProcessUpdateCombination()
    {
        $sToken = \Tools::getValue('token');
        $sModuleToken = \Tools::getToken(false);
        $content_id = '';
        // Do not execute if token is missing or false
        if (!empty($sToken) && $sModuleToken == $sToken) {
            $id_product_attribute = \Tools::getValue('id_product_attribute');
            $id_product = \Tools::getValue('id_product');
            $language = new \Language(\Context::getContext()->cookie->id_lang);
            $prefix_lang = !empty(\FacebookProductAd::$conf['FPA_ADD_LANG_ID']) ? \Tools::strtoupper($language->iso_code) : '';
            $prefix_id = \Tools::strtoupper(\FacebookProductAd::$conf['FPA_ID_PREFIX']);

            if (!empty($id_product)) {

                $oProduct = new \Product((int)$id_product, \FacebookProductAd::$iCurrentLang);
                $oCategory = new \Category((int)$oProduct->id_category_default, \FacebookProductAd::$iCurrentLang);
                $fPrice = \Product::getPriceStatic((int)$oProduct->id, true, false, 2, null, false, true);

                if (empty(\FacebookProductAd::$conf['FPA_P_COMBOS'])) {
                    $content_id = $prefix_id . $prefix_lang . $id_product;
                } else {
                    if (!empty($id_product_attribute)) {
                        $fPrice = \Product::getPriceStatic((int)$oProduct->id, true, false, 2, null, false, true);
                        $content_id = $prefix_id . $prefix_lang . $id_product . \FacebookProductAd::$conf['FPA_COMBO_SEPARATOR'] . $id_product_attribute;
                    } else {
                        $content_id = $prefix_id . $prefix_lang . $id_product;
                    }
                }

                $this->jsonOutput['content_id'] = $content_id;
                $this->jsonOutput['content_name'] = str_replace('\'', '', $oProduct->name[\FacebookProductAd::$iCurrentLang]);
                $this->jsonOutput['currency'] = \Context::getContext()->currency->iso_code;
                $this->jsonOutput['content_category'] = $oCategory->name;
                $this->jsonOutput['value'] = number_format($fPrice, 2, '.', ',');
            }

            die(json_encode($this->jsonOutput));
        }
    }
}
