<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\FacebookApi;

class FacebookClient
{
    const API_VERSION = 'v14.0';

    /**
     * The API url
     *
     * @var string
     */
    public static $api_url;

    public function __construct()
    {
    }

    /**
     * method send formatted data to Facebook api
     *
     * @param mixed $data
     * @return array
     */
    public static function send($data)
    {
        // Only handle the api call if we have pixel token and if the feature is activated
        if (!empty(\FacebookProductAd::$conf['FPA_PIXEL']) && !empty(\FacebookProductAd::$conf['FPA_TOKEN_API']) && !empty(\FacebookProductAd::$conf['FPA_USE_API'])) {

            $url = 'https://graph.facebook.com/' . self::API_VERSION . '/' . (string)\FacebookProductAd::$conf['FPA_PIXEL'] . '/events?access_token=' . (string)\FacebookProductAd::$conf['FPA_TOKEN_API'];
            $curl = curl_init($url);

            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

            $headers = array(
                "content-type: application/json",
            );

            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            curl_exec($curl);
            curl_close($curl);
        }
    }
}
