<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Hook;

use FacebookProductAd\FacebookApi\FacebookClient;
use FacebookProductAd\ModuleLib\moduleTools;

class hookAction extends hookBase
{
    /**
     * @var string $sHookAction : define the hook type
     */
    protected $sHookAction = null;

    public function __construct($sHookAction)
    {
        $this->sHookAction = $sHookAction;
    }

    /**
     * method execute hook
     *
     * @param array $aParams
     * @return array
     */
    public function run(array $aParams = null)
    {
        //to handle DAO


        // set variables
        $aDisplayHook = array();

        switch ($this->sHookAction) {
            case 'validateOrder':
                // use case - display nothing only process storage in order to send an email
                $aDisplayHook = call_user_func_array(array($this, 'validateOrder'), array($aParams));
                break;
            default:
                break;
        }

        return $aDisplayHook;
    }

    /**
     * method add order in Prestashop
     *
     * @param array $params
     * @return bool
     */
    private function validateOrder(array $params = null)
    {
        try {
            if (!empty($params['order']) && \Validate::isLoadedObject($params['order']) && $params['order']->module != 'facebookproductad' && $params['order']->getCurrentState() != \Configuration::get('PS_OS_ERROR')) {
                $prefix = '';
                $products = $params['order']->getProductsDetail();
                $order = new \Order((int)$params['order']->id);
                $currency = new \Currency($order->id_currency);
                $order_products = '';
                $order_value = '"' . moduleTools::getOrderPrice($order, \FacebookProductAd::$conf['FPA_USE_TAX'], \FacebookProductAd::$conf['FPA_USE_SHIPPING'], \FacebookProductAd::$conf['FPA_USE_WRAPPING']) . '"';
                $gender = new \Gender((int)$params['customer']->id_gender);
                $gender = $gender->type == 0 ? 'm' : 'f';
                $customer_address = new \Address((int)$params['order']->id_address_invoice);
                $country = new \Country((int)$customer_address->id_country);
                $state = new \State((int)$customer_address->id_state);
                $product_data = array();
                $language = new \Language((int) \Context::getContext()->cookie->id_lang);

                // Build prefix with the land id for product matching
                if (!empty(\FacebookProductAd::$conf['FPA_ADD_LANG_ID'])) {
                    $prefix = \Tools::strtoupper($language->iso_code);
                }

                if (!empty($products)) {
                    reset($products);
                    foreach ($products as $aProduct) {

                        if (empty(\FacebookProductAd::$conf['FPA_P_COMBOS'])) {
                            $product_data[] = "'" . \Tools::strtoupper(\FacebookProductAd::$conf['FPA_ID_PREFIX']) . $prefix . $aProduct['id_product'] . "'";
                        } else {
                            $default_ipa = \Product::getDefaultAttribute($aProduct['id_product']);
                            if (!empty($default_ipa)) {
                                $product_data[] = "'" . \Tools::strtoupper(\FacebookProductAd::$conf['FPA_ID_PREFIX']) . $prefix . $aProduct['id_product'] . \FacebookProductAd::$conf['FPA_COMBO_SEPARATOR'] . $default_ipa . "'";
                            } else {
                                $product_data[] = "'" . \Tools::strtoupper(\FacebookProductAd::$conf['FPA_ID_PREFIX']) . $prefix . $aProduct['id_product'] . "'";
                            }
                        }
                    }
                    array_unique($product_data);

                    //init the string
                    $order_products = '[';
                    $order_products .= implode(',', $product_data);
                    $order_products .= ']';
                }

                $user_data = moduleTools::getApiUserData(\Context::getContext());

                if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
                    $data = '{
                            "data": [
                                {
                                    "event_name": "Purchase",
                                    "event_time": ' . time() . ',
                                    "action_source": "website",
                                    "event_id": "' . $user_data['event_id'] . '",
                                    "user_data": {
                                        "em": "' . $user_data['em']  . '",
                                        "ph": "' . $user_data['ph']  . '",
                                        "fn": "' . $user_data['fn']  . '",
                                        "ln": "' . $user_data['ln']  . '",
                                        "db": "' . $user_data['db']  . '",
                                        "ge": "' . $user_data['ge']  . '",
                                        "ct": "' . $user_data['ct']  . '",
                                        "st": "' . $user_data['st']  . '",
                                        "zp": "' . $user_data['zp']  . '",
                                        "country": "' . $user_data['country']  . '",
                                        "external_id": "' . $user_data['external_id']  . '",
                                        "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                        "client_user_agent": "' . $user_data['client_user_agent']  . '"
                                    },
                                    "custom_data": {
                                        "content_category": "",
                                        "content_ids": "' . $order_products . '",
                                        "content_name": "",
                                        "content_type": "product",
                                        "currency": "' . $currency->iso_code .'",
                                        "value": "' . $order_value .'",
                                    }
                                }
                            ],

                        }';
                } else {
                    $data = '{
                        "data": [
                            {
                                "event_name": "Purchase",
                                "event_time": ' . time() . ',
                                "action_source": "website",
                                "event_id": "' . $user_data['event_id'] . '",
                                "user_data": {
                                    "em": "' . $user_data['em']  . '",
                                    "ph": "' . $user_data['ph']  . '",
                                    "fn": "' . $user_data['fn']  . '",
                                    "ln": "' . $user_data['ln']  . '",
                                    "db": "' . $user_data['db']  . '",
                                    "ge": "' . $user_data['ge']  . '",
                                    "zp": "' . $user_data['zp']  . '",
                                    "country": "' . $user_data['country']  . '",
                                    "external_id": "' . $user_data['external_id']  . '",
                                    "client_user_agent": "' . $user_data['client_user_agent']  . '"
                                },
                                "custom_data": {
                                    "content_category": "",
                                    "content_ids": "' . $order_products . '",
                                    "content_name": "",
                                    "content_type": "product",
                                    "currency": "' . $currency->iso_code .'",
                                    "value": "' . $order_value .'",
                                }
                            }
                        ],

                    }';
                }

                FacebookClient::send($data);
            }
        } catch (\Exception $e) {
            \PrestaShopLogger::addLog($e->getMessage(), 1, $e->getCode(), null, null, true);
        }
    }
}
