<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Hook;

abstract class hookBase
{
    /**
     * @var string $sHook : define hook display or action
     */
    protected $sHook = null;

    /**
     * Magic Method __construct assigns few information about hook
     *
     * @param string $sHook
     */
    public function __construct($sHook)
    {
        // set hook
        $this->sHook = $sHook;
    }

    /**
     * method execute hook
     *
     * @category hook collection
     * @uses
     *
     * @param array $aParams
     * @return array
     */
    abstract public function run(array $aParams = null);
}
