<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Hook;

use FacebookProductAd\Configuration\moduleConfiguration;
use FacebookProductAd\ModuleLib\moduleTools;

class hookDisplay extends hookBase
{
    /**
     * @var bool $bAlreadyExecute : define if one hook is already executed
     */
    protected static $bAlreadyExecute = false;

    /**
     * Magic Method __construct assigns few information about hook
     */
    public function __construct($sHookAction)
    {
        // set hook action
        $this->sHook = $sHookAction;
    }

    /**
     * method execute hook
     *
     * @param array $aParams
     * @return array
     */
    public function run(array $aParams = null)
    {
        // set variables
        $aDisplayHook = array();

        switch ($this->sHook) {
            case 'header':
            case 'orderConfirmation':
            case 'footer':
            case 'paymentByBinaries':
            case 'paymentTop':
                // use case - display in header
                $aDisplayHook = call_user_func_array(array($this, 'display' . ucfirst($this->sHook)), array($aParams));
                break;
            default:
                break;
        }

        return $aDisplayHook;
    }

    /**
     *  method display header
     *
     * @param array $aParams
     * @return array
     */
    private function displayHeader(array $aParams = null)
    {
        //detect the page
        $sPageType = (!empty($aParams['sPageType']) ? $aParams['sPageType'] : moduleTools::detectCurrentPage());
        $iOrderId = 0;
        $jsDefs = array();
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        // get required values
        $iProductId = \Tools::getvalue('id_product');
        $iCatId = \Tools::getvalue('id_category');
        $iManufacturerId = \Tools::getvalue('id_manufacturer');
        $currentLang = new \Language(\Context::getContext()->cookie->id_lang);
        $prefixLang = '';

        if (!empty(\FacebookProductAd::$conf['FPA_ADD_LANG_ID']) && !empty($currentLang->iso_code)) {
            $prefixLang = !empty($currentLang->iso_code) ? \Tools::strtoupper($currentLang->iso_code) : '';
        }

        if (!empty(\Tools::getvalue('id_order'))) {
            $iOrderId = \Tools::getvalue('id_order');
        } else if (!empty(\Context::getContext()->controller->id_order)) {
            $iOrderId = (int)\Context::getContext()->controller->id_order;
        }

        // With some payment method the context cart id is not set
        $iCartId = !empty(\Tools::getValue('id_cart')) ? \Tools::getValue('id_cart') : \Context::getContext()->cart->id;

        // Use case for product page and sub module
        if ($sPageType == 'product' && !empty(\FacebookProductAd::$pmSub)) {
            $module = \Module::getInstanceByName('pm_subscription');
            if (\Tools::version_compare($module->version, '1.1.0', '<')) {
                $bSub = \SubProduct::getSubInfosByProductId((int) $iProductId);
            } else {
                $bSub = \PmSubscription\Models\Product::getSubInfosByProductId((int) $iProductId);
            }

            // Use case if the product is a SUB type we force the page type
            if (!empty($bSub)) {
                $sPageType = 'productSub';
            }
        }
        // Use case for the orderId for Paybox
        if (empty($iOrderId)) {
            $iOrderId = moduleTools::getOrderIdForPaypox($iCartId);
        }

        $aDynTags = array(
            'iProductId' => $iProductId,
            'iCategoryId' => $iCatId,
            'iManufacturerId' => $iManufacturerId,
            'iCartId' => $iCartId,
            'iOrderId' => $iOrderId,
            'js' => array(
                'cartSelectorProd' => \FacebookProductAd::$conf['FPA_JS_CART_SELECTOR_PROD'],
                'cartSelectorProdCategory' => \FacebookProductAd::$conf['FPA_JS_CART_SELECTOR_CAT'],
                'wishSelectorProd' => \FacebookProductAd::$conf['FPA_JS_WISH_SELECTOR_PROD'],
                'orderButton' => \FacebookProductAd::$conf['FPA_JS_ORDER_SELECTOR'],
                'subAdd' => '.pm_subscription_display_product_buttons',
            )
        );

        $jsDefs['btnAddToCart'] = $aDynTags['js']['cartSelectorProd'];
        $jsDefs['btnAddToCartCategory'] = $aDynTags['js']['cartSelectorProdCategory'];
        $jsDefs['btnAddToWishlist'] = $aDynTags['js']['wishSelectorProd'];
        $jsDefs['btnOrder'] = $aDynTags['js']['orderButton'];
        $jsDefs['btnSub'] = $aDynTags['js']['subAdd'];
        $jsDefs['tagContent'] = moduleTools::buildDynDisplayTag($aDynTags, $sPageType);
        $jsDefs['pixel_id'] = \FacebookProductAd::$conf['FPA_PIXEL'];
        $jsDefs['bUseConsent'] = \FacebookProductAd::$conf['FPA_USE_CONSENT'];
        $jsDefs['iConsentConsentLvl'] = moduleTools::getConsentStatus();
        $jsDefs['bConsentHtmlElement'] = !empty(\FacebookProductAd::$conf['FPA_ELEMENT_HTML_ID']) ? \FacebookProductAd::$conf['FPA_ELEMENT_HTML_ID'] : '';
        $jsDefs['token'] = \Tools::getToken(false);
        $jsDefs['ajaxUrl'] = \Context::getContext()->link->getModuleLink('facebookproductad', 'ajax', array());
        $jsDefs['external_id'] = !empty(\Context::getContext()->customer->id) ? hash('sha256', (int) \Context::getContext()->customer->id) :  \Context::getContext()->cart->id_guest;
        $jsDefs['useAdvancedMatching'] = !empty(\FacebookProductAd::$conf['FPA_ADVANCED_MATCHING']) ? true : false;
        $jsDefs['advancedMatchingData'] = !empty(moduleTools::getAdvancedMatchingData(\Context::getContext())) ? moduleTools::getAdvancedMatchingData(\Context::getContext()) : false;
        $jsDefs['eventId'] = $user_data['event_id'];
        $jsDefs['fbdaSeparator'] = \FacebookProductAd::$conf['FPA_COMBO_SEPARATOR'];
        $jsDefs['pixelCurrency'] = \Context::getContext()->currency->iso_code;
        $jsDefs['comboExport'] = \FacebookProductAd::$conf['FPA_P_COMBOS'];
        $jsDefs['prefix'] = \FacebookProductAd::$conf['FPA_ID_PREFIX'];
        $jsDefs['prefixLang'] = $prefixLang;


        if (!empty($jsDefs['tagContent']['currency']['value'])) {
            $jsDefs['tagContent']['currency']['value'] = str_replace('\'', '', $jsDefs['tagContent']['currency']['value']);
        }

        \Media::addJsDef(array('btPixel' => $jsDefs));
        \Context::getContext()->controller->addJS(moduleConfiguration::FPA_URL_JS . 'pixel.js');

        return array('tpl' => moduleConfiguration::FPA_TPL_HOOK_PATH . 'header.tpl', 'assign' => array());
    }
}
