<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Install;

use FacebookProductAd\Configuration\moduleConfiguration;

class installTab implements installInterface
{
    /**
     * method install of module
     *
     * @param mixed $mParam
     * @return bool $bReturn : true => validate install, false => invalidate install
     */
    public static function install($mParam = null)
    {
        // declare return
        $bReturn = true;

        static $oTab;

        // instantiate
        if (null === $oTab) {
            $oTab = new Tab();
        }

        // log jam to debug appli
        if (defined('moduleConfiguration::FPA_LOG_JAM_CONFIG') && moduleConfiguration::FPA_LOG_JAM_CONFIG) {
            $bReturn = moduleConfiguration::FPA_LOG_JAM_CONFIG;
        } else {
            // set variables
            $aTmpLang = array();

            // get available languages
            $aLangs = \Language::getLanguages(true);

            // loop on each admin tab
            foreach (moduleConfiguration::FPA_TABS as $sAdminClassName => $aTab) {
                foreach ($aLangs as $aLang) {
                    $aTmpLang[$aLang['id_lang']] = array_key_exists($aLang['iso_code'],
                        $aTab['lang']) ? $aTab['lang'][$aLang['iso_code']] : $aTab['lang']['en'];
                }
                $oTab->name = $aTmpLang;
                $oTab->class_name = $sAdminClassName;
                $oTab->module = \FacebookProductAd::$oModule->name;
                $oTab->id_parent = \Tab::getIdFromClassName($aTab['parent']);

    
                // save admin tab
                if (false == $oTab->save()) {
                    $bReturn = false;
                }
            }
        }
        // destruct
        unset($mParam);
        unset($oTab);

        return $bReturn;
    }

    /**
     * method uninstall of module
     *
     * @param mixed $mParam
     * @return bool $bReturn : true => validate uninstall, false => invalidate uninstall
     */
    public static function uninstall($mParam = null)
    {
        // set return execution
        $bReturn = true;

        // loop on each admin tab
        foreach (moduleConfiguration::FPA_TABS as $sAdminClassName => $aTab) {
            // get ID
            $iTabId = Tab::getIdFromClassName($sAdminClassName);

            if (!empty($iTabId)) {
                // instantiate
                $oTab = new Tab($iTabId);

                // use case - check delete
                if (false == $oTab->delete()) {
                    $bReturn = false;
                } else {
                    if (!defined('_PS_IMG_DIR')) {
                        define('_PS_IMG_DIR', _PS_ROOT_DIR_ . '/img/');
                    }
                    if (file_exists(_PS_IMG_DIR . 't/' . $sAdminClassName . '.gif')) {
                        @unlink(_PS_IMG_DIR . 't/' . $sAdminClassName . '.gif');
                    }
                }
                unset($oTab);
            }
        }
        unset($mParam);

        return $bReturn;
    }
}