<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

/**
 * declare Dynamic tags Exception class
 */

namespace FacebookProductAd\Pixel;

use FacebookProductAd\Configuration\moduleConfiguration;

class BT_DynPixelException extends \Exception
{
}

abstract class basePixel
{
    /**
     * @var string $sName : stock tag type name
     */
    public static $sName = '';

    /**
     * @var string $sQuote : character used for tagging values
     */
    public static $sQuote = '\'';

    /**
     * @var string $sOpenTag : character used for open complex tag
     */
    public static $sOpenTag = '[';

    /**
     * @var string $sOpenTag : character used for open complex tag
     */
    public static $sCloseTag = ']';

    /**
     * @var bool $aPageInfo : current page information
     */
    public $aPageInfo = array();

    /**
     * @var bool $bValid : current object valid or not
     */
    public $bValid = false;

    /**
     * @var bool $bValid : current object valid or not
     */
    public $sTrakingType = '';

    /**
     * @var string $sContent_type : type of content ( see FPA_AUDIENCE_TYPE to have allow values )
     */
    public $sContent_type = null;

    /**
     * @var string $sContent_ids : the content ids for the tag
     */
    public $sContent_ids = null;

    /**
     * @var string $sContent_name : content the name
     */
    public $sContent_name = null;

    /**
     * @var string $sContent_Category : content cotent category path
     */
    public $sContent_Category = null;

    /**
     * @var string $fValue : the float value ex price
     */
    public $fValue = null;

    /**
     * @var string $sCurrency : the currency
     */
    public $sCurrency = null;

    /**
     * @var string $sQuerySearch : the search result
     */
    public $sQuerySearch = null;

    /**
     * @var array $aJsParams : get the JS params for some pages need to include JS code
     */
    public $aJsParams = false;

    /**
     * @var string $sJsCode : the JS code
     */
    public $sJsCode = '';

    /**
     * @var array $aProducts : current products
     */
    public $aProducts = array();

    /**
     * get params keys
     *
     * @param array $aParams
     */
    abstract public function __construct(array $aParams);

    /**
     * method set content type
     */
    abstract public function setTrackingType();

    /**
     * method set content type
     */
    abstract public function setContentType();

    /**
     * method set ContentIds
     */
    abstract public function setContentIds();

    /**
     * method set content name
     */
    abstract public function setContentName();

    /**
     * setCategory() method set Content Categoru
     */
    abstract public function setContentCategory();

    /**
     * method set value like a price
     */
    abstract public function setValue();

    /**
     * method set currency
     */
    abstract public function setCurrency();

    /**
     * method set query search
     */
    abstract public function setQuerySearch();

    /**
     * method set the code for conversion API
     */
    abstract public function setApiData();
    /**
     * method set values
     *
     * @param string $sTagsType
     * @param array $aParams
     * @return obj tags type abstract type
     */
    public function set()
    {
        // set tracking type
        $this->setTrackingType();

        // set content type
        $this->setContentType();

        // set Content ids
        $this->setContentIds();

        // set Content name
        $this->setContentName();

        //set the content category
        $this->setContentCategory();

        // set price value
        $this->setValue();

        // set the currency
        $this->setCurrency();

        // set the query search
        $this->setQuerySearch();

        // set the JS code
        $this->setApiData();
    }

    /**
     * method display properties
     *
     * @return array of properties + labels
     */
    public function display()
    {
        $aProperties = array();

        if (!empty($this->sTrakingType)) {
            $aProperties['tracking_type'] = array('label' => 'tracking_type', 'value' => $this->sTrakingType);
        }

        if (!empty($this->sContent_type)) {
            $aProperties['content_type'] = array('label' => 'content_type', 'value' => $this->sContent_type);
        }

        if (!empty($this->sContent_ids)) {
            $aProperties['content_ids'] = array('label' => 'content_ids', 'value' => $this->sContent_ids);
        }

        $aProperties['value'] = array('label' => 'value', 'value' => $this->fValue);

        if (!empty($this->sQuerySearch)) {
            $aProperties['search_string'] = array('label' => 'search_string', 'value' => $this->sQuerySearch);
        }

        if (!empty($this->sCurrency)) {
            $aProperties['currency'] = array('label' => 'currency', 'value' => $this->sCurrency);
        }

        if (!empty($this->sContent_name)) {
            $aProperties['content_name'] = array('label' => 'content_name', 'value' => $this->sContent_name);
        }

        if (!empty($this->sContent_Category)) {
            $aProperties['content_category'] = array(
                'label' => 'content_category',
                'value' => $this->sContent_Category
            );
        }

        if (!empty($this->sJsCode)) {
            $aProperties['js_code'] = array('label' => 'js_code', 'value' => $this->sJsCode);
        }

        return $aProperties;
    }

    /**
     * method instantiate matched connector object
     *
     * @param string $sEventType
     * @param array $aParams
     * @throws
     * @return obj tags type abstract type
     */
    public static function get($sTagsType, array $aParams = null)
    {
        // only call on predefined events
        if (in_array($sTagsType, array_keys(moduleConfiguration::FPA_TAGS_TYPE))) {

            if ($sTagsType == 'home') {
                return new pixelHome($aParams);
            } else if ($sTagsType == 'bestsales') {
                return new pixelBestSales($aParams);
            } else if ($sTagsType == 'category') {
                return new pixelCategory($aParams);
            } else if ($sTagsType == 'search') {
                return new pixelSearch($aParams);
            } else if ($sTagsType == 'promotion') {
                return new pixelPromotion($aParams);
            } else if ($sTagsType == 'product') {
                return new pixelProduct($aParams);
            } else if ($sTagsType == 'other') {
                return new pixelOther($aParams);
            } else if ($sTagsType == 'newproducts') {
                return new pixelNewProducts($aParams);
            } else if ($sTagsType == 'manufacturer') {
                return new pixelManufacturer($aParams);
            } else if ($sTagsType == 'cart') {
                return new pixelCart($aParams);
            } else if ($sTagsType == 'checkout') {
                return new pixelCheckout($aParams);
            } else if ($sTagsType == 'purchase') {
                return new pixelPurchase($aParams);
            } else if ($sTagsType == 'contact') {
                return new pixelContact($aParams);
            }
        } else {
            throw new BT_DynPixelException(\FacebookProductAd::$oModule->l('Internal server error => invalid dynamic tags type', 'base-dynamic-tags_class'), 510);
        }
    }
}
