<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */
namespace FacebookProductAd\Pixel;

use FacebookProductAd\FacebookApi\FacebookClient;
use FacebookProductAd\ModuleLib\moduleTools;
use FacebookProductAd\Pixel\basePixel;

class pixelCart extends basePixel
{

    /**
     * @var bool $iCartId : current object is a cart
     */
    public $iCartId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        // use case - detect if we've got JS params
        $this->aJsParams = !empty($aParams['js']) && is_array($aParams['js']) ? $aParams['js'] : false;

        //get the cart id
        $this->iCartId = $aParams['iCartId'];

        $this->oCart = new \Cart((int) $this->iCartId);

        if (!empty($this->oCart)) {
            $this->aProducts = $this->oCart->getProducts();

            if (!empty($this->aProducts)) {
                $this->bValid = true;

                //get the context information
                $this->sCurrentLang = new \Language((int) \Context::getContext()->cookie->id_lang);
            }
        }
    }

    /**
     * method set the content type
     */
    public function setTrackingType()
    {
        if (!empty(\FacebookProductAd::$conf['FPA_TRACK_ADD_CART_PAGE'])) {
            $this->sTrakingType = 'AddToCart';
        } else {
            $this->sTrakingType = 'PageView';
        }
    }

    /**
     * method set the content type
     */
    public function setContentType()
    {
        if (!empty(\FacebookProductAd::$conf['FPA_TRACK_ADD_CART_PAGE'])) {
            $this->sContent_type = 'product';
        }
    }

    /**
     * method set the content ids
     */
    public function setContentIds()
    {
        $this->sContent_ids = ModuleTools::buildContentIds('product_listing', $this->sCurrentLang->iso_code, null, $this->aProducts);
    }

    /**
     * method set the content name
     */
    public function setContentName()
    {
    }

    /**
     * method set total value
     */
    public function setValue()
    {

        // get the cart amount
        $this->fValue = $this->oCart->getOrderTotal();
    }

    /**
     * method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = \Context::getContext()->currency->iso_code;
    }

    /**
     * method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * method set the code for conversion API
     */
    public function setApiData()
    {
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
            $data = '{
                    "data": [
                        {
                            "event_name": "' . $this->sTrakingType . '",
                            "event_time": ' . time() . ',
                            "action_source": "website",
                            "event_id": "' . $user_data['event_id'] . '",
                            "user_data": {
                                "em": "' . $user_data['em']  . '",
                                "ph": "' . $user_data['ph']  . '",
                                "fn": "' . $user_data['fn']  . '",
                                "ln": "' . $user_data['ln']  . '",
                                "db": "' . $user_data['db']  . '",
                                "ge": "' . $user_data['ge']  . '",
                                "ct": "' . $user_data['ct']  . '",
                                "st": "' . $user_data['st']  . '",
                                "zp": "' . $user_data['zp']  . '",
                                "country": "' . $user_data['country']  . '",
                                "external_id": "' . $user_data['external_id']  . '",
                                "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                "client_user_agent": "' . $user_data['client_user_agent']  . '"
                            },
                            "custom_data": {
                                "content_category": "' . $this->sContent_Category . '",
                                "content_ids": "' . $this->sContent_ids . '",
                                "content_name": "' .  $this->sContent_name . '",
                                "content_type": "product",
                            }
                        }
                    ],

                }';
        } else {
            $data = '{
                "data": [
                    {
                        "event_name": "' . $this->sTrakingType . '",
                        "event_time": ' . time() . ',
                        "action_source": "website",
                        "event_id": "' . $user_data['event_id'] . '",
                        "user_data": {
                            "em": "' . $user_data['em']  . '",
                            "ph": "' . $user_data['ph']  . '",
                            "fn": "' . $user_data['fn']  . '",
                            "ln": "' . $user_data['ln']  . '",
                            "db": "' . $user_data['db']  . '",
                            "ge": "' . $user_data['ge']  . '",
                            "zp": "' . $user_data['zp']  . '",
                            "country": "' . $user_data['country']  . '",
                            "external_id": "' . $user_data['external_id']  . '",
                            "client_user_agent": "' . $user_data['client_user_agent']  . '"
                        },
                        "custom_data": {
                            "content_category": "' . $this->sContent_Category . '",
                            "content_ids": "' . $this->sContent_ids . '",
                            "content_name": "' .  $this->sContent_name . '",
                            "content_type": "product",
                        }
                    }
                ],

            }';
        }

        FacebookClient::send($data);
    }
}
