<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Pixel;

use FacebookProductAd\Configuration\moduleConfiguration;
use FacebookProductAd\FacebookApi\FacebookClient;
use FacebookProductAd\ModuleLib\moduleTools;
use FacebookProductAd\Pixel\basePixel;

class pixelHome extends basePixel
{
    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;
        $aProductIds = array();

        //get the context information
        $this->sCurrentLang = new \Language((int)\Context::getContext()->cookie->id_lang);

        //get the information from module installed in the homepage
        foreach (moduleConfiguration::getHomeModules() as $sModuleName => $aParams) {
            if (
                method_exists($aParams['callback']['class'], $aParams['callback']['method'])
                && moduleTools::isInstalled($sModuleName)
            ) { // get populated products

                $aProductsData = call_user_func_array(array(
                    $aParams['callback']['class'],
                    $aParams['callback']['method']
                ), array($sModuleName, $aParams['limit']));

                if (!empty($aProductsData)) {
                    foreach ($aProductsData as $id => $aProduct) {
                        $aProductIds[] = $aProduct['id_product'];
                    }
                }
            }
        }

        $this->aProducts = array_unique($aProductIds);

        if (!empty($this->aProducts)) {
            $this->bValid = true;
        }
    }

    /**
     * method set the content type
     */
    public function setTrackingType()
    {

        if (!empty(\FacebookProductAd::$conf['FPA_TRACK_HOME'])) {
            $this->sTrakingType = 'ViewContentHomepage';
        } else {
            $this->sTrakingType = 'PageView';
        }
    }

    /**
     * method set the content type
     */
    public function setContentType()
    {
        if (!empty(\FacebookProductAd::$conf['FPA_TRACK_HOME'])) {
            $this->sContent_type = 'product';
        }
    }

    /**
     * method set the content ids
     */
    public function setContentIds()
    {
        $this->sContent_ids = ModuleTools::buildContentIds('product_listing', $this->sCurrentLang->iso_code, null, $this->aProducts);
    }

    /**
     * method set the content name
     */
    public function setContentName()
    {
        $this->sContent_name = 'Homepage';
    }

    /**
     * method set total value
     */
    public function setValue()
    {
    }

    /**
     * method the currency
     */
    public function setCurrency()
    {
    }

    /**
     * method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * method set the category values
     */
    public function setContentCategory()
    {
        $this->sContent_Category = 'Homepage';
    }

    /**
     * method set the code for conversion API
     */
    public function setApiData()
    {
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
            $data = '{
                    "data": [
                        {
                            "event_name": "ViewContentHomepage",
                            "event_time": ' . time() . ',
                            "action_source": "website",
                            "event_id": "' . $user_data['event_id'] . '",
                            "user_data": {
                                "em": "' . $user_data['em']  . '",
                                "ph": "' . $user_data['ph']  . '",
                                "fn": "' . $user_data['fn']  . '",
                                "ln": "' . $user_data['ln']  . '",
                                "db": "' . $user_data['db']  . '",
                                "ge": "' . $user_data['ge']  . '",
                                "ct": "' . $user_data['ct']  . '",
                                "st": "' . $user_data['st']  . '",
                                "zp": "' . $user_data['zp']  . '",
                                "country": "' . $user_data['country']  . '",
                                "external_id": "' . $user_data['external_id']  . '",
                                "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                "client_user_agent": "' . $user_data['client_user_agent']  . '"
                            },
                            "custom_data": {
                                "content_category": "' . $this->sContent_Category . '",
                                "content_ids": "' . $this->sContent_ids . '",
                                "content_name": "' .  $this->sContent_name . '",
                                "content_type": "product",
                            }
                        }
                    ],

                }';
        } else {
            $data = '{
                "data": [
                    {
                        "event_name": "ViewContentHomepage",
                        "event_time": ' . time() . ',
                        "action_source": "website",
                        "event_id": "' . $user_data['event_id'] . '",
                        "user_data": {
                            "em": "' . $user_data['em']  . '",
                            "ph": "' . $user_data['ph']  . '",
                            "fn": "' . $user_data['fn']  . '",
                            "ln": "' . $user_data['ln']  . '",
                            "db": "' . $user_data['db']  . '",
                            "ge": "' . $user_data['ge']  . '",
                            "zp": "' . $user_data['zp']  . '",
                            "country": "' . $user_data['country']  . '",
                            "external_id": "' . $user_data['external_id']  . '",
                            "client_user_agent": "' . $user_data['client_user_agent']  . '"
                        },
                        "custom_data": {
                            "content_category": "' . $this->sContent_Category . '",
                            "content_ids": "' . $this->sContent_ids . '",
                            "content_name": "' .  $this->sContent_name . '",
                            "content_type": "product",
                        }
                    }
                ],

            }';
        }

        FacebookClient::send($data);
    }
}
