<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Pixel;

use FacebookProductAd\FacebookApi\FacebookClient;
use FacebookProductAd\ModuleLib\moduleTools;
use FacebookProductAd\Pixel\basePixel;

class pixelProduct extends basePixel
{
    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iProductId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        //get the product id
        $this->iProductId = isset($aParams['iProductId']) ? $aParams['iProductId'] : false;

        if (!empty($this->iProductId)) {
            $this->bValid = true;

            // use case - detect if we've got JS params
            $this->aJsParams = !empty($aParams['js']) && is_array($aParams['js']) ? $aParams['js'] : false;

            // get the current object
            $this->oProduct = new \Product($this->iProductId, true);
            //get context information
            $this->sCurrentLang = new \Language(\Context::getContext()->cookie->id_lang);
        }
    }

    /**
     * method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = 'ViewContent';
    }

    /**
     * method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = 'product';
    }

    /**
     * method set the content ids
     */
    public function setContentIds()
    {
        $this->sContent_ids = ModuleTools::buildContentIds('product', $this->sCurrentLang->iso_code, $this->iProductId);
    }

    /**
     * method set the content name
     */
    public function setContentName()
    {
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $this->sContent_name = str_replace(array('\'', '"'), ' ', $this->oProduct->name[\FacebookProductAd::$iCurrentLang]);
        }
    }

    /**
     * method set total value
     */
    public function setValue()
    {
        // Use tax according to the option
        $bUseTax = !empty(\FacebookProductAd::$conf['FPA_PROD_PRICE_TAX']) ? true : false;

        // get the static Price with the default function from PS
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $this->fValue = \Product::getPriceStatic($this->iProductId, $bUseTax, false, 2, null, false, true);
        }
    }

    /**
     * method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = \Context::getContext()->currency->iso_code;
    }

    /**
     * method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * method set the category values
     */
    public function setContentCategory()
    {
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $oCategory = new \Category($this->oProduct->id_category_default, \FacebookProductAd::$iCurrentLang);
            if (!empty($oCategory) && is_object($oCategory)) {
                $this->sContent_Category = str_replace(array('\'', '"'), ' ', $oCategory->name);
            }
        }
    }

    /**
     * method set the code for conversion API
     */
    public function setApiData()
    {
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
            $data = '{
                    "data": [
                        {
                            "event_name": "ViewContent",
                            "event_time": ' . time() . ',
                            "action_source": "website",
                            "event_id": "' . $user_data['event_id'] . '",
                            "user_data": {
                                "em": "' . $user_data['em']  . '",
                                "ph": "' . $user_data['ph']  . '",
                                "fn": "' . $user_data['fn']  . '",
                                "ln": "' . $user_data['ln']  . '",
                                "db": "' . $user_data['db']  . '",
                                "ge": "' . $user_data['ge']  . '",
                                "ct": "' . $user_data['ct']  . '",
                                "st": "' . $user_data['st']  . '",
                                "zp": "' . $user_data['zp']  . '",
                                "country": "' . $user_data['country']  . '",
                                "external_id": "' . $user_data['external_id']  . '",
                                "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                "client_user_agent": "' . $user_data['client_user_agent']  . '"
                            },
                            "custom_data": {
                                "content_category": "' . $this->sContent_Category . '",
                                "content_ids": "' . $this->sContent_ids . '",
                                "content_name": "' .  $this->sContent_name . '",
                                "content_type": "product",
                            }
                        }
                    ],

                }';
        } else {
            $data = '{
                "data": [
                    {
                        "event_name": "ViewContent",
                        "event_time": ' . time() . ',
                        "action_source": "website",
                        "event_id": "' . $user_data['event_id'] . '",
                        "user_data": {
                            "em": "' . $user_data['em']  . '",
                            "ph": "' . $user_data['ph']  . '",,
                            "fn": "' . $user_data['fn']  . '",
                            "ln": "' . $user_data['ln']  . '",
                            "db": "' . $user_data['db']  . '",
                            "ge": "' . $user_data['ge']  . '",
                            "zp": "' . $user_data['zp']  . '",
                            "country": "' . $user_data['country']  . '",
                            "external_id": "' . $user_data['external_id']  . '",
                            "client_user_agent": "' . $user_data['client_user_agent']  . '"
                        },
                        "custom_data": {
                            "content_category": "' . $this->sContent_Category . '",
                            "content_ids": "' . $this->sContent_ids . '",
                            "content_name": "' .  $this->sContent_name . '",
                            "content_type": "product",
                        }
                    }
                ],

            }';
        }

        FacebookClient::send($data);
    }
}
