<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */
namespace FacebookProductAd\Pixel;

use FacebookProductAd\FacebookApi\FacebookClient;
use FacebookProductAd\ModuleLib\moduleTools;
use FacebookProductAd\Pixel\basePixel;

class pixelSearch extends basePixel
{
    /**
     * @var string $sQuery : the query to search
     */
    public $sQuery = array();

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        // get the search query
        $sQuery = \Tools::getValue('s');

        // Sometimes the param is q
        if (empty($sQuery)) {
            $sQuery = \Tools::getValue('q');
        }

        $this->sQuery = $sQuery;

        //handle the pagnitation
        $iPostPage = \Tools::getValue('p');
        $iPostProductPerPage = \Tools::getValue('n');

        $iPage = !empty($iPostPage) ? $iPostPage : 0;
        $iProductPerPage = !empty($iPostProductPerPage) ? $iPostProductPerPage : \Configuration::get('PS_PRODUCTS_PER_PAGE');

        // get the search results
        $this->aProducts = \Search::find(\FacebookProductAd::$iCurrentLang,$this->sQuery,$iPage,$iProductPerPage,'position','desc');

        if (!empty($this->aProducts['result'])) {
            $this->bValid = true;
        }

        //get the context information
        $this->sCurrentLang = new \Language((int) \Context::getContext()->cookie->id_lang);
    }

    /**
     * method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = 'Search';
    }

    /**
     * method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = 'product';
    }

    /**
     * method set the content ids
     */
    public function setContentIds()
    {
        $this->sContent_ids = ModuleTools::buildContentIds('product_listing', $this->sCurrentLang->iso_code, null, $this->aProducts['result']);
    }

    /**
     * method set the content name
     */
    public function setContentName()
    {
    }

    /**
     * method set total value
     */
    public function setValue()
    {
    }

    /**
     * method the currency
     */
    public function setCurrency()
    {
    }

    /**
     * method the query search
     */
    public function setQuerySearch()
    {
        //get the search query
        $this->sQuerySearch = $this->sQuery;
    }

    /**
     * method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * method set the code for conversion API
     */
    public function setApiData(){
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
            $data = '{
                    "data": [
                        {
                            "event_name": "Search",
                            "event_time": ' . time() . ',
                            "action_source": "website",
                            "event_id": "' . $user_data['event_id'] . '",
                            "user_data": {
                                "em": "' . $user_data['em']  . '",
                                "ph": "' . $user_data['ph']  . '",
                                "fn": "' . $user_data['fn']  . '",
                                "ln": "' . $user_data['ln']  . '",
                                "db": "' . $user_data['db']  . '",
                                "ge": "' . $user_data['ge']  . '",
                                "ct": "' . $user_data['ct']  . '",
                                "st": "' . $user_data['st']  . '",
                                "zp": "' . $user_data['zp']  . '",
                                "country": "' . $user_data['country']  . '",
                                "external_id": "' . $user_data['external_id']  . '",
                                "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                "client_user_agent": "' . $user_data['client_user_agent']  . '"
                            },
                            "custom_data": {
                                "content_category": "' . $this->sContent_Category . '",
                                "content_ids": "' . $this->sContent_ids . '",
                                "content_name": "' .  $this->sContent_name . '",
                                "content_type": "product",
                            }
                        }
                    ],

                }';
        } else {
            $data = '{
                "data": [
                    {
                        "event_name": "Search",
                        "event_time": ' . time() . ',
                        "action_source": "website",
                        "event_id": "' . $user_data['event_id'] . '",
                        "user_data": {
                            "em": "' . $user_data['em']  . '",
                            "ph": "' . $user_data['ph']  . '",
                            "fn": "' . $user_data['fn']  . '",
                            "ln": "' . $user_data['ln']  . '",
                            "db": "' . $user_data['db']  . '",
                            "ge": "' . $user_data['ge']  . '",
                            "zp": "' . $user_data['zp']  . '",
                            "country": "' . $user_data['country']  . '",
                            "external_id": "' . $user_data['external_id']  . '",
                            "client_user_agent": "' . $user_data['client_user_agent']  . '"
                        },
                        "custom_data": {
                            "content_category": "' . $this->sContent_Category . '",
                            "content_ids": "' . $this->sContent_ids . '",
                            "content_name": "' .  $this->sContent_name . '",
                            "content_type": "product",
                        }
                    }
                ],

            }';
        }

        FacebookClient::send($data);
    }
}
