<?php
/**
 * Copyright ETS Software Technology Co., Ltd
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 website only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future.
 *
 * @author ETS Software Technology Co., Ltd
 * @copyright  ETS Software Technology Co., Ltd
 * @license    Valid for 1 website (or project) for each purchase of license
 **/

/**
 * Class EtsGeoConfigService
 */
class EtsGeoConfigService
{
    const MSG_KEY_PREFIX = 'ETS_GEO_';
    const MSG_KEY_SURFIX = '_MSG';

    /**
     * @var \EtsGeoConfigService
     */
    private static $_instance;

    /**
     * @var \Context|\ContextCore
     */
    private $_context;

    /**
     * @return \EtsGeoConfigService
     */
    public static function getInstance()
    {
        if (!self::$_instance instanceof self) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * @return bool
     */
    public function isModuleEnabled()
    {
        return (bool) Configuration::get('PS_GEOLOCATION_ENABLED');
    }

    /**
     * @return bool
     */
    public function isBotAndIgnored()
    {
        if (isset($_SERVER['HTTP_USER_AGENT']) && (int) Configuration::get('ETS_GEO_IGNORE_BOTS') && preg_match('/BotLink|ahoy|AlkalineBOT|anthill|appie|arale|araneo|AraybOt|ariadne|arks|ATN_Worldwide|Atomz|bbot|Bjaaland|Ukonline|borg\-bot\/0\.9|boxseabot|bspider|calif|christcrawler|CMC\/0\.01|combine|confuzzledbot|CoolBot|cosmos|Internet Cruiser Robot|cusco|cyberspyder|cydralspider|desertrealm, desert realm|digger|DIIbot|grabber|downloadexpress|DragonBot|dwcp|ecollector|ebiness|elfinbot|esculapio|esther|fastcrawler|FDSE|FELIX IDE|ESI|fido|H�m�h�kki|KIT\-Fireball|fouineur|Freecrawl|gammaSpider|gazz|gcreep|golem|googlebot|griffon|Gromit|gulliver|gulper|hambot|havIndex|hotwired|htdig|iajabot|INGRID\/0\.1|Informant|InfoSpiders|inspectorwww|irobot|Iron33|JBot|jcrawler|Teoma|Jeeves|jobo|image\.kapsi\.net|KDD\-Explorer|ko_yappo_robot|label\-grabber|larbin|legs|Linkidator|linkwalker|Lockon|logo_gif_crawler|marvin|mattie|mediafox|MerzScope|NEC\-MeshExplorer|MindCrawler|udmsearch|moget|Motor|msnbot|muncher|muninn|MuscatFerret|MwdSearch|sharp\-info\-agent|WebMechanic|NetScoop|newscan\-online|ObjectsSearch|Occam|Orbsearch\/1\.0|packrat|pageboy|ParaSite|patric|pegasus|perlcrawler|phpdig|piltdownman|Pimptrain|pjspider|PlumtreeWebAccessor|PortalBSpider|psbot|Getterrobo\-Plus|Raven|RHCS|RixBot|roadrunner|Robbie|robi|RoboCrawl|robofox|Scooter|Search\-AU|searchprocess|Senrigan|Shagseeker|sift|SimBot|Site Valet|skymob|SLCrawler\/2\.0|slurp|ESI|snooper|solbot|speedy|spider_monkey|SpiderBot\/1\.0|spiderline|nil|suke|http:\/\/www\.sygol\.com|tach_bw|TechBOT|templeton|titin|topiclink|UdmSearch|urlck|Valkyrie libwww\-perl|verticrawl|Victoria|void\-bot|Voyager|VWbot_K|crawlpaper|wapspider|WebBandit\/1\.0|webcatcher|T\-H\-U\-N\-D\-E\-R\-S\-T\-O\-N\-E|WebMoose|webquest|webreaper|webs|webspider|WebWalker|wget|winona|whowhere|wlm|WOLP|WWWC|none|XGET|Nederland\.zoek|AISearchBot|woriobot|NetSeer|Nutch|YandexBot/iu', $_SERVER['HTTP_USER_AGENT'])) {
            return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function isBackoffice()
    {
        return defined('_PS_ADMIN_DIR_');
    }

    /**
     * @return bool
     */
    public function isAjaxRequest()
    {
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') {
            return true;
        }

        return Tools::isSubmit('ajax');
    }

    /**
     * @param string $isoCode
     *
     * @return self
     */
    public function setCookieCountryIso($isoCode)
    {
        $this->getContext()->cookie->iso_code_country = $isoCode;
        $this->getContext()->cookie->write();

        return $this;
    }

    /**
     * @param bool $val
     *
     * @return self
     */
    public function setGeoRedirected($val)
    {
        $this->getContext()->cookie->geoRedirected = (bool) $val;
        $this->getContext()->cookie->write();

        return $this;
    }

    /**
     * @return bool
     */
    public function isGeoRedirected()
    {
        return (bool) $this->getContext()->cookie->geoRedirected;
    }

    /**
     * @param bool $val
     *
     * @return self
     */
    public function setGeoAutoCountryProcessed($val)
    {
        $this->getContext()->cookie->ets_geocountryloaded = (bool) $val;
        $this->getContext()->cookie->write();

        return $this;
    }

    /**
     * @return bool
     */
    public function isGeoAutoCountryProcessed()
    {
        return (bool) $this->getContext()->cookie->ets_geocountryloaded;
    }

    /**
     * @return bool
     */
    public function isWorkingOnHomePageOnly()
    {
        return (bool) Configuration::get('ETS_GEO_ON_HOME_ONLY');
    }

    /**
     * @return bool
     */
    public function isAutoSetLang()
    {
        return (bool) Configuration::get('ETS_GEO_AUTO_LANG');
    }

    /**
     * @return bool
     */
    public function isAutoSetTax()
    {
        return (bool) Configuration::get('ETS_GEO_AUTO_TAX_SHIPPING');
    }

    /**
     * @return bool
     */
    public function isAutoSetCurrency()
    {
        return (bool) Configuration::get('ETS_GEO_AUTO_CURRENCY');
    }

    /**
     * @return bool
     */
    public function isShowSwitchNav()
    {
        return (bool) Configuration::get('ETS_GEO_ENABLE_SWITCH');
    }

    /**
     * @return bool
     */
    public function isShowConfirmPopup()
    {
        return (bool) Configuration::get('ETS_GEO_HIDE_NOTIFICATION');
    }

    /**
     * @param string $key
     * @param int $langId
     *
     * @return string|false
     */
    public function getMessage($key, $langId)
    {
        if (self::strStartsWith($key, self::MSG_KEY_PREFIX)) {
            return Configuration::get($key, $langId);
        }
        $keysMap = [
            'disabledproduct' => 'DISABLED_PRODUCT',
            'confirm' => 'CONFIRM',
            'language' => 'LANGUAGE',
            'changelanguage' => 'LANGUAGE',
            'currency' => 'CURRENCY',
            'changecurrency' => 'CURRENCY',
            'setting' => 'SETTING',
            'choose' => 'CHOOSE',
            'blog' => 'BLOG',
            'block' => 'BLOG',
        ];
        if (array_key_exists(strtolower($key), $keysMap)) {
            $key = sprintf('%s%s%s', self::MSG_KEY_PREFIX, $keysMap[strtolower($key)], self::MSG_KEY_SURFIX);

            return Configuration::get($key, $langId);
        }

        return false;
    }

    /**
     * @param string $text
     * @param array|\Language $lang
     * @param string $file
     *
     * @return string|null
     */
    public function getTextLang($text, $lang, $file = '')
    {
        $name = 'ets_geolocation';
        if ($lang instanceof \Language) {
            $lang = get_object_vars($lang);
        }
        $modulePath = rtrim(_PS_MODULE_DIR_, '/') . '/' . $name;
        $fileTransDir = $modulePath . '/translations/' . $lang['iso_code'] . '.php';
        if (!@file_exists($fileTransDir)) {
            return null;
        }
        $fileContent = Tools::file_get_contents($fileTransDir);
        $strMd5 = md5($text);
        $keyMd5 = '<{' . $name . '}prestashop>' . ($file ?: $name) . '_' . $strMd5;
        preg_match('/(\$_MODULE\[\'' . preg_quote($keyMd5, '/') . '\'\]\s*=\s*\')(.*)(\';)/', $fileContent, $matches);
        if ($matches && isset($matches[2])) {
            return $matches[2];
        }

        return null;
    }

    /**
     * @param string $haystack
     * @param string $needle
     *
     * @return bool
     */
    public static function strStartsWith($haystack, $needle)
    {
        return 0 === strncmp($haystack, $needle, \strlen($needle));
    }

    /**
     * @param string $haystack
     * @param string $needle
     *
     * @return bool
     */
    public static function strEndsWith($haystack, $needle)
    {
        if ('' === $needle || $needle === $haystack) {
            return true;
        }

        if ('' === $haystack) {
            return false;
        }

        $needleLength = \strlen($needle);

        return $needleLength <= \strlen($haystack) && 0 === substr_compare($haystack, $needle, -$needleLength);
    }

    /**
     * @return \Context|\ContextCore
     */
    public function getContext()
    {
        if (!$this->_context instanceof \ContextCore) {
            $this->_context = Context::getContext();
        }

        return $this->_context;
    }
}
