<?php
/**
* 2017 Manfredi Petruso
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to manfredi.petruso@fabvla.com so we can send you a copy immediately.
*
*
*  @author    Manfredi Petruso <manfredi.petruso@fabvla.com>
*  @copyright  2017 Manfredi Petruso
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/

class FabFacebookPixelAjaxController extends ModuleAdminController
{
    public $ssl = true;

    
    protected function ajaxProcessFetchGoogleCategories()
    {
        $googleCategoryFileBaseUrl = "https://www.google.com/basepages/producttype/";
        $result = true;
        $activeLangs = Language::getLanguages(true);
        foreach ($activeLangs as $activeLang) {
            $ISOCode = '';
            if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
                $ISOCodeArray  = explode("-", $activeLang["language_code"]);
                $ISOCode = $ISOCodeArray[0].'-'.Tools::strtoupper($ISOCodeArray[1]);
            } else {
                $ISOCode = $activeLang["locale"];
            }
            
            $googleCategoryFile = "taxonomy-with-ids.".$ISOCode.".txt";
            
            $checkResponse = $this->getData($googleCategoryFileBaseUrl.$googleCategoryFile, 500, true);
            
            if (strpos($checkResponse['status'], '200') == false) {
                $googleCategoryFile = "taxonomy-with-ids.en-US.txt";
            }
               
            $googleCategoryData = Tools::file_get_contents(
                $googleCategoryFileBaseUrl.$googleCategoryFile,
                false,
                @stream_context_create(array('https' => array('method' => 'GET', 'timeout' => 5000)))
            );
                
            $googleCategoryArray = explode(PHP_EOL, $googleCategoryData);
            
            foreach ($googleCategoryArray as $i => $item) {
                if ($i < 1) {
                    continue;
                }
                $splittedElement = explode(" - ", $item, 2);
                if (sizeof($splittedElement) > 1) {
                    $this->insertGoogleCategories($splittedElement[0], $ISOCode, $splittedElement[1]);
                }
            }
        }
        Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH_DATE', date("D M d, Y G:i"));
        Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH', 1);
        header('Content-Type: application/json');
        die(json_encode(array(
            'result' => $result
        )));
    }
    
    
    protected function ajaxProcessAssociateCategory()
    {
        $result = true;
        $id_category = Tools::getValue('id_category');
        $id_google_category = Tools::getValue('id_google_category');
        $result = $this->insertCategories($id_category, $id_google_category);
        
        header('Content-Type: application/json');
        die(json_encode(array(
            'result' => $result
        )));
    }
    
    protected function ajaxProcessDiscardReferenceWarning()
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        Configuration::updateGlobalValue('FAB_PIXEL_USE_REFERENCE', 0);
        Configuration::updateValue('FAB_PIXEL_USE_REFERENCE', 0, false, $id_shop_group, $id_shop);
        $result = true;
        
        header('Content-Type: application/json');
        die(json_encode(array(
            'result' => $result
        )));
    }

    protected function insertCategories($id_category, $id_google_category)
    {
        $shop_groups_list = array();
        $shops = Shop::getContextListShopID();
    
        foreach ($shops as $shop_id) {
            $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

            if (!in_array($shop_group_id, $shop_groups_list)) {
                $shop_groups_list[] = $shop_group_id;
            }
        
            $sql = "INSERT INTO "._DB_PREFIX_."fabfacebookpixel  
	                (id_category, id_google_category, id_shop)
	                VALUES
	                (".(int)$id_category.", '".(int)$id_google_category."', ".(int)$shop_id.")
	               ON DUPLICATE KEY UPDATE id_google_category = VALUES(id_google_category)";
            if (!Db::getInstance()->execute($sql)) {
                return false;
            }
        }
        return true;
    }
   
    protected function insertGoogleCategories($id_google_category, $iso_code, $google_category_description)
    {
        $sql = "INSERT INTO "._DB_PREFIX_."fabfacebookpixel_gc_lang 
	            (id_google_category, iso_code, google_category_description)
	            VALUES
	                (".(int)$id_google_category.", '".pSQL($iso_code)."', '".pSQL(addslashes($google_category_description))."')
	            ON DUPLICATE KEY UPDATE google_category_description = VALUES(google_category_description)";

        if (!Db::getInstance()->execute($sql)) {
            return false;
        }
        
        return true;
    }
   
   
    protected function getData($url, $timeout, $checkstatusonly)
    {
        $ch = curl_init();
        
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        if ($checkstatusonly) {
            curl_setopt($ch, CURLOPT_HEADER, 1);
            curl_setopt($ch, CURLOPT_NOBODY, 1);
        }
        $output = curl_exec($ch);
        
        curl_close($ch);
        
        if ($checkstatusonly) {
            $headers=array();
            $data=explode("\n", $output);
            $headers['status']=$data[0];
            return $headers;
        }
        
        return $output;
    }
}
