<?php
/**
 * 2017 Manfredi Petruso
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to manfredi.petruso@fabvla.com so we can send you a copy immediately.
 *
 *
 *  @author    Manfredi Petruso <manfredi.petruso@fabvla.com>
 *  @copyright  2017 Manfredi Petruso
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}


class FabFacebookPixelAjaxModuleFrontController extends ModuleFrontController
{

    protected $result;
    public $ssl = true;

    public function __construct()
    {
        $this->className = 'FrontFabFacebookPixelController';
        parent::__construct();
        $this->result = '';
    }

    public function display()
    {
        echo $this->result;
    }

    public function initContent()
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $is_export_combinations = (int)Configuration::get('FAB_PIXEL_COMBINATIONS', null, $id_shop_group, $id_shop);

        if (Tools::getValue('action') === 'add-to-cart') {
            $langId = $this->context->language->id;
            $cart = $this->context->cart;
            $productId = Tools::getValue('id_product');
            $productIdAttribute = Tools::getValue('id_product_attribute');
            if ($is_export_combinations && $productIdAttribute>0) {
                $productId = $productId.'-'.$productIdAttribute;
            }
            $currencyId = $cart->id_currency;
            $currency = new Currency($currencyId, false, $langId, $id_shop);
            $currencyCode = $currency->iso_code;
            $countryId = Configuration::get('PS_COUNTRY_DEFAULT', null, $id_shop_group, $id_shop);
            if (!empty($this->context->country)) {
                $countryId = $this->context->country->id;
            }
            ob_end_clean();
            header('Content-Type: application/json');
            die(json_encode(array(
                'cart' => $cart,
                'productId'   => $productId,
                'productPrice' => $this->getProductPrice($productId, $id_shop, $countryId, $currencyId),
                'currencyCode' => $currencyCode
            )));
        }
    }


    protected function getProductPrice($id_product, $id_shop, $id_country, $id_currency)
    {
        $specific_price_output = null;

        $product_price = number_format((float)Product::priceCalculation(
            (int)$id_shop,
            (int)$id_product,
            null,
            (int)$id_country,
            null,
            null,
            (int)$id_currency,
            1,
            1,
            true,
            6,
            false,
            true,
            true,
            $specific_price_output,
            true,
            0,
            true,
            null,
            1,
            null
        ), 2, '.', '');
        return $product_price;
    }


    protected function getData($url)
    {
        $ch = curl_init();
        $timeout = -1;
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }
}
