<?php
/**
 * 2017 Manfredi Petruso
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to manfredi.petruso@fabvla.com so we can send you a copy immediately.
 *
 *
 *  @author    Manfredi Petruso <manfredi.petruso@fabvla.com>
 *  @copyright  2017 Manfredi Petruso
 *  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class FabFacebookPixel extends Module
{
    protected $html = '';

    public function __construct()
    {
        $this->name = 'fabfacebookpixel';
        $this->author = 'MANFIELD';
        $this->tab = 'advertising_marketing';
        $this->need_instance = 0;
        $this->version = '2.6.9';
        $this->bootstrap = true;
        $this->_directory = dirname(__FILE__);
        $this->controllers = array('ajax','catalogexport','storecatalog');
        $this->module_key = '9dd2adbfc106755eabff7f6bdd4ad9ca';
        $this->author_address = '0xf17628948116213714612917b0352F1d9f352f2D';

        parent::__construct();

        $this->displayName = $this->l('Facebook Pixel + Catalog Export & Cron');
        $this->description = $this->l('Installs the Facebook pixel, collects e-commerce events. 
            Exports FB catalog or stores the catalog in a file, downloadable from a specific URL. 
            Multi store / currency / country / language supported.');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => '1.7.99.99');
    }

    public function install()
    {
        if (!parent::install() || !$this->registerHook('actionCustomerAccountAdd')
            || !$this->registerHook('displayFooter') || !$this->registerHook('displayHeader')
            || !$this->registerHook('displayFooterProduct')
            || !$this->registerHook('displayAdminForm')
            || !$this->registerHook('actionValidateOrder')
            || !$this->registerHook('actionCartSave')
            || !$this->registerHook('displayOrderConfirmation')
            || !$this->registerHook('displayAdminEndContent')
            || !Configuration::updateValue('FAB_FACEBOOK_PIXEL', 'installed')
            || !Configuration::updateValue('FAB_FACEBOOK_MICRODATA', 0)
            || !Configuration::updateValue('FAB_FACEBOOK_PIXEL_ACTIVE', 1)
            || !Configuration::updateValue('FAB_PIXEL_TAX_INCLUDED', '')
            || !Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH', 0)
            || !Configuration::updateValue('FAB_PIXEL_BRAND_OVERRIDE', '')
            || !Configuration::updateValue('FAB_GOOGLE_EXPORT_EMPTY_DESC', 1)
            || !Configuration::updateValue('FAB_FACEBOOK_PIXEL_IMAGE_TYPE', 0)
            || !Configuration::updateValue('FAB_FACEBOOK_CHUNK_ACTIVE', 0)
            || !Configuration::updateValue('FAB_FACEBOOK_CHUNK_QTY', 0)
            || !Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH_DATE', date("D M d, Y G:i"))
            || !Configuration::updateValue('FAB_FACEBOOK_PIXEL_ID', '')) {
            return false;
        }

        // Update Configuration values for all shops
        $shops = Shop::getContextListShopID();
        $shop_groups_list = array();

        /* Setup each shop */
        foreach ($shops as $shop_id) {
            $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

            if (!in_array($shop_group_id, $shop_groups_list)) {
                $shop_groups_list[] = $shop_group_id;
            }

            /* Sets up configuration */
            $res = Configuration::updateValue('FAB_FACEBOOK_PIXEL', true, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ACTIVE', 1, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_FACEBOOK_MICRODATA', 0, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_PIXEL_TAX_INCLUDED', 1, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH', 0, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_GOOGLE_EXPORT_EMPTY_DESC', 1, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_PIXEL_BRAND_OVERRIDE', 1, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_ACTIVE', 0, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_QTY', 0, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_IMAGE_TYPE', 0, false, $shop_group_id, $shop_id);
            $res &= Configuration::updateValue(
                'FAB_GOOGLE_CATEGORIES_FETCH_DATE',
                date("D M d, Y G:i"),
                false,
                $shop_group_id,
                $shop_id
            );
            $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ID', '', false, $shop_group_id, $shop_id);
        }

        /* Sets up Shop Group configuration */
        if (count($shop_groups_list)) {
            foreach ($shop_groups_list as $shop_group_id) {
                $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL', true, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ACTIVE', 1, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_FACEBOOK_MICRODATA', 0, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_PIXEL_TAX_INCLUDED', 1, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_GOOGLE_CATEGORIES_FETCH', 0, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_GOOGLE_EXPORT_EMPTY_DESC', 1, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_PIXEL_BRAND_OVERRIDE', 1, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_ACTIVE', 0, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_QTY', 0, false, $shop_group_id);
                $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_IMAGE_TYPE', 0, false, $shop_group_id);
                $res &= Configuration::updateValue(
                    'FAB_GOOGLE_CATEGORIES_FETCH_DATE',
                    date("D M d, Y G:i"),
                    false,
                    $shop_group_id
                );
                $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ID', '', false, $shop_group_id);
            }
        }


        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            if (!$this->registerHook('displayShoppingCart')) {
                return false;
            }
        } else {
            if (!$this->registerHook('displayCheckoutSummaryTop')) {
                return false;
            }
        }

        $sql_file = dirname(__FILE__).'/install/install.sql';
        if (!$this->loadSQLFile($sql_file)) {
            return false;
        }

        // Install admin tab
        if (!$this->installTab('AdminCatalog', 'FabFacebookPixelAjax', 'Fabvla Facebook Pixel')) {
            return false;
        }

        $this->removeClassIndex();

        if (!$res) {
            return false;
        }

        return true;
    }


    public function installTab($parent, $class_name, $name)
    {
        $tab = new Tab();
        $tab->module = $this->name;
        $tab->active = 0;
        $tab->class_name = $class_name;
        $tab->id_parent = (int)Tab::getIdFromClassName($parent);
        $id_shop = Context::getContext()->shop->id;

        foreach (Language::getLanguages(true, $id_shop) as $lang) {
            $tab->name[$lang['id_lang']] = $name;
        }

        return $tab->add();
    }

    public function uninstall()
    {
        $sql_file = dirname(__FILE__).'/uninstall/uninstall.sql';
        if (!$this->loadSQLFile($sql_file)) {
            return true;
        }

        if (!parent::uninstall()
            || !Configuration::deleteByName('FAB_FACEBOOK_PIXEL')
        ) {
            return true;
        }

        if (!$this->uninstallTab('FabFacebookPixelAjax')) {
            return true;
        }

        $this->removeClassIndex();

        $this->_clearCache('init_page_view.tpl');
        $this->_clearCache('order_confirmation.tpl');
        $this->_clearCache('view_product.tpl');
        $this->_clearCache('display_checkout.tpl');

        return true;
    }


    public function uninstallTab($class_name)
    {
        // Retrieve Tab ID
        $id_tab = (int)Tab::getIdFromClassName($class_name);

        // Load tab
        $tab = new Tab((int)$id_tab);

        // Delete it
        return $tab->delete();
    }

    /* hookDisplayAdminEndContent defined for PS > 1.7.4 */
    public function hookDisplayAdminEndContent($hookParams)
    {
        if ($this->isSymfonyContext()) {
            $currentController = Tools::getValue('controller');
            $idCategory = 0;
            $jsPath = $this->_path.'views/js/admin.js';
            $currentUrl = $_SERVER['REQUEST_URI'];

            if (preg_match("/\/categories\/(.*)\\/edit/", $currentUrl, $matches1)) {
                $idCategory = (int)$matches1[1];
            }

            if ($currentController == "AdminCategories") {
                $googleDefinitions = $this->getGoogleDefinitions();
                $selectedValue = $this->getGoogleDefinitionSelected($idCategory);
                $this->smarty->assign(
                    array(
                        'params' => $currentController,
                        'google_definitions' => $googleDefinitions,
                        'id_category' => $idCategory,
                        'token' => Tools::getAdminTokenLite('FabFacebookPixelAjax'),
                        'selectedValue' => $selectedValue,
                        'js_path' => $jsPath
                    )
                );
                return $this->display(__FILE__, 'category_additional_options_175.tpl');
            }
        }
    }


    public function hookDisplayCheckoutSummaryTop($params)
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $facebookPixelId = Configuration::get('FAB_FACEBOOK_PIXEL_ID', null, $id_shop_group, $id_shop);
        $enabled = (int)Configuration::get('FAB_FACEBOOK_PIXEL_ACTIVE', null, $id_shop_group, $id_shop);

        if (Context::getContext()->cookie->fab_init_checkout == null && $enabled && $facebookPixelId != '') {
            Context::getContext()->cookie->fab_init_checkout = 1;
            return $this->display(__FILE__, 'display_checkout.tpl');
        }
    }


    public function hookDisplayOrderConfirmation($params)
    {
        if (!isset($_COOKIE['_fbp'])) {
            $id_shop_group = Shop::getContextShopGroupID();
            $id_shop = Shop::getContextShopID();
            $is_export_combinations = (int)Configuration::get('FAB_PIXEL_COMBINATIONS', null, $id_shop_group, $id_shop);

            $id_default_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
            $langId = $this->context->language->id;
            $facebookPixelId = Configuration::get('FAB_FACEBOOK_PIXEL_ID', null, $id_shop_group, $id_shop);
            $enabled = (int)Configuration::get('FAB_FACEBOOK_PIXEL_ACTIVE', null, $id_shop_group, $id_shop);

            $productList = array();

            if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
                $totalPaidTaxIncluded = (float)$params["total_to_pay"];
                $currency = new Currency($params["objOrder"]->id_currency, false, $langId, $id_shop);
                $currencyCode = $currency->iso_code;
                $cart = new Cart($params["objOrder"]->id_cart);
                $cartProducts = $cart->getProducts();
                foreach ($cartProducts as $cartProduct) {
                    $productId = $cartProduct["id_product"];
                    array_push($productList, $productId);
                }
            } else {
                $cart = new Cart($params["order"]->id_cart);
                $cartProducts = $cart->getProducts();
                foreach ($cartProducts as $cartProduct) {
                    $productId = $cartProduct["id_product"];
                    $productIdAttribute = $cartProduct["id_product_attribute"];
                    if ($is_export_combinations && $productIdAttribute>0) {
                        $productId = $productId.'-'.$productIdAttribute;
                    }
                    array_push($productList, $productId);
                }
                $totalPaidTaxIncluded = $params["order"]->total_paid_tax_incl;
                $currencyCode = Currency::getCurrency($params["order"]->id_currency)["iso_code"];
            }

            if ($enabled && $facebookPixelId != '') {
                $default_customer_group = $this->getDefaultCustomerGroup(Context::getContext(), $id_default_lang, $id_shop);
                $customer_groups = $this->getCustomerGroups(Context::getContext(), $id_default_lang, $id_shop);
                $customer_groups_string = implode(",", $customer_groups);
                $this->smarty->assign(
                    array(
                        'facebookPixelId' => $facebookPixelId,
                        'totalPaidTaxIncluded' => $totalPaidTaxIncluded,
                        'currency' => $currencyCode,
                        'productList' => $productList,
                        'customer_groups' => $customer_groups_string,
                        'default_customer_group' => $default_customer_group
                    )
                );
                return $this->display(__FILE__, 'order_confirmation.tpl');
            }
        }
    }



    public function hookActionCartSave()
    {
        $tableName = 'fabfacebookpixel_purchase';

        if (isset($_COOKIE['_fbp'])) {
            if (isset(Context::getContext()->cart)) {
                $id_cart = Context::getContext()->cart->id;

                $fbp = $_COOKIE['_fbp'];

                $sql = "SELECT * FROM "._DB_PREFIX_.$tableName." WHERE id_cart = ".(int)$id_cart;
                $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow($sql);

                if (empty($res) && $id_cart > 0) {
                    $sql = "INSERT INTO "._DB_PREFIX_.$tableName." (id_cart, id_order, sent, id_customer) 
                        VALUES (".(int)$id_cart.",0,0,'".pSQL($fbp)."')";
                    $res &= Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);

                    Context::getContext()->cookie->fab_check_purchase == '0';
                }
            }
        }
    }

    public function hookActionValidateOrder($params)
    {
        $tableName = 'fabfacebookpixel_purchase';

        $order = $params['order'];
        $id_order = null;

        if (!empty($order)) {
            $id_order = $order->id;
            $order = new Order($id_order);
            $id_cart = $order->id_cart;
            $sql = "UPDATE "._DB_PREFIX_.$tableName." SET id_order = ".(int)$id_order." WHERE id_cart = ".(int)$id_cart;
            Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
        }
    }

    protected function getOrderData($order)
    {
        if (empty($order)) {
            return null;
        }

        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $langId = $this->context->language->id;
        $is_export_combinations = (int)Configuration::get('FAB_PIXEL_COMBINATIONS', null, $id_shop_group, $id_shop);

        $cart = null;
        $totalPaidTaxIncluded = null;
        $currencyCode = "";

        $totalPaidTaxIncluded = number_format((float)$order->total_paid_tax_incl, 2, '.', '');
        $cart = new Cart($order->id_cart);

        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            $currency = new Currency($order->id_currency, false, $langId, $id_shop);
            $currencyCode = $currency->iso_code;
        } else {
            $currencyCode = Currency::getCurrency($order->id_currency)["iso_code"];
        }

        $productList = array();
        $cartProducts = $cart->getProducts();
        foreach ($cartProducts as $cartProduct) {
            $productId = $cartProduct["id_product"];
            $productIdAttribute = $cartProduct["id_product_attribute"];
            if ($is_export_combinations && $productIdAttribute>0) {
                $productId = $productId.'-'.$productIdAttribute;
            }
            array_push($productList, $productId);
        }

        return array(
            'totalPaidTaxIncluded' => $totalPaidTaxIncluded,
            'currency' => $currencyCode,
            'productList' => $productList,
            'orderId' => $order->id
        );
    }

    protected function pendingOrders()
    {
        $res = array();

        if (isset($_COOKIE['_fbp'])) {
            $fbp = $_COOKIE['_fbp'];

            $tableName = 'fabfacebookpixel_purchase';
            // Check if pending orders
            $sql = "SELECT * FROM "._DB_PREFIX_.$tableName." WHERE sent = 0 
                AND id_order <> 0 AND id_customer = '".pSQL($fbp)."'";
            $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        }

        return $res;
    }

    protected function resetPendingOrders()
    {
        if (isset($_COOKIE['_fbp'])) {
            $fbp = $_COOKIE['_fbp'];

            $tableName = 'fabfacebookpixel_purchase';
            // Check if pending orders
            $sql = "UPDATE "._DB_PREFIX_.$tableName." SET sent = 1 WHERE sent = 0 AND id_customer = '".pSQL($fbp)."'";
            Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
        }
    }


    public function hookActionCustomerAccountAdd($params)
    {
        if (Context::getContext()->cookie->fab_customer_add == null) {
            Context::getContext()->cookie->fab_customer_add = '1';
        }
    }

    public function hookDisplayShoppingCart($params)
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $id_default_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
        $facebookPixelId = Configuration::get('FAB_FACEBOOK_PIXEL_ID', null, $id_shop_group, $id_shop);
        $enabled = (int)Configuration::get('FAB_FACEBOOK_PIXEL_ACTIVE', null, $id_shop_group, $id_shop);

        if (Context::getContext()->cookie->fab_init_checkout == null && $enabled && $facebookPixelId != '') {
            Context::getContext()->cookie->fab_init_checkout  = '1';
            $default_customer_group = $this->getDefaultCustomerGroup(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups = $this->getCustomerGroups(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups_string = implode(",", $customer_groups);
            $this->smarty->assign(
                array(
                    'customer_groups' => $customer_groups_string,
                    'default_customer_group' => $default_customer_group
                )
            );

            return $this->display(__FILE__, 'display_checkout.tpl');
        }
    }


    protected function getProductPrice($id_product, $id_shop, $id_country, $id_currency, $productIdAttribute, $is_tax_included)
    {

        $specific_price_output = null;

        $product_price = number_format((float)Product::priceCalculation(
            (int)$id_shop,
            (int)$id_product,
            (int)$productIdAttribute,
            (int)$id_country,
            null,
            null,
            (int)$id_currency,
            1,
            1,
            $is_tax_included,
            6,
            false,
            true,
            true,
            $specific_price_output,
            true,
            0,
            true,
            null,
            1,
            null
        ), 2, '.', '');
        return $product_price;
    }

    public function hookDisplayFooterProduct($params)
    {

        $_DESCRIPTION = 1;
        $_SHORT_DESCRIPTION = 2;
        $_NAME = 3;

        Context::getContext()->cookie->fab_init_checkout = null;
        $langId = $this->context->language->id;
        $link = $this->context->link;
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $id_default_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
        $facebookPixelId = Configuration::get('FAB_FACEBOOK_PIXEL_ID', null, $id_shop_group, $id_shop);
        $enabled = (int)Configuration::get('FAB_FACEBOOK_PIXEL_ACTIVE', null, $id_shop_group, $id_shop);
        $id_country = Configuration::get('PS_COUNTRY_DEFAULT', null, $id_shop_group, $id_shop);
        $is_tax_included =Configuration::get('FAB_PIXEL_TAX_INCLUDED', null, $id_shop_group, $id_shop);
        $descriptionFieldId = Configuration::get('FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD', null, $id_shop_group, $id_shop);

        if (!empty($this->context->country)) {
            $id_country = $this->context->country->id;
        }

        $has_microdata = 0;
        $productIdAttribute = 0;

        $productObject = $params["product"];
        $cartObject = $params["cart"];

        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            $productId = $productObject->id;
            $currencyId = $cartObject->id_currency;
        } else {
            $productId = $productObject["id_product"];
            $currencyId = $cartObject->id_currency;
        }

        if (array_key_exists("id_product_attribute", $productObject)) {
            $productIdAttribute = (int)$productObject["id_product_attribute"];
        } else {
            if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.4', '>')) {
                $productIdAttribute = (int)$productObject->id_product_attribute;
            }
        }

        if ((int)Configuration::get('FAB_PIXEL_COMBINATIONS', null, $id_shop_group, $id_shop) && $productIdAttribute>0) {
            $productId = $productId.'-'.$productIdAttribute;
        }

        if ((int)Configuration::get('FAB_FACEBOOK_MICRODATA', null, $id_shop_group, $id_shop)) {
            $has_microdata = 1;
        }

        $currency = new Currency($currencyId, $langId, $id_shop);
        $currencyCode = $currency->iso_code;

        $product = new Product($productId, false, $langId, $id_shop);
        $productName = $product->name;
        $productDescription = '';

        if (!empty($descriptionFieldId)) {
            if ($descriptionFieldId == $_DESCRIPTION) {
                $productDescription = $product->description;
            }
            else if ($descriptionFieldId == $_SHORT_DESCRIPTION) {
                $productDescription = $product->description_short;
            }
            else if ($descriptionFieldId == $_NAME) {
                $productDescription = $product->name;
            }
        } else {
            $productDescription = $product->description;
        }

        $image = Image::getCover($product->id);
        $imageTypeId = Configuration::get('FAB_FACEBOOK_PIXEL_IMAGE_TYPE', null, $id_shop_group, $id_shop);

        if ($imageTypeId == 0) {
            $imageTypeString = null;
        } else {
            $imageTypeObject = new ImageType($imageTypeId);
            $imageTypeString = $imageTypeObject->name;
        }

        $brand = Manufacturer::getNameById($product->id_manufacturer);
        $condition = $product->condition;
        $availability = $product->available_for_order;
        $productCategoryRewrite = Category::getLinkRewrite($product->id_category_default, $langId);
        $url = $link->getProductLink($product, null, $productCategoryRewrite, null, $langId, $id_shop, $productIdAttribute);
        $imageUrl = $link->getImageLink(
            $product->link_rewrite,
            $image['id_product'].'-'.$image['id_image'],
            $imageTypeString
        );

        $productPrice = $this->getProductPrice($productId, $id_shop, $id_country, $currencyId, $productIdAttribute, $is_tax_included);

        $defaultCategoryId = $product->id_category_default;
        $category = new Category($defaultCategoryId, $langId, $id_shop);

        $productCategory = $category->name;

        if ($enabled && $facebookPixelId != '') {
            $default_customer_group = $this->getDefaultCustomerGroup(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups = $this->getCustomerGroups(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups_string = implode(",", $customer_groups);

            $this->smarty->assign(
                array(
                    'facebookPixelId' => $facebookPixelId,
                    'productId' => $productId,
                    'productName' => $productName,
                    'productPrice' => $productPrice,
                    'productCategory' => $productCategory,
                    'currencyCode' => $currencyCode,
                    'productDescription' => $productDescription,
                    'brand' => $brand,
                    'condition' => $condition,
                    'availability' => $availability,
                    'url' => $url,
                    'imageUrl' => $imageUrl,
                    'has_microdata' => $has_microdata,
                    'customer_groups' => $customer_groups_string,
                    'default_customer_group' => $default_customer_group
                )
            );
            return $this->display(__FILE__, 'view_product.tpl');
        }
    }


    public function hookDisplayHeader($params)
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $currency = Context::getContext()->currency->iso_code;
        $id_default_lang = intval(Configuration::get('PS_LANG_DEFAULT'));
        $customerAdded = "false";

        if (Context::getContext()->cookie->fab_customer_add != null) {
            $customerAdded = "true";
            Context::getContext()->cookie->fab_customer_add = (string)((int)Context::getContext()->cookie->fab_customer_add + 1);
        }
        if ((int)Context::getContext()->cookie->fab_customer_add > 2) {
            Context::getContext()->cookie->fab_customer_add = null;
        }
        $facebookPixelId = Configuration::get('FAB_FACEBOOK_PIXEL_ID', null, $id_shop_group, $id_shop);
        $enabled = (int)Configuration::get('FAB_FACEBOOK_PIXEL_ACTIVE', null, $id_shop_group, $id_shop);

        // Check for pending purchases
        $ordersData = array();

        if (Context::getContext()->cookie->fab_check_purchase == '0') {
            $pendingOrders =  $this->pendingOrders();
            if (sizeof($pendingOrders) > 0) {
                foreach ($pendingOrders as $pendingOrder) {
                    $id_order = $pendingOrder['id_order'];
                    $order = new Order($id_order);
                    $ordersData[] = $this->getOrderData($order);
                }
                $this->resetPendingOrders();
                Context::getContext()->cookie->fab_check_purchase == '1';
            }
        }


        if ($enabled && $facebookPixelId != '') {
            $this->context->controller->addJS($this->_path.'views/js/fabfacebookpixel.js');
            $default_customer_group = $this->getDefaultCustomerGroup(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups = $this->getCustomerGroups(Context::getContext(), $id_default_lang, $id_shop);
            $customer_groups_string = implode(",", $customer_groups);
            $this->smarty->assign(
                array(
                    'facebookPixelId' => $facebookPixelId,
                    'refreshUrl' => $this->context->link->getModuleLink(
                        'fabfacebookpixel',
                        'ajax',
                        array(),
                        null,
                        null,
                        null,
                        true
                    ),
                    'customerAdded' => $customerAdded,
                    'ordersData' => $ordersData,
                    'currency' => $currency,
                    'customer_groups' => $customer_groups_string,
                    'default_customer_group' => $default_customer_group
                )
            );
            return $this->display(__FILE__, 'init_page_view.tpl');
        }
    }


    // Hooks related to Facebook Catalog Export
    public function hookDisplayAdminForm($params)
    {
        $currentController = Tools::getValue('controller');
        $idCategory = Tools::getValue('id_category');
        $this->context->controller->addJS($this->_path.'views/js/admin.js');

        if ($currentController == "AdminCategories") {
            $googleDefinitions = $this->getGoogleDefinitions();
            $selectedValue = $this->getGoogleDefinitionSelected($idCategory);
            $this->smarty->assign(
                array(
                    'params' => $currentController,
                    'google_definitions' => $googleDefinitions,
                    'id_category' => $idCategory,
                    'token' => Tools::getAdminTokenLite('FabFacebookPixelAjax'),
                    'selectedValue' => $selectedValue
                )
            );
            return $this->display(__FILE__, 'category_additional_options.tpl');
        }
    }


    public function getContent()
    {
        $errors = array();
        $res = false;


        if (Tools::isSubmit('submit_incremental_storage')) {
            $chunkActive = (int)Tools::getValue('FAB_FACEBOOK_CHUNK_ACTIVE');
            $chunkQty = (int)Tools::getValue('FAB_FACEBOOK_CHUNK_QTY');

            if ($chunkQty <= 0) {
                $chunkQty = 1;
                $chunkActive = false;
            }

            $shop_context = Shop::getContext();
            $shop_groups_list = array();
            $shops = Shop::getContextListShopID();

            foreach ($shops as $shop_id) {
                $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

                if (!in_array($shop_group_id, $shop_groups_list)) {
                    $shop_groups_list[] = $shop_group_id;
                }
                $res = Configuration::updateValue(
                    'FAB_FACEBOOK_CHUNK_ACTIVE',
                    $chunkActive,
                    false,
                    $shop_group_id,
                    $shop_id
                );
                $res &= Configuration::updateValue(
                    'FAB_FACEBOOK_CHUNK_QTY',
                    $chunkQty,
                    false,
                    $shop_group_id,
                    $shop_id
                );
            }

            /* Update global shop context if needed*/
            switch ($shop_context) {
                case Shop::CONTEXT_ALL:
                    $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_ACTIVE', $chunkActive);
                    $res &= Configuration::updateValue('FAB_FACEBOOK_CHUNK_QTY', $chunkQty);

                    if (count($shop_groups_list)) {
                        foreach ($shop_groups_list as $shop_group_id) {
                            $res &= Configuration::updateValue(
                                'FAB_FACEBOOK_CHUNK_ACTIVE',
                                $chunkActive,
                                false,
                                $shop_group_id
                            );
                            $res &= Configuration::updateValue(
                                'FAB_FACEBOOK_CHUNK_QTY',
                                $chunkQty,
                                false,
                                $shop_group_id
                            );
                        }
                    }
                    break;
                case Shop::CONTEXT_GROUP:
                    if (count($shop_groups_list)) {
                        foreach ($shop_groups_list as $shop_group_id) {
                            $res &= Configuration::updateValue(
                                'FAB_FACEBOOK_CHUNK_ACTIVE',
                                $chunkActive,
                                false,
                                $shop_group_id
                            );
                            $res &= Configuration::updateValue(
                                'FAB_FACEBOOK_CHUNK_QTY',
                                $chunkQty,
                                false,
                                $shop_group_id
                            );
                        }
                    }
                    break;
            }

            if (!$res) {
                $errors[] = $this->displayError(
                    $this->l(
                        'The configuration could not be updated.'
                    )
                );
            } else {
                Tools::redirectAdmin(
                    $this->context->link->getAdminLink(
                        'AdminModules',
                        true
                    ).'&conf=6&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name
                );
            }

            $this->html .= $this->displayConfirmation($this->l('Settings updated'));
        }


        if (Tools::isSubmit('submit_main_settings')) {
            $facebookPixelId = (string)Tools::getValue('FAB_FACEBOOK_PIXEL_ID');
            $enabled = (int)Tools::getValue('FAB_FACEBOOK_PIXEL_ACTIVE');
            $hasMicrodata = (int)Tools::getValue('FAB_FACEBOOK_MICRODATA');
            $exportEmptyDesc = (int)Tools::getValue('FAB_GOOGLE_EXPORT_EMPTY_DESC');
            $brandOverride = (string)Tools::getValue('FAB_PIXEL_BRAND_OVERRIDE');
            $imageType = (string)Tools::getValue('FAB_FACEBOOK_PIXEL_IMAGE_TYPE');
            $taxIncluded = (string)Tools::getValue('FAB_PIXEL_TAX_INCLUDED');
            $descriptionFieldId = (int)Tools::getValue('FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD');
            $is_export_combinations = (int)Tools::getValue('FAB_PIXEL_COMBINATIONS');
            $size_mapping = (int)Tools::getValue('FAB_PIXEL_SIZE_MAPPING');
            $color_mapping = (int)Tools::getValue('FAB_PIXEL_COLOR_MAPPING');
            $gender_mapping = (int)Tools::getValue('FAB_PIXEL_GENDER_MAPPING');
            $material_mapping = (int)Tools::getValue('FAB_PIXEL_MATERIAL_MAPPING');
            $pattern_mapping = (int)Tools::getValue('FAB_PIXEL_PATTERN_MAPPING');

            if (empty($facebookPixelId)) {
                $this->html .= $this->displayError($this->l('Invalid Configuration value'));
            } else {
                $shop_context = Shop::getContext();
                $shop_groups_list = array();
                $shops = Shop::getContextListShopID();

                foreach ($shops as $shop_id) {
                    $shop_group_id = (int)Shop::getGroupFromShop($shop_id, true);

                    if (!in_array($shop_group_id, $shop_groups_list)) {
                        $shop_groups_list[] = $shop_group_id;
                    }

                    $res = Configuration::updateValue(
                        'FAB_FACEBOOK_PIXEL_ID',
                        $facebookPixelId,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res = Configuration::updateValue(
                        'FAB_PIXEL_BRAND_OVERRIDE',
                        $brandOverride,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_FACEBOOK_PIXEL_ACTIVE',
                        $enabled,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_FACEBOOK_MICRODATA',
                        $hasMicrodata,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_GOOGLE_EXPORT_EMPTY_DESC',
                        $exportEmptyDesc,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_FACEBOOK_PIXEL_IMAGE_TYPE',
                        $imageType,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD',
                        $descriptionFieldId,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_TAX_INCLUDED',
                        $taxIncluded,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_COMBINATIONS',
                        $is_export_combinations,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_COLOR_MAPPING',
                        $color_mapping,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_SIZE_MAPPING',
                        $size_mapping,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_GENDER_MAPPING',
                        $gender_mapping,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_MATERIAL_MAPPING',
                        $material_mapping,
                        false,
                        $shop_group_id,
                        $shop_id
                    );

                    $res &= Configuration::updateValue(
                        'FAB_PIXEL_PATTERN_MAPPING',
                        $pattern_mapping,
                        false,
                        $shop_group_id,
                        $shop_id
                    );
                }

                /* Update global shop context if needed*/
                switch ($shop_context) {
                    case Shop::CONTEXT_ALL:
                        $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ID', $facebookPixelId);
                        $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_ACTIVE', $enabled);
                        $res &= Configuration::updateValue('FAB_FACEBOOK_MICRODATA', $hasMicrodata);
                        $res &= Configuration::updateValue('FAB_GOOGLE_EXPORT_EMPTY_DESC', $exportEmptyDesc);
                        $res &= Configuration::updateValue('FAB_PIXEL_BRAND_OVERRIDE', $brandOverride);
                        $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_IMAGE_TYPE', $imageType);
                        $res &= Configuration::updateValue('FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD', $descriptionFieldId);
                        $res &= Configuration::updateValue('FAB_PIXEL_TAX_INCLUDED', $taxIncluded);
                        $res &= Configuration::updateValue('FAB_PIXEL_COMBINATIONS', $is_export_combinations);
                        $res &= Configuration::updateValue('FAB_PIXEL_COLOR_MAPPING', $color_mapping);
                        $res &= Configuration::updateValue('FAB_PIXEL_SIZE_MAPPING', $size_mapping);
                        $res &= Configuration::updateValue('FAB_PIXEL_GENDER_MAPPING', $gender_mapping);
                        $res &= Configuration::updateValue('FAB_PIXEL_MATERIAL_MAPPING', $material_mapping);
                        $res &= Configuration::updateValue('FAB_PIXEL_PATTERN_MAPPING', $pattern_mapping);

                        if (count($shop_groups_list)) {
                            foreach ($shop_groups_list as $shop_group_id) {
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_ID',
                                    $facebookPixelId,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_ACTIVE',
                                    $enabled,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_MICRODATA',
                                    $hasMicrodata,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_GOOGLE_EXPORT_EMPTY_DESC',
                                    $exportEmptyDesc,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_BRAND_OVERRIDE',
                                    $brandOverride,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_IMAGE_TYPE',
                                    $imageType,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD',
                                    $descriptionFieldId,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_COMBINATIONS',
                                    $is_export_combinations,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_COLOR_MAPPING',
                                    $color_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_SIZE_MAPPING',
                                    $size_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_GENDER_MAPPING',
                                    $gender_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_MATERIAL_MAPPING',
                                    $material_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_PATTERN_MAPPING',
                                    $pattern_mapping,
                                    false,
                                    $shop_group_id
                                );
                            }
                        }
                        break;
                    case Shop::CONTEXT_GROUP:
                        if (count($shop_groups_list)) {
                            foreach ($shop_groups_list as $shop_group_id) {
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_ID',
                                    $facebookPixelId,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_ACTIVE',
                                    $enabled,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_MICRODATA',
                                    $hasMicrodata,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_BRAND_OVERRIDE',
                                    $brandOverride,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_GOOGLE_EXPORT_EMPTY_DESC',
                                    $exportEmptyDesc,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_IMAGE_TYPE',
                                    $imageType,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD',
                                    $descriptionFieldId,
                                    false,
                                    $shop_group_id
                                );
                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_TAX_INCLUDED',
                                    $taxIncluded,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_COMBINATIONS',
                                    $is_export_combinations,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_COLOR_MAPPING',
                                    $color_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_SIZE_MAPPING',
                                    $size_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_GENDER_MAPPING',
                                    $gender_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_MATERIAL_MAPPING',
                                    $material_mapping,
                                    false,
                                    $shop_group_id
                                );

                                $res &= Configuration::updateValue(
                                    'FAB_PIXEL_PATTERN_MAPPING',
                                    $pattern_mapping,
                                    false,
                                    $shop_group_id
                                );
                            }
                        }
                        break;
                }

                if (!$res) {
                    $errors[] = $this->displayError(
                        $this->l(
                            'The configuration could not be updated.'
                        )
                    );
                } else {
                    Tools::redirectAdmin(
                        $this->context->link->getAdminLink(
                            'AdminModules',
                            true
                        ).'&conf=6&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name
                    );
                }

                $this->html .= $this->displayConfirmation($this->l('Settings updated'));
                $this->_clearCache('init_page_view.tpl');
                $this->_clearCache('order_confirmation.tpl');
                $this->_clearCache('view_product.tpl');
                $this->_clearCache('display_checkout.tpl');
            }
        }
        $this->context->controller->addJS($this->_path.'views/js/admin.js');
        $this->context->controller->addCSS($this->_path.'views/css/admin.css', 'all');
        $activeLangs = Language::getLanguages(true);
        $this->html .= '<div id="'.$this->name.'">';
        $this->html .= $this->getCurrentShopInfoMsg();
        $this->html .= $this->displayReferenceWarning();
        $this->html .= $this->displayForm();
        $this->html .= $this->displayExport($activeLangs);
        if (Shop::isFeatureActive()) {
            if (Shop::getContext() != Shop::CONTEXT_SHOP) {
                $this->html .= $this->getCatalogExportInfoMsg();
                return $this->html;
            }
        }
        $this->html .= $this->getCatalogStorageInfoMsg();
        $this->html .= $this->displayCatalogStorageInfo();
        $this->html .= $this->displayCatalogStorageForm();
        $this->html .= '</div>';

        return $this->html;
    }


    public function displayExport($activeLangs)
    {
        $params = array(
            'activeLangs' => $activeLangs,
            'noDefinitions' => $this->isTableEmpty('fabfacebookpixel_gc_lang'),
            'token' => Tools::getAdminTokenLite('FabFacebookPixelAjax'),
            'exportControllerUrl' => $this->context->link->getModuleLink(
                'fabfacebookpixel',
                'catalogexport',
                array(),
                null,
                null,
                null,
                true
            )
        );

        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/section_export.tpl',
            $params
        );
        return $tpl->fetch();
    }

    public function displayReferenceWarning()
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $use_reference = (int)Configuration::get('FAB_PIXEL_USE_REFERENCE', null, $id_shop_group, $id_shop);
        $token = Tools::getAdminTokenLite('FabFacebookPixelAjax');
        $params = array(
            'useReference' => $use_reference,
            'token' => $token
        );
        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/reference_warning.tpl',
            $params
        );
        return $tpl->fetch();
    }

    public function displayForm()
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();
        $id_language = $this->context->language->id;

        $image_types = $this->getImageTypes();
        $description_fields = $this->getDescriptionField();
        $attribute_groups_list = AttributeGroup::getAttributesGroups($id_language);
        $show_export_combinations = true;

        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            $show_export_combinations = false;
        }

        // Load current value
        $is_pixel_active = Configuration::get(
            'FAB_FACEBOOK_PIXEL_ACTIVE',
            null,
            $id_shop_group,
            $id_shop
        );

        $pixel_id = Configuration::get(
            'FAB_FACEBOOK_PIXEL_ID',
            null,
            $id_shop_group,
            $id_shop
        );

        $has_microdata = Configuration::get(
            'FAB_FACEBOOK_MICRODATA',
            null,
            $id_shop_group,
            $id_shop
        );

        $brand_override = Configuration::get(
            'FAB_PIXEL_BRAND_OVERRIDE',
            null,
            $id_shop_group,
            $id_shop
        );

        $is_empty_description = Configuration::get(
            'FAB_GOOGLE_EXPORT_EMPTY_DESC',
            null,
            $id_shop_group,
            $id_shop
        );


        $image_type = Configuration::get(
            'FAB_FACEBOOK_PIXEL_IMAGE_TYPE',
            null,
            $id_shop_group,
            $id_shop
        );

        $description_field = Configuration::get(
            'FAB_FACEBOOK_PIXEL_DESCRIPTION_FIELD',
            null,
            $id_shop_group,
            $id_shop
        );

        $is_tax_included = Configuration::get(
            'FAB_PIXEL_TAX_INCLUDED',
            null,
            $id_shop_group,
            $id_shop
        );

        $is_export_combinations = Configuration::get(
            'FAB_PIXEL_COMBINATIONS',
            null,
            $id_shop_group,
            $id_shop
        );

        $color_mapping = Configuration::get(
            'FAB_PIXEL_COLOR_MAPPING',
            null,
            $id_shop_group,
            $id_shop
        );

        $size_mapping = Configuration::get(
            'FAB_PIXEL_SIZE_MAPPING',
            null,
            $id_shop_group,
            $id_shop
        );

        $gender_mapping = Configuration::get(
            'FAB_PIXEL_GENDER_MAPPING',
            null,
            $id_shop_group,
            $id_shop
        );

        $material_mapping = Configuration::get(
            'FAB_PIXEL_MATERIAL_MAPPING',
            null,
            $id_shop_group,
            $id_shop
        );

        $pattern_mapping = Configuration::get(
            'FAB_PIXEL_PATTERN_MAPPING',
            null,
            $id_shop_group,
            $id_shop
        );

        $current_index = AdminController::$currentIndex.'&configure='.$this->name;
        $token = Tools::getAdminTokenLite('AdminModules');
        $submit_action = 'submit_main_settings';

        $params = array(
            'current_index' => $current_index,
            'token' => $token,
            'submit_action' => $submit_action,
            'is_pixel_active' => (int)$is_pixel_active,
            'pixel_id' => $pixel_id,
            'brand_override' => $brand_override,
            'is_empty_description' => (int)$is_empty_description,
            'image_type' => $image_type,
            'description_field' => $description_field,
            'is_tax_included' => (int)$is_tax_included,
            'image_types' => $image_types,
            'description_fields' => $description_fields,
            'is_export_combinations' => $is_export_combinations,
            'color_mapping' => $color_mapping,
            'size_mapping' => $size_mapping,
            'gender_mapping' => $gender_mapping,
            'material_mapping' => $material_mapping,
            'pattern_mapping' => $pattern_mapping,
            'attribute_groups_list' => $attribute_groups_list,
            'show_export_combinations' =>  $show_export_combinations,
            'has_microdata' => $has_microdata
        );


        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/main_settings.tpl',
            $params
        );
        return $tpl->fetch();
    }


    public function displayCatalogStorageForm()
    {
        $id_shop_group = Shop::getContextShopGroupID();
        $id_shop = Shop::getContextShopID();

        $current_index = AdminController::$currentIndex.'&configure='.$this->name;
        $token = Tools::getAdminTokenLite('AdminModules');
        $submit_action = 'submit_incremental_storage';


        // Load current value
        $is_chunk_active = Configuration::get(
            'FAB_FACEBOOK_CHUNK_ACTIVE',
            null,
            $id_shop_group,
            $id_shop
        );

        $chunk_quantity = Configuration::get(
            'FAB_FACEBOOK_CHUNK_QTY',
            null,
            $id_shop_group,
            $id_shop
        );

        $params = array(
            'current_index' => $current_index,
            'token' => $token,
            'is_chunk_active' => (int)$is_chunk_active,
            'chunk_quantity' => (int)$chunk_quantity,
            'submit_action' => $submit_action
        );

        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/incremental_storage.tpl',
            $params
        );
        return $tpl->fetch();
    }


    /**
     * Get Customer Default Group
     */

    protected function getDefaultCustomerGroup($context, $id_lang, $id_shop) {
        $group_name = "";
        if (!empty($context)) {
            $id_customer = $context->customer->id;
            $id_default_group = Customer::getDefaultGroupId($id_customer);
            $group = new Group($id_default_group, $id_lang, $id_shop);
            $group_name = $group->name;
        }
        return $group_name;
    }


    /**
     * Get Customer Groups
     */

    protected function getCustomerGroups($context, $id_lang, $id_shop) {
        $group_names = array();
        if (!empty($context)) {
            $id_customer = $context->customer->id;
            $id_groups = Customer::getGroupsStatic($id_customer);
            foreach ($id_groups as $id_group) {
                $group = new Group($id_group, $id_lang, $id_shop);
                $group_names[] = $group->name;
            }
        }
        return $group_names;
    }


    /**
     * Get Image Types
     * @return array
     */
    protected function getImageTypes()
    {
        $imageTypes = ImageType::getImagesTypes();
        $imageTypeEmpty = array();
        $imageTypeEmpty['name'] = $this->l('Original Format');
        $imageTypeEmpty['id_image_type'] = 0;
        array_unshift($imageTypes, $imageTypeEmpty);
        return $imageTypes;
    }


    /**
     * Get Description Field
     * @return array
     */
    protected function getDescriptionField()
    {
        $descriptionFields = array();
        $descriptionFields[] =  array('id' => 1, 'label' => $this->l('Product\'s Description'));
        $descriptionFields[] =  array('id' => 2, 'label' => $this->l('Product\'s Short Description'));
        $descriptionFields[] =  array('id' => 3, 'label' => $this->l('Product Name'));
        return $descriptionFields;
    }


    public function loadSQLFile($sql_file)
    {
        $sql_content = Tools::file_get_contents($sql_file);

        $sql_content = str_replace('PREFIX_', _DB_PREFIX_, $sql_content);
        $sql_requests = preg_split("/;\s*[\r\n]+/", $sql_content);

        $result = true;
        foreach ($sql_requests as $request) {
            if (!empty($request)) {
                $result &= Db::getInstance()->execute(trim($request));
            }
        }

        return $result;
    }

    protected function isTableEmpty($tableName)
    {
        $sql = "SELECT 1 FROM "._DB_PREFIX_.$tableName." LIMIT 1;";
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        if (!empty($result)) {
            return false;
        }
        return true;
    }

    protected function getGoogleDefinitions()
    {
        $langId = $this->context->language->id;
        $iso_code = Language::getIsoById($langId);
        $locale = Language::getLanguageCodeByIso($iso_code);

        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            $localeArray  = explode("-", $locale);
            $locale = $localeArray[0].'-'.Tools::strtoupper($localeArray[1]);
        } else {
            $locale = Language::getLocaleByIso($iso_code);
        }

        if (!version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            $locale = Language::getLocaleByIso($iso_code);
        }
        $sql = "SELECT id_google_category,iso_code,google_category_description 
            FROM "._DB_PREFIX_."fabfacebookpixel_gc_lang WHERE iso_code = '".pSQL($locale)."'";
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        return $result;
    }

    protected function getGoogleDefinitionSelected($idCategory)
    {
        $idGoogleCategoryId = '';
        $sql = "SELECT id_google_category FROM "._DB_PREFIX_."fabfacebookpixel 
        WHERE id_category = '".(int)$idCategory."' LIMIT 1";
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
        foreach ($result as $item) {
            $idGoogleCategoryId = $item['id_google_category'];
            break;
        }
        return $idGoogleCategoryId;
    }

    protected function removeClassIndex()
    {
        if (version_compare(Tools::substr(_PS_VERSION_, 0, 5), '1.7.0', '<')) {
            if (file_exists(_PS_ROOT_DIR_.'/cache/class_index.php')) {
                unlink(_PS_ROOT_DIR_.'/cache/class_index.php');
            }
        }
    }

    protected function getCatalogExportInfoMsg()
    {
        return '<div class="alert alert-warning">'.
            $this->l('The Catalog export section is available only in a single shop context. Please select one shop.').
            '</div>';
    }


    protected function getCurrentShopInfoMsg()
    {
        $shop_info = null;

        if (Shop::isFeatureActive()) {
            if (Shop::getContext() == Shop::CONTEXT_SHOP) {
                $shop_info = sprintf(
                    $this->l('The modifications will be applied to shop: %s'),
                    $this->context->shop->name
                );
            } elseif (Shop::getContext() == Shop::CONTEXT_GROUP) {
                $shop_info = sprintf(
                    $this->l('The modifications will be applied to this group: %s'),
                    Shop::getContextShopGroup()->name
                );
            } else {
                $shop_info = $this->l('The modifications will be applied to all shops and shop groups');
            }

            return '<div class="alert alert-info">'.
                $shop_info.
                '</div>';
        } else {
            return '';
        }
    }


    protected function displayCatalogStorageInfo()
    {
        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/chunk_info.tpl',
            array()
        );
        return $tpl->fetch();
    }

    protected function getCatalogStorageInfoMsg()
    {

        // Get secure token (Configuration::get pulled out from empty argument, because of an issue on PHP < 5.5)
        $configSecureToken = Configuration::get('FAB_FACEBOOK_PIXEL_TOKEN');

        if (empty($configSecureToken)) {
            Configuration::updateGlobalValue('FAB_FACEBOOK_PIXEL_TOKEN', md5(uniqid(rand(), true)));
        }

        //Build the Shop Domain, useful to display the catalog url for cron
        $shopProtocol = 'http:';
        $langId = $this->context->language->id;
        $shopId = $this->context->shop->id;
        $currencyId = $this->context->currency->id;
        $currency = new Currency($currencyId);
        $currencyIso = $currency->iso_code;
        $langIso = Language::getIsoById($langId);
        $countryId = Configuration::get('PS_COUNTRY_DEFAULT');
        $countryIso = Country::getIsoById($countryId);

        $shops = Shop::getShops(true, null);
        $currencies = Currency::getCurrencies(true, true, true);
        $languages = Language::getLanguages(true, $shopId);
        $countries = Country::getCountries($langId, true);
        $categories = Category::getCategories($langId);

        $tree_categories_helper = new HelperTreeCategories('categories-treeview');
        $tree_categories_helper->setRootCategory(
            (Shop::getContext() == Shop::CONTEXT_SHOP ? Category::getRootCategory()->id_category : 0)
        );
        $tree_categories_helper->setUseCheckBox(true);
        $tree_categories_helper->setInputName('categoryBox');

        if (Tools::usingSecureMode()) {
            $shopProtocol = 'https:';
        }

        $shopUrl = _PS_BASE_URL_;

        if (Configuration::get('PS_SSL_ENABLED')) {
            $shopUrl = _PS_BASE_URL_SSL_;
        }

        $storeCatalogUrl = $this->context->link->getModuleLink(
            'fabfacebookpixel',
            'storecatalog',
            array(),
            null,
            $langId,
            null,
            true
        );

        // This is a workaround for some PS version having a trouble with getModuleLink Relative Protocol
        if (strpos($storeCatalogUrl, 'http') !== false) {
            $shopProtocol = "";
        }

        $params = array(
            'shopProtocol' => $shopProtocol,
            'shopUrl' => $shopUrl,
            'shopId' => $shopId,
            'currencyIso' => $currencyIso,
            'currencyId' => $currencyId,
            'countryIso' => $countryIso,
            'countryId' => $countryId,
            'shops' => $shops,
            'currencies' => $currencies,
            'languages' => $languages,
            'countries' => $countries,
            'categories' => $categories,
            'storeCatalogUrl' => $storeCatalogUrl,
            'langIso' => $langIso,
            'langId' => $langId,
            'token' => Configuration::get('FAB_FACEBOOK_PIXEL_TOKEN'),
            'exportControllerUrl' => $this->context->link->getModuleLink(
                'fabfacebookpixel',
                'catalogexport',
                array(),
                null,
                null,
                null,
                true
            ),
            'categoryBox'  => $tree_categories_helper->render()
        );


        $tpl = $this->context->smarty->createTemplate(
            dirname(__FILE__).'/views/templates/admin/catalog_storage_info.tpl',
            $params
        );
        return $tpl->fetch();
    }
}
