/**
* 2017 Manfredi Petruso
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to manfredi.petruso@fabvla.com so we can send you a copy immediately.
*
*
*  @author    Manfredi Petruso <manfredi@fabvla.com>
*  @copyright  2017 Manfredi Petruso
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/


function generateUrl(noStoreCatalog) {
    
    var token = $('#generator').data('token');
    var url = $('#generator').data('url');
    
    var shopId = ($('#shopId').val()?'&shopId='+$('#shopId').val():'');
    var langId = ($('#langId').val()?'&langId='+$('#langId').val():'');
    var currencyId = ($('#currencyId').val()?'&currencyId='+$('#currencyId').val():'');
    var countryId = ($('#countryId').val()?'&countryId='+$('#countryId').val():'');
    var categoryId = new Array();
    var categoryIdString = '';
    $('input[name="categoryBox[]"]:checked').each(function() {
        categoryId.push(this.value);
    });
    
    for (i = 0; i < categoryId.length; i++) {
        categoryIdString += '&categoryId[]='+categoryId[i];
    }
    
    var catalogInfo = ($('#catalogInfo').val()?'&catalogInfo='+$('#catalogInfo').val():'');
    var generatedUrl = url+'?token='+token+shopId+langId+currencyId+countryId+categoryIdString+catalogInfo;
    
    if (noStoreCatalog) {
        generatedUrl = generatedUrl + '&noStoreCatalog=true';
    }
    
    return generatedUrl;
    
}

function generateCsvUrl() {
    
    var url = $('#generator').data('csv-prefix');
    
    var shopId = $('#shopId').val();
    var langIso = ($('#langId').find(":selected").data('iso')?'_'+$('#langId').find(":selected").data('iso'):'');
    var currencyIso = ($('#currencyId').find(":selected").data('iso')?'_'+$('#currencyId').find(":selected").data('iso'):'');
    var countryIso = ($('#countryId').find(":selected").data('iso')?'_'+$('#countryId').find(":selected").data('iso'):'');
    var categoryId = ($("input[name='categoryBox']:checked").val()?'_'+$("input[name='categoryBox']:checked").val():'');
    var categoryId = new Array();
    $('input[name="categoryBox[]"]:checked').each(function() {
        categoryId.push(this.value);
    })
    var categoryIdString = '';
    for (i = 0; i < categoryId.length; i++) {
        categoryIdString += '_'+categoryId[i];
    }
    
    var generatedUrl = url+shopId+langIso+currencyIso+countryIso+categoryIdString+".csv";

    return generatedUrl;
    
}


$(document).ready(function() {	
        
    $( "#langId, #currencyId, #countryId, #catalogInfo, input[name='categoryBox[]']" ).change(function(e) {
        $("#storeurl").text(generateUrl());
        $("#catalogcsv").text(generateCsvUrl());
        $("#exportUrl").attr('href',generateUrl(true));
        if (e.currentTarget.id == 'catalogInfo') {
            if (e.currentTarget.value == 1) {
                let message = $('#dyncatalog').data('message-country');
                $("#dyncatalog").text(message);
                $('#dyncatalog').show();
            } else if (e.currentTarget.value == 2) {
                let message = $('#dyncatalog').data('message-language');
                $("#dyncatalog").text(message);
                $('#dyncatalog').show();
            } else {
                $('#dyncatalog').hide();
            }
            
        }
    });
    
    $("#storeurl").text(generateUrl());
    $("#catalogcsv").text(generateCsvUrl());
    $("#exportUrl").attr('href',generateUrl(true));
    

});