{*
* 2017 Manfredi Petruso
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to manfredi.petruso@fabvla.com so we can send you a copy immediately.
*
*
*  @author    Manfredi Petruso <manfredi.petruso@fabvla.com>
*  @copyright  2017 Manfredi Petruso
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*}
{literal}
<!-- Facebook Pixel Code -->
<script>
fbq('track', 'ViewContent', {
{/literal}
content_type: 'product',
content_ids: ['{$productId|escape:'javascript':'UTF-8'}'],
content_name: '{$productName|escape:'javascript':'UTF-8'}',
content_category: '{$productCategory|escape:'javascript':'UTF-8'}',
value: '{$productPrice|escape:'javascript':'UTF-8'}',
currency: '{$currencyCode|escape:'javascript':'UTF-8'}',
customer_groups: '{$customer_groups|escape:'javascript':'UTF-8'}',
default_customer_group: '{$default_customer_group|escape:'javascript':'UTF-8'}'
{literal}
});


</script>
{/literal}

{if $has_microdata}

{literal}
<script type="application/ld+json">
    {
{/literal}
        "@context":"https://schema.org",
        "@type":"Product",
        "productID":"{$productId|escape:'html':'UTF-8'}",
        "name":"{$productName|escape:'html':'UTF-8'}",
        "description":"{$productDescription|strip|escape:'html':'UTF-8'}",
        "url":"{$url|escape:'html':'UTF-8'}",
        "image":"{$imageUrl|escape:'html':'UTF-8'}",
        "brand":"{$brand|escape:'html':'UTF-8'}",
        "offers": {literal}[
            {
            {/literal}
                "@type": "Offer",
                "price": "{$productPrice|escape:'html':'UTF-8'}",
                "priceCurrency": "{$currencyCode|escape:'html':'UTF-8'}",
                {if $condition == 'used'}"itemCondition": "https://schema.org/UsedCondition",
                {elseif $condition == 'refurbished'}"itemCondition": "https://schema.org/RefurbishedCondition",
                {else}"itemCondition": "https://schema.org/NewCondition",{/if}

                {if $availability == 1}"availability": "https://schema.org/InStock"
                {else}"availability": "https://schema.org/OutOfStock"
                {/if}
        {literal}
            }
        ]
    }
    {/literal}
</script>

{/if}

<!-- DO NOT MODIFY -->
<!-- End Facebook Pixel Code -->
