<?php
/**
 * admin.conf.php file defines all required constants and variables for admin context
 *
 * @author    Business Tech SARL
 * @copyright 2003-2017 Business Tech SARL
 */

require_once(dirname(__FILE__) . '/common.conf.php');

/* defines modules support product id */
define('_FPA_SUPPORT_ID', '23671');

/* defines activate the BT support if false we use the ADDONS support url */
define('_FPA_SUPPORT_BT', false);
//define('_FPA_SUPPORT_BT', true);

/* defines activate the BT support if false we use the ADDONS support url */
define('_FPA_SUPPORT_URL', 'https://addons.prestashop.com/');
//define('_FPA_SUPPORT_URL', 'http://www.businesstech.fr/');

/* defines admin library path */
define('_FPA_PATH_LIB_ADMIN', _FPA_PATH_LIB . 'admin/');

/* defines xml library path */
define('_FPA_PATH_LIB_XML', _FPA_PATH_LIB . 'xml/');

/* defines admin tpl path */
define('_FPA_TPL_ADMIN_PATH', 'admin/');

/* defines header tpl */
define('_FPA_TPL_HEADER', 'header.tpl');

/* defines body tpl */
define('_FPA_TPL_BODY', 'body.tpl');

/* defines basics settings tpl */
define('_FPA_TPL_BASICS', 'basics.tpl');

/* defines feed settings tpl */
define('_FPA_TPL_FEED_SETTINGS', 'feed-settings.tpl');

/* defines Facebook settings tpl */
define('_FPA_TPL_FACEBOOK_SETTINGS', 'facebook-settings.tpl');

/* defines facebook category list tpl */
define('_FPA_TPL_FACEBOOK_CATEGORY_LIST', 'facebook-category-list.tpl');

/* defines facebook category popup tpl */
define('_FPA_TPL_FACEBOOK_CATEGORY_POPUP', 'facebook-category-popup.tpl');

/* defines facebook category update tpl */
define('_FPA_TPL_FACEBOOK_CATEGORY_UPD', 'facebook-category-update.tpl');

/* defines facebook custom label tpl */
define('_FPA_TPL_FACEBOOK_CUSTOM_LABEL', 'facebook-custom-label.tpl');

/* defines facebook custom label update tpl */
define('_FPA_TPL_FACEBOOK_CUSTOM_LABEL_UPD', 'facebook-custom-label-update.tpl');

/* defines feed list settings tpl */
define('_FPA_TPL_FEED_LIST', 'feed-list.tpl');

/* defines reporting settings tpl */
define('_FPA_TPL_REPORTING', 'reporting-settings.tpl');

/* defines feed generate action tpl */
define('_FPA_TPL_FEED_GENERATE', 'feed-generate.tpl');

/* defines feed generate output tpl */
define('_FPA_TPL_FEED_GENERATE_OUTPUT', 'feed-generate-output.tpl');

/* defines advanced tag category settings tpl */
define('_FPA_TPL_ADVANCED_TAG_CATEGORY', 'advanced-tag-category.tpl');

/* defines advanced tag update tpl */
define('_FPA_TPL_ADVANCED_TAG_UPD', 'advanced-tag-update.tpl');

/* defines reporting fancybox tpl */
define('_FPA_TPL_REPORTING_BOX', 'reporting-box.tpl');

/* defines product search tpl */
define('_FPA_TPL_PROD_SEARCH', 'product-search.tpl');

/* defines new custom feeds tpl */
define('_FPA_TPL_NEW_CUSTOM_FEED', 'new-custom-feed.tpl');

/* defines new custom feeds success message tpl */
define('_FPA_TPL_NEW_CUSTOM_FEED_SUCCESS', 'new-custom-feed-update.tpl');

/* defines product search tpl */
define('_FPA_TPL_ADVICE', 'advice.tpl');

/* defines update sql file */
define('_FPA_TPL_PIXEL_CONFIG', 'facebook-pixel-settings.tpl');

/* defines update sql file */
define('_FPA_UPDATE_SQL_FILE', 'update.sql');

/* defines update sql file */
define('_FPA_TAXONOMY_SQL_FILE', 'update-taxonomy.sql');

/* defines update sql file */
define('_FPA_TAXONOMY_CAT_SQL_FILE', 'update-taxonomy-cat.sql');

/* defines update sql file */
define('_FPA_TAXONOMY_SHOP_SQL_FILE', 'update-taxonomy-shop.sql');

/* defines update sql file */
define('_FPA_TAGS_SQL_FILE', 'update-tags.sql');

/* defines update sql file */
define('_FPA_TAGS_ID_SQL_FILE', 'update-tags-shopid.sql');

/* defines update sql file */
define('_FPA_facebookCAT_ID_SQL_FILE', 'update-facebookcat-shopid.sql');

/* defines update sql file */
define('_FPA_BRANDS_SQL_FILE', 'update-brands.sql');

/* defines update sql file */
define('_FPA_FEATURE_SHOP_SQL_FILE', 'update-feature-shop.sql');

/* defines constant for external BT API URL */
define('_FPA_BT_API_MAIN_URL', 'https://api.businesstech.fr:441/prestashop-modules/');

/* defines constant for external BT FAQ URL */
define('_FPA_BT_FAQ_MAIN_URL', 'http://faq.businesstech.fr/');

/* defines constant for external Facebook taxonomy URL */
define('_FPA_FACEBOOK_TAXONOMY_URL', 'http://www.google.com/basepages/producttype/');

/* defines loader gif name */
define('_FPA_LOADER_GIF', 'bx_loader.gif');

//define('_FPA_LOADER_GIF', 'loading.gif');
define('_FPA_LOADER_GIF_BIG', 'ajax-loader.gif');

/* defines title length */
define('_FPA_FEED_TITLE_LENGTH', 150);

/* defines the limit of additional images you can provide */
define('_FPA_IMG_LIMIT', 10);

/* defines the limit of number of custom label you can provide */
define('_FPA_CUSTOM_LABEL_LIMIT', 5);

/* defines the reporting Directory */
define('_FPA_REPORTING_DIR', _PS_MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/reporting/');

/* defines variable for sql update */
$GLOBALS[_FPA_MODULE_NAME . '_SQL_UPDATE'] = array();

/* defines variable for setting all request params : use for ajax request in to admin context */
$GLOBALS[_FPA_MODULE_NAME . '_REQUEST_PARAMS'] = array(
    'basic' => array('action' => 'update', 'type' => 'basic'),
    'feed' => array('action' => 'update', 'type' => 'feed'),
    'feedDisplay' => array('action' => 'display', 'type' => 'feed'),
    'facebook' => array('action' => 'update', 'type' => 'facebook'),
    'feedList' => array('action' => 'display', 'type' => 'feedList'),
    'feedListUpdate' => array('action' => 'update', 'type' => 'feedList'),
    'reporting' => array('action' => 'update', 'type' => 'reporting'),
    'reportingBox' => array('action' => 'display', 'type' => 'reportingBox'),
    'tag' => array('action' => 'display', 'type' => 'tag'),
    'tagUpdate' => array('action' => 'update', 'type' => 'tag'),
    'facebookCat' => array('action' => 'display', 'type' => 'facebookCategories'),
    'facebookCatUpdate' => array('action' => 'update', 'type' => 'facebookCategoriesMatching'),
    'facebookCatSync' => array('action' => 'update', 'type' => 'facebookCategoriesSync'),
    'custom' => array('action' => 'display', 'type' => 'customLabel'),
    'customUpdate' => array('action' => 'update', 'type' => 'label'),
    'customDelete' => array('action' => 'delete', 'type' => 'label'),
    'autocomplete' => array('action' => 'display', 'type' => 'autocomplete'),
    'searchProduct' => array('action' => 'display', 'type' => 'searchProduct'),
    'dataFeed' => array('action' => 'update', 'type' => 'xml'),
    'advice' => array('action' => 'display', 'type' => 'advice'),
    'adviceUpd' => array('action' => 'update', 'type' => 'advice'),
    'pixel' => array('action' => 'update', 'type' => 'pixel'),
    'newCustomFeed' => array('action' => 'display', 'type' => 'newCustomFeed'),
    'newFeed' => array('action' => 'update', 'type' => 'newFeed'),
);

/* defines variable for available list of tags to use */
$GLOBALS[_FPA_MODULE_NAME . '_TAG_LIST'] = array('material', 'pattern', 'agegroup', 'gender', 'adult');

/* defines variable for available list of label to use */
$GLOBALS[_FPA_MODULE_NAME . '_LABEL_LIST'] = array(
    'cats' => 'category',
    'brands' => 'brand',
    'suppliers' => 'supplier'
);

/* defines variable for available list of label to use */
$GLOBALS[_FPA_MODULE_NAME . '_PARAM_FOR_XML'] = array(
    'iShopId',
    'sFilename',
    'iLangId',
    'sLangIso',
    'sCountryIso',
    'sCurrencyIso',
    'iFloor',
    'iStep',
    'iTotal',
    'iProcess'
);

