<?php
/**
 * common.conf.php file defines all required constants and variables for entire module's context - install / admin / hook / tab
 *
 * @author    Business Tech SARL
 * @copyright 2003-2017 Business Tech SARL
 */

/* defines constant of module name */
define('_FPA_MODULE_NAME', 'FPA');
/* define constant for advice icon */
define('_FPA_ADVICE_ICONE_NAME', 'advice.png');
/* defines module name */
define('_FPA_MODULE_SET_NAME', 'facebookproductad');
/* defines root path of the shop */
define('_FPA_SHOP_PATH_ROOT', _PS_ROOT_DIR_ . '/');
/* defines root path of module */
define('_FPA_PATH_ROOT', _PS_MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/');
/* defines conf path */
define('_FPA_PATH_CONF', _FPA_PATH_ROOT . 'conf/');
/* defines library path */
define('_FPA_PATH_LIB', _FPA_PATH_ROOT . 'lib/');
/* defines dynamic tags library path  uses  => to include class files */
define('_FPA_PATH_LIB_PIXEL_TAGS', _FPA_PATH_LIB . 'pixel/');
/* defines common library path */
define('_FPA_PATH_LIB_COMMON', _FPA_PATH_LIB . 'common/');
/* defines sql path */
define('_FPA_PATH_SQL', _FPA_PATH_ROOT . 'sql/');
/* defines views folder */
define('_FPA_PATH_VIEWS', 'views/');
/* defines js URL */
define('_FPA_URL_JS', _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/' . _FPA_PATH_VIEWS . 'js/');
/* defines css URL */
define('_FPA_URL_CSS', _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/' . _FPA_PATH_VIEWS . 'css/');
/* defines MODULE URL */
define('_FPA_MODULE_URL', _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/');
/* defines img path */
define('_FPA_PATH_IMG', 'img/');
/* defines img URL */
define('_FPA_URL_IMG', _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/' . _FPA_PATH_VIEWS . _FPA_PATH_IMG);
/* defines img URL */
define('_FPA_PATH_IMG_ADVICE', _FPA_URL_IMG . _FPA_ADVICE_ICONE_NAME);
/* defines tpl path name */
define('_FPA_PATH_TPL_NAME', _FPA_PATH_VIEWS . 'templates/');
/* defines tpl path */
define('_FPA_PATH_TPL', _FPA_PATH_ROOT . _FPA_PATH_TPL_NAME);
/* defines constant of error tpl */
define('_FPA_TPL_ERROR', 'error.tpl');
/* defines confirm tpl */
define('_FPA_TPL_CONFIRM', 'confirm.tpl');
/* defines activate / deactivate debug mode */
define('_FPA_DEBUG', true);
/* defines constant to use or not js on submit action */
define('_FPA_USE_JS', true);
/* defines variable for admin ctrl name */
define('_FPA_PARAM_CTRL_NAME', 'sController');
/* defines variable for admin ctrl name */
define('_FPA_ADMIN_CTRL', 'admin');
/* defines variable for the php script file to copy */
define('_FPA_XML_PHP_NAME', 'facebookproductad.xml.php');
/* defines variable for the php script file to copy */
define('_FPA_FEED_PHP_NAME', 'facebookproductad.feed.php');
/* defines variable for javascript name used by the pixel */
define('_FPA_JS_NAME', 'oPixel');

/* defines variables to configuration settings */
$GLOBALS[_FPA_MODULE_NAME . '_CONFIGURATION'] = array(
    'FPA_VERSION' => '',
    'FPA_HOME_CAT' => '',
    'FPA_LINK' => '',
    'FPA_ID_PREFIX' => '',
    'FPA_AJAX_CYCLE' => 200,
    'FPA_EXPORT_OOS' => 1,
    'FPA_COND' => 'new',
    'FPA_P_COMBOS' => 0,
    'FPA_P_DESCR_TYPE' => 3,
    'FPA_IMG_SIZE' => version_compare(_PS_VERSION_, '1.7',
        '>=') ? ImageType::getFormattedName('large') : ImageType::getFormatedName('large'),
    'FPA_EXC_NO_EAN' => 0,
    'FPA_EXC_NO_MREF' => 0,
    'FPA_MIN_PRICE' => 0,
    'FPA_INC_STOCK' => 1,
    'FPA_INC_FEAT' => 0,
    'FPA_FEAT_OPT' => 0,
    'FPA_INC_GENRE' => 0,
    'FPA_GENRE_OPT' => 0,
    'FPA_INC_SIZE' => 0,
    'FPA_SIZE_OPT' => 0,
    'FPA_INC_COLOR' => '',
    'FPA_COLOR_OPT' => '',
    'FPA_INC_MATER' => 0,
    'FPA_MATER_OPT' => 0,
    'FPA_INC_PATT' => 0,
    'FPA_PATT_OPT' => 0,
    'FPA_INC_GEND' => 0,
    'FPA_GEND_OPT' => 0,
    'FPA_INC_ADULT' => 0,
    'FPA_ADULT_OPT' => 0,
    'FPA_INC_AGE' => 0,
    'FPA_AGE_OPT' => 0,
    'FPA_SHIP_CARRIERS' => '',
    'FPA_REPORTING' => 1,
    'FPA_HOME_CAT_ID' => 1,
    'FPA_MPN_TYPE' => 'supplier_ref',
    'FPA_INC_ID_EXISTS' => 0,
    'FPA_ADD_CURRENCY' => 0,
    'FPA_UTM_CAMPAIGN' => '',
    'FPA_UTM_SOURCE' => '',
    'FPA_UTM_MEDIUM' => '',
    'FPA_FEED_PROTECTION' => 1,
    'FPA_FEED_TOKEN' => md5(rand(1000, 1000000) . time()),
    'FPA_EXPORT_MODE' => 0,
    'FPA_ADV_PRODUCT_NAME' => 0,
    'FPA_ADV_PROD_TITLE' => 0,
    'FPA_CHECK_EXPORT' => '',
    'FPA_INC_TAG_ADULT' => 0,
    'FPA_SHIPPING_USE' => 1,
    'FPA_PROD_EXCL' => '',
    'FPA_GTIN_PREF' => 'ean',
    'FPA_DISP_ADVICE' => 1,
    'FPA_PIXEL' => '',
    'FPA_USE_TAX' => 1,
    'FPA_USE_SHIPPING' => 1,
    'FPA_USE_WRAPPING' => 1,
    'FPA_DISPLAY_FUNNEL' => 0,
    'FPA_CUSTOM_DOM_ELEM' => 0,
    'FPA_CUSTOM_FEED' => '',
    'FPA_JS_CART_SELECTOR_PROD' => (version_compare(_PS_VERSION_, '1.6', '>=') && version_compare(_PS_VERSION_, '1.7',
            '<')) ? 'p[id="add_to_cart"]' : '.add-to-cart',
    'FPA_JS_WISH_SELECTOR_PROD' => version_compare(_PS_VERSION_, '1.6', '>=') && version_compare(_PS_VERSION_, '1.7',
        '<') ? 'a[id="wishlist_button_nopop"]' : 'a[id="wishlist_button"]',
    'FPA_JS_CART_SELECTOR_CAT' => version_compare(_PS_VERSION_, '1.6', '>=') && version_compare(_PS_VERSION_, '1.7',
        '<') ? 'a[data-id-product="_PRODUCT_ID_"].ajax_add_to_cart_button' : 'a[rel="ajax_id_product__PRODUCT_ID_"].ajax_add_to_cart_button',
    'FPA_JS_WISH_SELECTOR_CAT' => 'a[rel="_PRODUCT_ID_"].addToWishlist',
);

/* defines variable to translate js msg */
$GLOBALS[_FPA_MODULE_NAME . '_JS_MSG'] = array();

/* defines variable to define available weight units */
$GLOBALS[_FPA_MODULE_NAME . '_WEIGHT_UNITS'] = array('kg', 'lb', 'g', 'oz');

/* defines variable to define default home cat name translations */
$GLOBALS[_FPA_MODULE_NAME . '_HOME_CAT_NAME'] = array(
    'en' => 'home',
    'fr' => 'accueil',
    'it' => 'ignazio',
    'es' => 'ignacio',
);

$GLOBALS[_FPA_MODULE_NAME . '_HOOKS'] = array(
    array('name' => 'displayHeader', 'use' => false, 'title' => 'Header'),
//    array('name' => 'displayFooter', 'use' => false, 'title' => 'Footer'),
    array('name' => 'displayOrderConfirmation', 'use' => false, 'title' => 'Order Confirmation'),
    array('name' => 'actionValidateOrder', 'use' => false, 'title' => 'Validate order'),
);

// New hook for 1.7 last funnet step
if (version_compare(_PS_VERSION_, '1.7', '>=')) {
    array_merge($GLOBALS[_FPA_MODULE_NAME . '_HOOKS'],
        array('name' => 'displayPaymentByBinaries', 'use' => false, 'title' => 'Display during checkout'));
}

/* defines available languages / countries / currencies for Facebook */
$GLOBALS[_FPA_MODULE_NAME . '_AVAILABLE_COUNTRIES'] = array(
    'en' => array(
        'GB' => array('currency' => array('GBP'), 'taxonomy' => 'en-GB'),
        'US' => array('currency' => array('USD'), 'taxonomy' => 'en-US'),
        'AU' => array('currency' => array('AUD'), 'taxonomy' => 'en-GB'),
        'CA' => array('currency' => array('CAD'), 'taxonomy' => 'en-US'),
        'IN' => array('currency' => array('INR'), 'taxonomy' => 'en-GB'),
        'CH' => array('currency' => array('CHF'), 'taxonomy' => 'en-GB')
    ),
    'gb' => array(
        'GB' => array('currency' => array('GBP'), 'taxonomy' => 'en-GB'),
        'AU' => array('currency' => array('AUD'), 'taxonomy' => 'en-GB'),
        'IN' => array('currency' => array('INR'), 'taxonomy' => 'en-GB'),
        'CH' => array('currency' => array('CHF'), 'taxonomy' => 'en-GB')

    ),
    'fr' => array(
        'FR' => array('currency' => array('EUR'), 'taxonomy' => 'fr-FR'),
        'CH' => array('currency' => array('CHF'), 'taxonomy' => 'fr-FR'),
        'CA' => array('currency' => array('CAD'), 'taxonomy' => 'fr-FR'),
        'BE' => array('currency' => array('EUR'), 'taxonomy' => 'fr-FR')
    ),
    'de' => array(
        'DE' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE'),
        'CH' => array('currency' => array('CHF'), 'taxonomy' => 'de-DE'),
        'AT' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE')
    ),
    'it' => array(
        'IT' => array('currency' => array('EUR'), 'taxonomy' => 'it-IT'),
        'CH' => array('currency' => array('CHF'), 'taxonomy' => 'it-IT')
    ),
    'nl' => array(
        'NL' => array('currency' => array('EUR'), 'taxonomy' => 'nl-NL'),
        'BE' => array('currency' => array('EUR'), 'taxonomy' => 'nl-NL')
    ),
    'es' => array(
        'ES' => array('currency' => array('EUR'), 'taxonomy' => 'es-ES'),
        'AR' => array('currency' => array('ARS'), 'taxonomy' => 'es-ES')
    ),
);


/* defines variable for setting dynamic tags type
* uses  => in install / ADMIN / HOOK mode
*
 */
$GLOBALS[_FPA_MODULE_NAME . '_TAGS_TYPE'] = array(
    'home' => 'home',
    'category' => 'category',
    'product' => 'product',
    'cart' => 'cart',
    'purchase' => 'purchase',
    'search' => 'searchresults',
    'other' => 'other',
    'manufacturer' => 'manufacturer',
    'promotion' => 'promotion',
    'newproducts' => 'newproducts',
    'bestsales' => 'bestsales'
);

/* defines variable to set request parameters */
$GLOBALS[_FPA_MODULE_NAME . '_MONTH'] = array(
    'en' => array(
        'short' => array(
            '',
            'Jan.',
            'Feb.',
            'March',
            'Apr.',
            'May',
            'June',
            'July',
            'Aug.',
            'Sept.',
            'Oct.',
            'Nov.',
            'Dec.'
        ),
        'long' => array(
            '',
            'January',
            'February',
            'March',
            'April',
            'May',
            'June',
            'July',
            'August',
            'September',
            'October',
            'November',
            'December'
        ),
    ),
    'fr' => array(
        'short' => array(
            '',
            'Jan.',
            'F&eacute;v.',
            'Mars',
            'Avr.',
            'Mai',
            'Juin',
            'Juil.',
            'Aout',
            'Sept.',
            'Oct.',
            'Nov.',
            'D&eacute;c.'
        ),
        'long' => array(
            '',
            'Janvier',
            'F&eacute;vrier',
            'Mars',
            'Avril',
            'Mai',
            'Juin',
            'Juillet',
            'Aout',
            'Septembre',
            'Octobre',
            'Novembre',
            'D&eacute;cembre'
        ),
    ),
    'de' => array(
        'short' => array(
            '',
            'Jan.',
            'Feb.',
            'M' . chr(132) . 'rz',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sept.',
            'Okt.',
            'Nov.',
            'Dez.'
        ),
        'long' => array(
            '',
            'Januar',
            'Februar',
            'M' . chr(132) . 'rz',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember'
        ),
    ),
    'it' => array(
        'short' => array(
            '',
            'Gen.',
            'Feb.',
            'Marzo',
            'Apr.',
            'Mag.',
            'Giu.',
            'Lug.',
            'Ago.',
            'Sett.',
            'Ott.',
            'Nov.',
            'Dic.'
        ),
        'long' => array(
            '',
            'Gennaio',
            'Febbraio',
            'Marzo',
            'Aprile',
            'Maggio',
            'Giugno',
            'Luglio',
            'Agosto',
            'Settembre',
            'Ottobre',
            'Novembre',
            'Dicembre'
        ),
    ),
    'es' => array(
        'short' => array(
            '',
            'Ene.',
            'Feb.',
            'Marzo',
            'Abr.',
            'Mayo',
            'Junio',
            'Jul.',
            'Ago.',
            'Sept.',
            'Oct.',
            'Nov.',
            'Dic.'
        ),
        'long' => array(
            '',
            'Enero',
            'Febrero',
            'Marzo',
            'Abril',
            'Mayo',
            'Junio',
            'Julio',
            'Agosto',
            'Septiembre',
            'Octubre',
            'Noviembre',
            'Diciembre'
        ),
    ),
);

$GLOBALS[_FPA_MODULE_NAME . '_MODULES_LIST'] = array(
    'homefeatured' => array(
        'name' => 'homefeatured',
        'displayName' => '',
        'limit' => (Configuration::get('HOME_FEATURED_NBR') ? (int)Configuration::get('HOME_FEATURED_NBR') : 8),
        'callback' => array('class' => 'BT_FpaModuleTools', 'method' => 'getHomeFeaturedProducts'),
    ),
    'blocknewproducts' => array(
        'name' => 'blocknewproducts',
        'displayName' => '',
        'limit' => (Configuration::get('NEW_PRODUCTS_NBR') ? (int)Configuration::get('NEW_PRODUCTS_NBR') : 8),
        'callback' => array('class' => 'BT_FpaModuleTools', 'method' => 'getNewProducts'),
    ),
    'blockbestsellers' => array(
        'name' => 'blockbestsellers',
        'displayName' => '',
        'limit' => (Configuration::get('PS_BLOCK_BESTSELLERS_TO_DISPLAY') ? (int)Configuration::get('PS_BLOCK_BESTSELLERS_TO_DISPLAY') : 8),
        'callback' => array('class' => 'BT_FpaModuleTools', 'method' => 'getBestSellersProducts'),
    ),
    'blockspecials' => array(
        'name' => 'blockspecials',
        'displayName' => '',
        'limit' => (Configuration::get('BLOCKSPECIALS_SPECIALS_NBR') ? (int)Configuration::get('BLOCKSPECIALS_SPECIALS_NBR') : 8),
        'callback' => array('class' => 'BT_FpaModuleTools', 'method' => 'getBlockSpecials'),
    ),
    'homeproducttabs' => array(
        'name' => 'homeproducttabs',
        'displayName' => '',
        'limit' => (Configuration::get('HPPRTB_PROD_PER_PAGE') ? (int)Configuration::get('HPPRTB_PROD_PER_PAGE') : 6),
        'callback' => array('class' => 'BT_FpaModuleTools', 'method' => 'getHomeProductTabs'),
    ),
);

