<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Configuration;

class moduleConfiguration
{
    // General values and path
    const FPA_MODULE_NAME = 'FPA';
    const FPA_MODULE_SET_NAME = 'facebookproductad';
    const FPA_SUPPORT_ID = '23671';
    const FPA_SUPPORT_BT = false;
    const FPA_SUPPORT_URL = 'https://addons.prestashop.com/';
    const FPA_PATH_TPL = _PS_MODULE_DIR_ . 'facebookproductad/views/templates/';
    const FPA_SHOP_PATH_ROOT = _PS_ROOT_DIR_ . '/';
    const FPA_PATH_CONF = _PS_MODULE_DIR_ . 'facebookproductad/conf/';
    const FPA_PATH_SQL = _PS_MODULE_DIR_ . 'facebookproductad/sql/';
    const FPA_LIB_DAO = _PS_MODULE_DIR_ . 'facebookproductad/lib/dao/';
    const FPA_URL_JS = _MODULE_DIR_ . 'facebookproductad/views/js/';
    const FPA_URL_CSS = _MODULE_DIR_ . 'facebookproductad/views/css/';
    const FPA_MODULE_URL = _MODULE_DIR_ . 'facebookproductad/';
    const FPA_URL_IMG = _MODULE_DIR_ . 'facebookproductad/views/img/';
    const FPA_DEBUG = false;
    const FPA_USE_JS = true;
    const FPA_PARAM_CTRL_NAME = 'sController';
    const FPA_ADMIN_CTRL = 'admin';
    const FPA_JS_NAME = 'oPixelFacebook';
    const FPA_CTRL_CRON = 'cron';
    const FPA_CTRL_FLY = 'fly';
    const FPA_REPORTING_DIR = _PS_MODULE_DIR_ . 'facebookproductad/reporting/';
    const FPA_PATH_LIB_HOOK = PS_MODULE_DIR_ . 'facebookproductad/lib/hook/';
    const FPA_TPL_FRONT_PATH = 'front/';
    const FPA_TPL_HOOK_PATH = 'hook/';
    const FPA_PATH_LIB_INSTALL = _PS_MODULE_DIR_ . 'facebookproductad/lib/install/';
    const FPA_INSTALL_SQL_FILE = 'install.sql';
    const FPA_UNINSTALL_SQL_FILE = 'uninstall.sql';
    const FPA_LOG_JAM_SQL = false;
    const FPA_LOG_JAM_CONFIG = false;

    // Specific values for feeds
    const FPA_FEED_TITLE_LENGTH = 150;
    const FPA_IMG_LIMIT = 20;
    const FPA_CUSTOM_LABEL_LIMIT = 5;
    const FPA_TAG_LIST = array('material', 'pattern', 'agegroup', 'gender', 'adult');

    /**
     * return the default conf var
     *
     * @return array
     */
    public static function getTaxonomies()
    {
        $available_taxonomies = array("en-US", "en-GB", "fr-FR", "de-DE", "it-IT", "es-ES", "zh-CN", "ja-JP", "pt-BR", "cs-CZ", "ru-RU", "sv-SE", "da-DK", "no-NO", "pl-PL", "ar-SA");
        sort($available_taxonomies);

        return $available_taxonomies;
    }

    // Available data feed (will me moved later on database)
    const FPA_AVAILABLE_COUNTRIES = array(
        'en' => array(
            'IE' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'GB' => array('currency' => array('GBP', 'KES', 'NGN', 'PAB', 'PKR', 'DZD', 'AOA', 'BYN', 'KHR', 'XAF', 'XOF', 'ETB', 'GHS', 'JOD', 'KZT', 'KWD', 'LBP', 'MGA', 'MUR', 'MAD', 'MZN', 'MMK', 'NPR', 'NIO', 'OMR', 'PYG', 'PEN', 'RON', 'XOF', 'LKR', 'UGX', 'UYU', 'UZS', 'ZMW'), 'taxonomy' => 'en-US'),
            'US' => array('currency' => array('USD', 'KES', 'NGN', 'PAB', 'PKR', 'DZD', 'AOA', 'BYN', 'KHR', 'XAF', 'XOF', 'ETB', 'GHS', 'JOD', 'KZT', 'KWD', 'LBP', 'MGA', 'MUR', 'MAD', 'MZN', 'MMK', 'NPR', 'NIO', 'OMR', 'PYG', 'PEN', 'RON', 'XOF', 'LKR', 'UGX', 'UYU', 'UZS', 'ZMW'), 'taxonomy' => 'en-US'),
            'AU' => array('currency' => array('AUD'), 'taxonomy' => 'en-US'),
            'CA' => array('currency' => array('CAD'), 'taxonomy' => 'en-US'),
            'IN' => array('currency' => array('INR'), 'taxonomy' => 'en-US'),
            'CH' => array('currency' => array('CHF'), 'taxonomy' => 'en-US'),
            'BE' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'DK' => array('currency' => array('DKK'), 'taxonomy' => 'en-US'),
            'NO' => array('currency' => array('NOK'), 'taxonomy' => 'en-US'),
            'MY' => array('currency' => array('MYR'), 'taxonomy' => 'en-US'),
            'ID' => array('currency' => array('RP'), 'taxonomy' => 'en-US'),
            'SE' => array('currency' => array('SEK'), 'taxonomy' => 'en-US'),
            'HK' => array('currency' => array('HKD'), 'taxonomy' => 'en-US'),
            'MX' => array('currency' => array('MXN'), 'taxonomy' => 'en-US'),
            'NZ' => array('currency' => array('NZD'), 'taxonomy' => 'en-US'),
            'PH' => array('currency' => array('PHP'), 'taxonomy' => 'en-US'),
            'SG' => array('currency' => array('SGD'), 'taxonomy' => 'en-US'),
            'TW' => array('currency' => array('TWD'), 'taxonomy' => 'en-US'),
            'AE' => array('currency' => array('AED', 'DZD', 'EGP', 'TND'), 'taxonomy' => 'en-US'),
            'DE' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'AT' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'NL' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'TR' => array('currency' => array('TRY'), 'taxonomy' => 'en-US'),
            'ZA' => array('currency' => array('ZAR'), 'taxonomy' => 'en-US'),
            'CZ' => array('currency' => array('CZK'), 'taxonomy' => 'en-US'),
            'IL' => array('currency' => array('ILS'), 'taxonomy' => 'en-US'),
            'VN' => array('currency' => array('VND'), 'taxonomy' => 'en-US'),
            'TH' => array('currency' => array('THB'), 'taxonomy' => 'en-US'),
            'KO' => array('currency' => array('KRW'), 'taxonomy' => 'en-US'),
            'AR' => array('currency' => array('ARS', 'CRC', 'DOP', 'GTQ'), 'taxonomy' => 'en-US'),
            'BR' => array('currency' => array('BRL'), 'taxonomy' => 'en-US'),
            'CL' => array('currency' => array('CLP'), 'taxonomy' => 'en-US'),
            'CO' => array('currency' => array('COP'), 'taxonomy' => 'en-US'),
            'IT' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'JP' => array('currency' => array('JPY'), 'taxonomy' => 'en-US'),
            'PL' => array('currency' => array('PLN'), 'taxonomy' => 'en-US'),
            'RU' => array('currency' => array('RUB', 'GEL'), 'taxonomy' => 'en-US'),
            'PT' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'SA' => array('currency' => array('AED, SAR', 'DZD', 'EGP'), 'taxonomy' => 'en-US'),
            'ES' => array('currency' => array('EUR', 'GTQ'), 'taxonomy' => 'en-US'),
            'GE' => array('currency' => array('KAS'), 'taxonomy' => 'en-US'),
            'UR' => array('currency' => array('PKR'), 'taxonomy' => 'en-US'),
            'VE' => array('currency' => array('VEF'), 'taxonomy' => 'en-US'),
            'SK' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
            'HU' => array('currency' => array('HUF'), 'taxonomy' => 'en-US'),
            'KW' => array('currency' => array('KWD'), 'taxonomy' => 'en-US'),
        ),
        'gb' => array(
            'AU' => array('currency' => array('AUD'), 'taxonomy' => 'en-GB'),
            'IE' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'IN' => array('currency' => array('INR'), 'taxonomy' => 'en-GB'),
            'CH' => array('currency' => array('CHF'), 'taxonomy' => 'en-GB'),
            'BE' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'DK' => array('currency' => array('DKK'), 'taxonomy' => 'en-GB'),
            'NO' => array('currency' => array('NOK'), 'taxonomy' => 'en-GB'),
            'MY' => array('currency' => array('MYR'), 'taxonomy' => 'en-GB'),
            'ID' => array('currency' => array('IDR'), 'taxonomy' => 'en-GB'),
            'SE' => array('currency' => array('SEK'), 'taxonomy' => 'en-GB'),
            'HK' => array('currency' => array('HKD'), 'taxonomy' => 'en-GB'),
            'MX' => array('currency' => array('MXN'), 'taxonomy' => 'en-GB'),
            'NZ' => array('currency' => array('NZD'), 'taxonomy' => 'en-GB'),
            'PH' => array('currency' => array('PHP'), 'taxonomy' => 'en-GB'),
            'SG' => array('currency' => array('SGD'), 'taxonomy' => 'en-GB'),
            'TW' => array('currency' => array('TWD'), 'taxonomy' => 'en-GB'),
            'SA' => array('currency' => array('AED, SAR', 'DZD', 'EGP', 'TND'), 'taxonomy' => 'en-GB'),
            'DE' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'AT' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'NL' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'TR' => array('currency' => array('TRY'), 'taxonomy' => 'en-GB'),
            'ZA' => array('currency' => array('ZAR'), 'taxonomy' => 'en-GB'),
            'CZ' => array('currency' => array('CZK'), 'taxonomy' => 'en-GB'),
            'IL' => array('currency' => array('ILS'), 'taxonomy' => 'en-GB'),
            'VN' => array('currency' => array('VND'), 'taxonomy' => 'en-GB'),
            'TH' => array('currency' => array('THB'), 'taxonomy' => 'en-GB'),
            'US' => array('currency' => array('USD'), 'taxonomy' => 'en-GB'),
            'GB' => array('currency' => array('GBP'), 'taxonomy' => 'en-GB'),
            'KO' => array('currency' => array('KRW'), 'taxonomy' => 'en-GB'),
            'AR' => array('currency' => array('ARS', 'CRC', 'DOP', 'GTQ'), 'taxonomy' => 'en-GB'),
            'BR' => array('currency' => array('BRL'), 'taxonomy' => 'en-GB'),
            'CL' => array('currency' => array('CLP'), 'taxonomy' => 'en-GB'),
            'CO' => array('currency' => array('COP'), 'taxonomy' => 'en-GB'),
            'IT' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'JP' => array('currency' => array('JPY'), 'taxonomy' => 'en-GB'),
            'PL' => array('currency' => array('PLN'), 'taxonomy' => 'en-GB'),
            'RU' => array('currency' => array('RUB', 'GEL'), 'taxonomy' => 'en-GB'),
            'PT' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'ES' => array('currency' => array('EUR', 'GTQ'), 'taxonomy' => 'en-GB'),
            'GE' => array('currency' => array('KAS'), 'taxonomy' => 'en-GB'),
            'UR' => array('currency' => array('PKR'), 'taxonomy' => 'en-GB'),
            'VE' => array('currency' => array('VEF'), 'taxonomy' => 'en-GB'),
            'SK' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
            'HU' => array('currency' => array('HUF'), 'taxonomy' => 'en-GB'),
        ),
        'fr' => array(
            'FR' => array('currency' => array('EUR', 'TND', 'DZD', 'XAF', 'XOF', 'MGA', 'MAD', 'XPF'), 'taxonomy' => 'fr-FR'),
            'CH' => array('currency' => array('CHF'), 'taxonomy' => 'fr-FR'),
            'CA' => array('currency' => array('CAD'), 'taxonomy' => 'fr-FR'),
            'BE' => array('currency' => array('EUR'), 'taxonomy' => 'fr-FR'),
            'SA' => array('currency' => array('DZD'), 'taxonomy' => 'fr-FR'),
        ),
        'de' => array(
            'EN' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE'),
            'BE' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE'),
            'DE' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE'),
            'CH' => array('currency' => array('CHF'), 'taxonomy' => 'de-DE'),
            'AT' => array('currency' => array('EUR'), 'taxonomy' => 'de-DE')
        ),
        'it' => array(
            'IT' => array('currency' => array('EUR'), 'taxonomy' => 'it-IT'),
            'CH' => array('currency' => array('CHF'), 'taxonomy' => 'it-IT')
        ),
        'nl' => array(
            'NL' => array('currency' => array('EUR'), 'taxonomy' => 'nl-NL'),
            'BE' => array('currency' => array('EUR'), 'taxonomy' => 'nl-NL')
        ),
        'es' => array(
            'ES' => array('currency' => array('EUR', 'MXN', 'ARS', 'CLP', 'COP', 'USD', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
            'MX' => array('currency' => array('MXN', 'EUR', 'ARS', 'CLP', 'COP', 'USD', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
            'AR' => array('currency' => array('ARS', 'EUR', 'MXN', 'CLP', 'COP', 'USD', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
            'CL' => array('currency' => array('CLP', 'EUR', 'MXN', 'ARS', 'COP', 'USD', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
            'CO' => array('currency' => array('COP', 'EUR', 'MXN', 'ARS', 'CLP', 'USD', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
            'US' => array('currency' => array('USD', 'EUR', 'MXN', 'ARS', 'CLP', 'COP', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
        ),

        'mx' => array(
            'ES' => array('currency' => array('EUR', 'MXN', 'ARS', 'CLP', 'COP', 'USD'), 'taxonomy' => 'es-ES'),
            'MX' => array('currency' => array('EUR', 'MXN', 'ARS', 'CLP', 'COP'), 'taxonomy' => 'es-ES'),
            'AR' => array('currency' => array('ARS', 'EUR', 'MXN', 'CLP', 'COP', 'USD'), 'taxonomy' => 'es-ES'),
            'CL' => array('currency' => array('CLP', 'EUR', 'MXN', 'ARS', 'COP', 'USD'), 'taxonomy' => 'es-ES'),
            'CO' => array('currency' => array('COP', 'EUR', 'MXN', 'ARS', 'CLP', 'USD'), 'taxonomy' => 'es-ES'),
            'US' => array('currency' => array('USD', 'EUR', 'MXN', 'ARS', 'CLP', 'COP'), 'taxonomy' => 'es-ES'),
        ),
        'ca' => array(
            'ES' => array('currency' => array('EUR'), 'taxonomy' => 'es-ES'),
        ),
        'zh' => array(
            'CN' => array('currency' => array('CNY'), 'taxonomy' => 'zh-CN'),
            'EN' => array('currency' => array('CNY'), 'taxonomy' => 'zh-CN'),
            'HK' => array('currency' => array('HKD'), 'taxonomy' => 'zh-CN'),
            'TW' => array('currency' => array('TWD'), 'taxonomy' => 'zh-CN'),
            'AU' => array('currency' => array('AUD'), 'taxonomy' => 'zh-CN'),
            'CA' => array('currency' => array('CAD'), 'taxonomy' => 'zh-CN'),
            'US' => array('currency' => array('USD'), 'taxonomy' => 'zh-CN'),
            'SG' => array('currency' => array('SGD'), 'taxonomy' => 'zh-CN'),
        ),
        'ja' => array(
            'JP' => array('currency' => array('JPY'), 'taxonomy' => 'ja-JP')
        ),
        'br' => array(
            'BR' => array('currency' => array('BRL'), 'taxonomy' => 'pt-BR')
        ),
        'cs' => array(
            'CZ' => array('currency' => array('CZK'), 'taxonomy' => 'cs-CZ')
        ),
        'ru' => array(
            'RU' => array('currency' => array('RUB', 'BYR', 'GEL', 'BYN', 'KZT', 'KWD', 'UZS', 'MDL'), 'taxonomy' => 'ru-RU'),
            'UA' => array('currency' => array('UAH'), 'taxonomy' => 'ru-RU')
        ),
        'sv' => array(
            'SE' => array('currency' => array('SEK'), 'taxonomy' => 'sv-SE'),
            'EN' => array('currency' => array('SEK'), 'taxonomy' => 'sv-SE')
        ),
        'da' => array(
            'DK' => array('currency' => array('DKK'), 'taxonomy' => 'da-DK'),
            'EN' => array('currency' => array('DKK'), 'taxonomy' => 'da-DK')
        ),
        'no' => array(
            'NO' => array('currency' => array('NOK'), 'taxonomy' => 'no-NO')
        ),
        'pl' => array(
            'PL' => array('currency' => array('PLN'), 'taxonomy' => 'pl-PL')
        ),
        'tr' => array(
            'TR' => array('currency' => array('TRY'), 'taxonomy' => 'tr-TR')
        ),
        'ms' => array(
            'MY' => array('currency' => array('MYR'), 'taxonomy' => 'en-US')
        ),
        'pt' => array(
            'PT' => array('currency' => array('EUR', 'AOA', 'MZN'), 'taxonomy' => 'es-ES')
        ),
        'ar' => array(
            'SA' => array('currency' => array('SAR', 'AED', 'DZD', 'CRC', 'EGP', 'TND', 'DZD', 'JOD', 'LBP', 'MAD', 'OMR'), 'taxonomy' => 'ar-SA'),
            'AE' => array('currency' => array('AED', 'SAR', 'DZD', 'EGP', 'DZD', 'JOD'), 'taxonomy' => 'ar-SA'),
            'KW' => array('currency' => array('KWD'), 'taxonomy' => 'ar-SA'),
        ),
        'id' => array(
            'ID' => array('currency' => array('IDR'), 'taxonomy' => 'en-US'),
        ),
        'he' => array(
            'IL' => array('currency' => array('ILS'), 'taxonomy' => 'en-US'),
        ),
        'vn' => array(
            'VN' => array('currency' => array('VND'), 'taxonomy' => 'en-US'),
        ),
        'uk' => array(
            'UA' => array('currency' => array('UAH'), 'taxonomy' => 'en-US'),
        ),
        'th' => array(
            'TH' => array('currency' => array('THB'), 'taxonomy' => 'en-US'),
        ),
        'ko' => array(
            'KO' => array('currency' => array('KRW'), 'taxonomy' => 'en-US'),
        ),
        'fi' => array(
            'FI' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
        ),
        'hu' => array(
            'HU' => array('currency' => array('HUF'), 'taxonomy' => 'en-GB'),
        ),
        'ag' => array(
            'AR' => array('currency' => array('CRC', 'DOP', 'GTQ'), 'taxonomy' => 'es-ES'),
        ),
        'ur' => array(
            'UR' => array('currency' => array('PKR'), 'taxonomy' => 'en-US'),
        ),
        've' => array(
            'VE' => array('currency' => array('VEF'), 'taxonomy' => 'es-ES'),
        ),
        'sk' => array(
            'SK' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
        ),
        'ro' => array(
            'RO' => array('currency' => array('RON', 'MDL'), 'taxonomy' => 'en-GB'),
        ),
        'el' => array(
            'GR' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
        ),
        'lt' => array(
            'LT' => array('currency' => array('EUR'), 'taxonomy' => 'en-GB'),
        ),
        'et' => array(
            'EE' => array('currency' => array('EUR'), 'taxonomy' => 'en-US'),
        ),
        'si' => array(
            'SI' => array('currency' => array('EUR', 'USD'), 'taxonomy' => 'en-GB'),
        ),
        'hr' => array(
            'HR' => array('currency' => array('EUR', 'USD'), 'taxonomy' => 'en-GB'),
        ),
        'qc' => array(
            'CA' => array('currency' => array('cAD'), 'taxonomy' => 'fr-FR')
        ),
        'pe' => array(
            'PE' => array('currency' => array('USD', 'EUR', 'MXN', 'ARS', 'CLP', 'COP', 'CRC', 'GTQ', 'PYG', 'NIO', 'PEN', 'UYU'), 'taxonomy' => 'es-ES'),
        ),
        'sr' => array(
            'CS' => array('currency' => array('RSD'), 'taxonomy' => 'en-GB'),
            'SR' => array('currency' => array('RSD'), 'taxonomy' => 'en-GB')
        ),
    );

    const FPA_WEIGHT_UNITS = array('kg', 'lb', 'g', 'oz');

    const FPA_HOOKS = array(
        array('name' => 'displayHeader', 'use' => false, 'title' => 'Header'),
        array('name' => 'actionValidateOrder', 'use' => false, 'title' => 'Validate order'),
    );

    const FPA_TABS = array();

    const FPA_TAGS_TYPE = array(
        'home' => 'home',
        'category' => 'category',
        'product' => 'product',
        'cart' => 'cart',
        'purchase' => 'purchase',
        'search' => 'searchresults',
        'other' => 'other',
        'manufacturer' => 'manufacturer',
        'promotion' => 'promotion',
        'newproducts' => 'newproducts',
        'bestsales' => 'bestsales',
        'paymentInfo' => 'paymentInfo',
        'instantSearch' => 'instantSearch',
        'checkout' => 'checkout',
        'contact' => 'contact',
    );

    //
    const FPA_HOME_CAT_NAME = array(
        'en' => 'home',
        'fr' => 'accueil',
        'it' => 'ignazio',
        'es' => 'ignacio',
    );

    const FPA_LABEL_LIST = array(
        'cats' => 'category',
        'brands' => 'brand',
        'suppliers' => 'supplier'
    );

    const FPA_PARAM_FOR_XML = array(
        'iShopId',
        'sFilename',
        'iLangId',
        'sLangIso',
        'sCountryIso',
        'sCurrencyIso',
        'iFloor',
        'iStep',
        'iTotal',
        'iProcess',
        'bExcludedProduct'
    );

    const FPA_RULES_LABEL_TYPE = array(
        'word' => array(
            'en' => 'Based on words',
            'es' => 'Based on words',
            'it' => 'Based on words',
            'fr' => 'Basé sur des mots'
        ),
        'feature' => array(
            'en' => 'Based on feature',
            'es' => 'Based on feature',
            'it' => 'Based on feature',
            'fr' => 'Basé sur des caractéristiques'
        ),
        'attribute' => array(
            'en' => 'Based on attributes',
            'es' => 'Based on attributes',
            'it' => 'Based on attributes',
            'fr' => 'Basé sur des attributs'
        ),
        'specificProduct' => array(
            'en' => 'Specific product',
            'es' => 'Produits Specifiques',
            'it' => 'BSpecific product',
            'fr' => 'Specific product'
        ),
    );

    const FPA_RULES_WORD_TYPE = array(
        'title' => array(
            'en' => 'Product title',
            'es' => 'Product title',
            'it' => 'Product title',
            'fr' => 'Nom du produit'
        ),
        'description' => array(
            'en' => 'Description',
            'es' => 'Description',
            'it' => 'Description',
            'fr' => 'Description'
        ),
        'both' => array(
            'en' => 'Product name + description',
            'es' => 'Product name + description',
            'it' => 'Product name + description',
            'fr' => 'Nom du produit + description'
        ),
    );

    const FPA_EXCLUSION_TYPE_WORD = array(
        'title' => array(
            'en' => 'Product title',
            'fr' => 'Titre du produit',
            'es' => 'Product title',
            'it' => 'Product title'
        ),
        'description' => array(
            'en' => 'Product description',
            'fr' => 'Description du produit',
            'es' => 'Product description',
            'it' => 'Product description'
        ),
        'both' => array(
            'en' => 'Title and description',
            'fr' => 'Titre et description',
            'es' => 'Title and description',
            'it' => 'Title and description'
        ),
    );

    const FPA_CUSTOM_LABEL_TYPE = array(
        'en' => array(
            'custom_label' => 'Basic',
            'dynamic_categorie' => 'Categories (dynamic mode)',
            'dynamic_features_list' => 'Features (dynamic mode)',
            'dynamic_new_product' => 'New product (dynamic mode)',
            'dynamic_best_sale' => 'Best sales (dynamic mode)',
            'dynamic_price_range' => 'Price range (dynamic mode)',
            'dynamic_last_order' => 'Products ordered (dynamic mode)',
            'dynamic_promotion' => 'Products in promotion (dynamic mode)'
        ),
        'fr' => array(
            'custom_label' => 'Basique',
            'dynamic_categorie' => 'Catégories (mode dynamique)',
            'dynamic_features_list' => 'Caractéristiques (mode dynamique)',
            'dynamic_new_product' => 'Nouveaux produits (mode dynamique)',
            'dynamic_best_sale' => 'Meilleures ventes (mode dynamique)',
            'dynamic_price_range' => 'Tranche de prix (mode dynamique)',
            'dynamic_last_order' => 'Produits commandés (mode dynamique)',
            'dynamic_promotion' => 'Produits en promotion (mode dynamique)'
        ),
        'it' => array(
            'custom_label' => 'Di base',
            'dynamic_categorie' => 'Categorie (dinamica di modo)',
            'dynamic_features_list' => 'Caratteristiche (modalità dinamica)',
            'dynamic_new_product' => 'Nuovo prodotto (modalità dinamica)',
            'dynamic_best_sale' => 'Le migliori vendite (modalità dinamica)',
            'dynamic_price_range' => 'Fascia di prezzo (modalità dinamica)',
            'dynamic_last_order' => 'Prodotti ordinati (modalità dinamica)',
            'dynamic_promotion' => 'Prodotti promozionali (modalità dinamica)'
        ),
        'es' => array(
            'custom_label' => 'Básica',
            'dynamic_categorie' => 'Categorías (modo dinámico)',
            'dynamic_features_list' => 'Atributos (modo dinámico)',
            'dynamic_new_product' => 'Nuevo producto (modo dinámico)',
            'dynamic_best_sale' => 'Las mejores ventas (modo dinámico)',
            'dynamic_price_range' => 'Rango de precios (modo dinámico)',
            'dynamic_last_order' => 'Productos pedidos (modo dinámico)',
            'dynamic_promotion' => 'Productos promocionales (modo dinámico)',
        ),
    );

    const FPA_CL_PRODUCT_ASSOCIATION = array(
        'en' => 'There is no product for this custom label configuration. We invite you to edit it the custom label from the list by closing the windows',
        'fr' => 'Il n y\'a pas de produits associés à la configuration du custom label. Vous pouvez l\'éditer depuis la liste en fermant cette fenêtre',
        'it' => 'Non esiste alcun prodotto per questa configurazione di etichetta personalizzata. Ti invitiamo a modificare l\'etichetta personalizzata dall\'elenco chiudendo le finestre',
        'es' => 'No hay ningún producto para esta configuración de etiqueta personalizada. Le invitamos a editar la etiqueta personalizada de la lista cerrando las ventanas',
    );

    const FPA_CUSTOM_LABEL_BEST_TYPE  = array(
        'en' => array('unit' => 'Unit', 'price' => 'Revenue generated'),
        'fr' => array('unit' => 'Entités vendues', 'price' => 'Chiffre d\'affaire généré'),
        'it' => array('unit' => 'Articoli venduti', 'price' => 'Ricavi generati'),
        'es' => array('unit' => 'Cosas vendidas', 'price' => 'Ingresos generados'),
    );

    const FPA_CUSTOM_LABEL_BEST_PERIOD_TYPE = array(
        'period' => 'Period',
        'days' => 'For X lasts days'
    );

    const FPA_CUSTOM_LABEL_PRODUCT_FILTER = array(
        'category' => array(
            'sFieldSelect' => 'id_category',
            'sPopulateTable' => 'fpa_tags_cats',
            'bUsePsTable' => 1,
            'bUseCategory' => 1,
            'sPsTable' => 'category_product',
            'sPsTableWhere' => 'id_category',
        ),
        'brand' => array(
            'sFieldSelect' => 'id_brand',
            'sPopulateTable' => 'fpa_tags_brands',
            'bUsePsTable' => 1,
            'sPsTable' => 'product',
            'sPsTableWhere' => 'id_manufacturer',
        ),
        'product' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_products',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
        'dyn_cat' => array(
            'sFieldSelect' => 'id_category',
            'sPopulateTable' => 'fpa_tags_dynamic_categories',
            'bUsePsTable' => 1,
            'sPsTable' => 'category_product',
            'sPsTableWhere' => 'id_category',
        ),
        'dyn_feature' => array(
            'sFieldSelect' => 'id_feature',
            'sPopulateTable' => 'fpa_tags_dynamic_features',
            'bUsePsTable' => 1,
            'sPsTable' => 'feature_product',
            'sPsTableWhere' => 'id_feature',
        ),
        'dyn_new_product' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_dynamic_new_product',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
        'dyn_best_dale' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_dynamic_best_sale',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
        'dyn_price_range' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_price_range',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
        'dyn_promotion' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_dynamic_promotion',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
        'dyn_ordered' => array(
            'sFieldSelect' => 'id_product',
            'sPopulateTable' => 'fpa_tags_dynamic_last_product_ordered',
            'bUsePsTable' => 0,
            'sPsTable' => '',
            'sPsTableWhere' => '',
        ),
    );


    /**
     * return the default conf var
     *
     * @return array
     */
    public static function getConfVar()
    {
        return  array(
            'FPA_VERSION' => '',
            'FPA_HOME_CAT' => '',
            'FPA_LINK' => '',
            'FPA_ID_PREFIX' => '',
            'FPA_AJAX_CYCLE' => 1000,
            'FPA_EXPORT_OOS' => 1,
            'FPA_COND' => 'new',
            'FPA_P_COMBOS' => 0,
            'FPA_P_DESCR_TYPE' => 3,
            'FPA_IMG_SIZE' => version_compare(_PS_VERSION_, '1.7', '>=') ? \ImageType::getFormattedName('large') : \ImageType::getFormatedName('large'),
            'FPA_EXC_NO_EAN' => 0,
            'FPA_EXC_NO_MREF' => 0,
            'FPA_MIN_PRICE' => 0,
            'FPA_INC_STOCK' => 1,
            'FPA_INC_FEAT' => 0,
            'FPA_FEAT_OPT' => 0,
            'FPA_INC_GENRE' => 0,
            'FPA_GENRE_OPT' => 0,
            'FPA_INC_SIZE' => 0,
            'FPA_SIZE_OPT' => 0,
            'FPA_INC_COLOR' => '',
            'FPA_COLOR_OPT' => '',
            'FPA_INC_MATER' => 0,
            'FPA_MATER_OPT' => 0,
            'FPA_INC_PATT' => 0,
            'FPA_PATT_OPT' => 0,
            'FPA_INC_GEND' => 0,
            'FPA_GEND_OPT' => 0,
            'FPA_INC_ADULT' => 0,
            'FPA_ADULT_OPT' => 0,
            'FPA_INC_AGE' => 0,
            'FPA_AGE_OPT' => 0,
            'FPA_SHIP_CARRIERS' => '',
            'FPA_REPORTING' => 1,
            'FPA_HOME_CAT_ID' => 1,
            'FPA_MPN_TYPE' => 'supplier_ref',
            'FPA_INC_ID_EXISTS' => 0,
            'FPA_ADD_CURRENCY' => 0,
            'FPA_UTM_CAMPAIGN' => '',
            'FPA_UTM_SOURCE' => '',
            'FPA_UTM_MEDIUM' => '',
            'FPA_FEED_TOKEN' => md5(rand(1000, 1000000) . time()),
            'FPA_EXPORT_MODE' => 0,
            'FPA_ADV_PRODUCT_NAME' => 0,
            'FPA_ADV_PROD_TITLE' => 0,
            'FPA_CHECK_EXPORT' => '',
            'FPA_INC_TAG_ADULT' => 0,
            'FPA_SHIPPING_USE' => 1,
            'FPA_PROD_EXCL' => '',
            'FPA_GTIN_PREF' => 'ean',
            'FPA_DISP_ADVICE' => 1,
            'FPA_PIXEL' => '',
            'FPA_BUSINESS_ID' => '',
            'FPA_USE_TAX' => 1,
            'FPA_USE_SHIPPING' => 1,
            'FPA_USE_WRAPPING' => 1,
            'FPA_CUSTOM_DOM_ELEM' => 0,
            'FPA_JS_CART_SELECTOR_PROD' => '.add-to-cart',
            'FPA_JS_WISH_SELECTOR_PROD' => 'button.wishlist-button-add',
            'FPA_JS_CART_SELECTOR_CAT' =>  'a[rel=ajax_id_product__PRODUCT_ID_].ajax_add_to_cart_button',
            'FPA_JS_ORDER_SELECTOR' =>  'button[name="confirm-addresses"]',
            'FPA_JS_WISH_SELECTOR_CAT' => 'a[rel="_PRODUCT_ID_"].addToWishlist',
            'FPA_TRACK_HOME' => 0,
            'FPA_CONF_STEP_1' => 0,
            'FPA_CONF_STEP_2' => 0,
            'FPA_CONF_STEP_3' => 0,
            'FPA_CONF_STEP_4' => 0,
            'FPA_ADD_LANG_ID' => 1,
            'FPA_USE_CONSENT' => 0,
            'FPA_URL_NUM_ATTR_REWRITE' => 0,
            'FPA_URL_ATTR_ID_INCL' => 0,
            'FPA_COMBO_SEPARATOR' => 'v',
            'FPA_ADD_IMAGES' => 1,
            'FPA_URL_PROD_ERROR' => 0,
            'FPA_PROD_PRICE_TAX' => 1,
            'FPA_TRACK_ADD_CART_PAGE' => 0,
            'FPA_CL_AUTO_UPDATE' => 1,
            'FPA_ELEMENT_HTML_ID' => '',
            'FPA_USE_API' => 0,
            'FPA_ADVANCED_MATCHING' => 0,
            'FPA_HAS_WARNING' => 0,
            'FPA_TOKEN_API' => '',
            'FPA_EXCLUDED_WORDS' => '',
        );
    }

    /**
     * return the default JS messages
     *
     * @return array
     */
    public static function getJsMessage()
    {
        return array(
            'customlabel' => \FacebookProductAd::$oModule->l('You have not indicated a name for your custom label', 'moduleTools'),
            'link' =>  \FacebookProductAd::$oModule->l('You have not filled in the shop URL', 'moduleTools'),
            'token' =>  \FacebookProductAd::$oModule->l('Field is required and token must be 32 characters', 'moduleTools'),
            'customlabel' =>  \FacebookProductAd::$oModule->l('You have not indicated a name for your custom label', 'moduleTools'),
            'ruleName' =>  \FacebookProductAd::$oModule->l('You have not indicated a name for your exclusion rule', 'moduleTools'),
            'category' =>  \FacebookProductAd::$oModule->l('You have not selected any category to be exported', 'moduleTools'),
            'brand' =>  \FacebookProductAd::$oModule->l('You have not selected any brand to be exported', 'moduleTools'),
            'color' =>  \FacebookProductAd::$oModule->l('You have not selected any attribute or feature to be associated with the color tag', 'moduleTools'),
            'customDom' =>  \FacebookProductAd::$oModule->l('Please set a value', 'moduleTools'),
            'cycle' =>  \FacebookProductAd::$oModule->l('Please set a numeric value', 'moduleTools'),
            'bannerId' =>  \FacebookProductAd::$oModule->l('You have not specified the HTML element that corresponds to the cookie acceptance button', 'moduleTools'),
        );
    }

    /**
     * return the default month string
     *
     * @return array
     */
    public static function getMonths()
    {
        return  array(
            'en' => array(
                'short' => array('', 'Jan.', 'Feb.', 'March', 'Apr.', 'May', 'June', 'July', 'Aug.', 'Sept.', 'Oct.', 'Nov.', 'Dec.'),
                'long' => array('', 'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'),
            ),
            'fr' => array(
                'short' => array('', 'Jan.', 'F&eacute;v.', 'Mars', 'Avr.', 'Mai', 'Juin', 'Juil.', 'Aout', 'Sept.', 'Oct.', 'Nov.', 'D&eacute;c.'),
                'long' => array('', 'Janvier', 'F&eacute;vrier', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Aout', 'Septembre', 'Octobre', 'Novembre', 'D&eacute;cembre'),
            ),
            'de' => array(
                'short' => array('', 'Jan.', 'Feb.', 'M' . chr(132) . 'rz', 'Apr.', 'Mai', 'Juni', 'Juli', 'Aug.', 'Sept.', 'Okt.', 'Nov.', 'Dez.'),
                'long' => array('', 'Januar', 'Februar', 'M' . chr(132) . 'rz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'),
            ),
            'it' => array(
                'short' => array('', 'Gen.', 'Feb.', 'Marzo', 'Apr.', 'Mag.', 'Giu.', 'Lug.', 'Ago.', 'Sett.', 'Ott.', 'Nov.', 'Dic.'),
                'long' => array('', 'Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'),
            ),
            'es' => array(
                'short' => array('', 'Ene.', 'Feb.', 'Marzo', 'Abr.', 'Mayo', 'Junio', 'Jul.', 'Ago.', 'Sept.', 'Oct.', 'Nov.', 'Dic.'),
                'long' => array('', 'Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'),
            ),
        );
    }

    /**
     * return the module and product for the module on the homepage
     *
     * @return array
     */
    public static function getHomeModules()
    {
        return array(
            version_compare(_PS_VERSION_, '1.7', '>=') ? 'ps_featuredproducts' : 'homefeatured' => array(
                'name' => 'homefeatured',
                'displayName' => '',
                'limit' => (\Configuration::get('HOME_FEATURED_NBR') ? (int) \Configuration::get('HOME_FEATURED_NBR') : 8),
                'callback' => array('class' => 'moduleTools', 'method' => 'getHomeFeaturedProducts'),
            ),
            version_compare(_PS_VERSION_, '1.7', '>=') ? 'ps_newproducts' : 'blocknewproducts' => array(
                'name' => 'blocknewproducts',
                'displayName' => '',
                'limit' => (\Configuration::get('NEW_PRODUCTS_NBR') ? (int) \Configuration::get('NEW_PRODUCTS_NBR') : 8),
                'callback' => array('class' => 'moduleTools', 'method' => 'getNewProducts'),
            ),
            version_compare(_PS_VERSION_, '1.7', '>=') ? 'ps_bestsellers' : 'blockbestsellers' => array(
                'name' => 'blockbestsellers',
                'displayName' => '',
                'limit' => (\Configuration::get('PS_BLOCK_BESTSELLERS_TO_DISPLAY') ? (int) \Configuration::get('PS_BLOCK_BESTSELLERS_TO_DISPLAY') : 8),
                'callback' => array('class' => 'moduleTools', 'method' => 'getBestSellersProducts'),
            ),
            version_compare(_PS_VERSION_, '1.7', '>=') ? 'ps_specials' : 'blockspecials' => array(
                'name' => 'blockspecials',
                'displayName' => '',
                'limit' => (\Configuration::get('BLOCKSPECIALS_SPECIALS_NBR') ? (int) \Configuration::get('BLOCKSPECIALS_SPECIALS_NBR') : 8),
                'callback' => array('class' => 'moduleTools', 'method' => 'getBlockSpecials'),
            ),
            'homeproducttabs' => array(
                'name' => 'homeproducttabs',
                'displayName' => '',
                'limit' => (\Configuration::get('HPPRTB_PROD_PER_PAGE') ? (int) \Configuration::get('HPPRTB_PROD_PER_PAGE') : 6),
                'callback' => array('class' => 'moduleTools', 'method' => 'getHomeProductTabs'),
            ),
        );
    }

    /**
     * return the array of table and SQL files to use
     *
     * @return array
     */
    public static function getSqlUpdateData()
    {
        return  array(
            'table' => array(
                '1400' => 'update-1400.sql',
            ),
            'field' => array()
        );
    }

    /**
     * return the array of available request params
     *
     * @return array
     */
    public static function getRequestParams()
    {
        return  array(
            'basic' => array('action' => 'update', 'type' => 'basic'),
            'feed' => array('action' => 'update', 'type' => 'feed'),
            'feedDisplay' => array('action' => 'display', 'type' => 'feed'),
            'facebook' => array('action' => 'update', 'type' => 'facebook'),
            'taxonomy' => array('action' => 'display', 'type' => 'taxonomy'),
            'feedList' => array('action' => 'display', 'type' => 'feedList'),
            'feedListUpdate' => array('action' => 'update', 'type' => 'feedList'),
            'reporting' => array('action' => 'update', 'type' => 'reporting'),
            'reportingBox' => array('action' => 'display', 'type' => 'reportingBox'),
            'tag' => array('action' => 'display', 'type' => 'tag'),
            'tagUpdate' => array('action' => 'update', 'type' => 'tag'),
            'facebookCat' => array('action' => 'display', 'type' => 'facebookCategories'),
            'facebookCatUpdate' => array('action' => 'update', 'type' => 'facebookCategoriesMatching'),
            'facebookCatSync' => array('action' => 'update', 'type' => 'facebookCategoriesSync'),
            'custom' => array('action' => 'display', 'type' => 'customLabel'),
            'customUpdate' => array('action' => 'update', 'type' => 'label'),
            'customDelete' => array('action' => 'delete', 'type' => 'label'),
            'autocomplete' => array('action' => 'display', 'type' => 'autocomplete'),
            'searchProduct' => array('action' => 'display', 'type' => 'searchProduct'),
            'dataFeed' => array('action' => 'update', 'type' => 'xml'),
            'advice' => array('action' => 'display', 'type' => 'advice'),
            'adviceUpd' => array('action' => 'update', 'type' => 'advice'),
            'pixel' => array('action' => 'update', 'type' => 'pixel'),
            'newCustomFeed' => array('action' => 'display', 'type' => 'newCustomFeed'),
            'newFeed' => array('action' => 'update', 'type' => 'newFeed'),
            'exclusionRule' => array('action' => 'display', 'type' => 'exclusionRule'),
            'exclusionRuleDelete' => array('action' => 'delete', 'type' => 'exclusionRule'),
            'rulesSummary' => array('action' => 'display', 'type' => 'rulesSummary'),
            'rulesList' => array('action' => 'update', 'type' => 'rulesList'),
            'exclusionRuleForm' => array('action' => 'update', 'type' => 'exclusionRule'),
            'excludeValue' => array('action' => 'display', 'type' => 'excludeValue'),
            'rulesActivate' => array('action' => 'update', 'type' => 'rulesActivate'),
            'exclusionRuleProducts' => array('action' => 'display', 'type' => 'exclusionRuleProducts'),
            'customActivate' => array('action' => 'update', 'type' => 'labelState'),
            'customProduct' => array('action' => 'display', 'type' => 'customLabelProduct'),
            'position' => array('action' => 'update', 'type' => 'position'),
            'consent' => array('action' => 'update', 'type' => 'consent'),
            'feedListSynch' => array('action' => 'update', 'type' => 'feedListSynch'),
        );
    }
}
