<?php
/**
 * admin-display_class.php file defines method to display content tabs of admin page
 */

class BT_AdminDisplay implements BT_IAdmin
{
    /**
     * @var array $aFlagIds : array for all flag ids used in option translation
     */
    protected $aFlagIds = array();

    /**
     * Magic Method __construct
     */
    private function __construct()
    {

    }

    /**
     * Magic Method __destruct
     */
    public function __destruct()
    {

    }

    /**
     * run() method display all configured data admin tabs
     *
     * @param string $sType => define which method to execute
     * @param array $aParam
     * @return array
     */
    public function run($sType, array $aParam = null)
    {
        // set variables
        $aDisplayData = array();

        if (empty($sType)) {
            $sType = 'tabs';
        }

        switch ($sType) {
            case 'tabs' : // use case - display first page with all tabs
            case 'basics' : // use case - display basics settings page
            case 'feed' : // use case - display feed settings page
            case 'facebook' : // use case - display facebook settings page
            case 'facebookCategories' : // use case - display facebook categories settings page
            case 'customLabel' : // use case - display facebook custom label settings popup
            case 'autocomplete' : // use case - display autocomplete for facebook categories
            case 'feedList' : // use case - display feed list settings page
            case 'reporting' : // use case - display reporting settings page
            case 'reportingBox' : // use case - display reporting fancybox
            case 'searchProduct' : // use case - handle products autocomplete
            case 'advice' : // use case - handle advice form
            case 'pixel' : // use case - handle pixel form
            case 'newCustomFeed' : // use case - handle new custom field
                // include
                require_once(_FPA_PATH_LIB . 'module-dao_class.php');

                // execute match function
                $aDisplayData = call_user_func_array(array($this, '_display' . ucfirst($sType)), array($aParam));
                break;
            case 'tag' : // use case - display adult tag settings page
                // include
                require_once(_FPA_PATH_LIB . 'module-dao_class.php');

                // execute match function
                $aDisplayData = call_user_func_array(array($this, '_displayAdvancedTagCategory'), array($aParam));
                break;
            default :
                break;
        }
        // use case - generic assign
        if (!empty($aDisplayData)) {
            $aDisplayData['assign'] = array_merge($aDisplayData['assign'], $this->_assign());
        }

        return (
        $aDisplayData
        );
    }

    /**
     * _assign() method assigns transverse data
     *
     * @return array
     */
    private function _assign()
    {
        // set smarty variables
        $aAssign = array(
            'sURI' => BT_FpaModuleTools::truncateUri(array('&sAction')),
            'sCtrlParamName' => _FPA_PARAM_CTRL_NAME,
            'sController' => _FPA_ADMIN_CTRL,
            'aQueryParams' => $GLOBALS[_FPA_MODULE_NAME . '_REQUEST_PARAMS'],
            'sDisplay' => Tools::getValue('sDisplay'),
            'iCurrentLang' => intval(FacebookProductAd::$iCurrentLang),
            'sCurrentLang' => FacebookProductAd::$sCurrentLang,
            'sCurrentIso' => Language::getIsoById(FacebookProductAd::$iCurrentLang),
            'bDisplayAdvice' => FacebookProductAd::$aConfiguration['FPA_DISP_ADVICE'],
            'sFlagIds' => $this->_getFlagIds(),
            'aFlagIds' => $this->aFlagIds,
            'sTs' => time(),
            'bAjaxMode' => (FacebookProductAd::$sQueryMode == 'xhr' ? true : false),
            'bCompare149' => FacebookProductAd::$bCompare149,
            'bCompare15' => FacebookProductAd::$bCompare15,
            'bCompare16' => FacebookProductAd::$bCompare16,
            'bCompare17' => FacebookProductAd::$bCompare17,
            'bPsVersion1606' => version_compare(_PS_VERSION_, '1.6.0.6', '>='),
            'sLoadingImg' => _FPA_URL_IMG . 'admin/' . _FPA_LOADER_GIF,
            'sBigLoadingImg' => _FPA_URL_IMG . 'admin/' . _FPA_LOADER_GIF_BIG,
            'sHeaderInclude' => BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_HEADER),
            'sErrorInclude' => BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_ERROR),
            'sConfirmInclude' => BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_CONFIRM),

        );

        return $aAssign;
    }

    /**
     * _displayTabs() method displays admin's first page with all tabs
     *
     * @param array $aPost
     * @return array
     */
    private function _displayTabs(array $aPost = null)
    {
        //get support to use
        $iSupportToUse = _FPA_SUPPORT_BT;

        // set smarty variables
        $aAssign = array(
            'sDocUri' => _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/',
            'sDocName' => 'readme_' . ((FacebookProductAd::$sCurrentLang == 'fr') ? 'fr' : 'en') . '.pdf',
            'sContactUs' => !empty($iSupportToUse) ? _FPA_SUPPORT_URL . ((FacebookProductAd::$sCurrentLang == 'fr') ? 'fr/contactez-nous' : 'en/contact-us') : _FPA_SUPPORT_URL . ((FacebookProductAd::$sCurrentLang == 'fr') ? 'fr/ecrire-au-developpeur?id_product=' . _FPA_SUPPORT_ID : 'en/write-to-developper?id_product=' . _FPA_SUPPORT_ID),
            'sRateUrl' => !empty($iSupportToUse) ? _FPA_SUPPORT_URL . ((FacebookProductAd::$sCurrentLang == 'fr') ? 'fr/modules-prestashop-reseaux-sociaux-facebook/50-module-prestashop-publicites-de-produits-facebook-pixel-facebook-0656272916497.html' : 'en/prestashop-modules-social-networks-facebook/50-prestashop-addon-facebook-product-ads-facebook-pixel-0656272916497.html') : _FPA_SUPPORT_URL . ((FacebookProductAd::$sCurrentLang == 'fr') ? '/fr/ratings.php' : '/en/ratings.php'),
            'sCrossSellingUrl' => !empty($iSupportToUse) ? _FPA_SUPPORT_URL . '?utm_campaign=internal-module-ad&utm_source=banniere&utm_medium=' . _FPA_MODULE_SET_NAME : _FPA_SUPPORT_URL . FacebookProductAd::$sCurrentLang . '/6_business-tech',
            'sCrossSellingImg' => (FacebookProductAd::$sCurrentLang == 'fr') ? _FPA_URL_IMG . 'admin/module_banner_cross_selling_FR.jpg' : _FPA_URL_IMG . 'admin/module_banner_cross_selling_EN.jpg',
            'sCurrentIso' => Language::getIsoById(FacebookProductAd::$iCurrentLang),

        );

        // check warnings
        // PHP script well copied - file exists
        BT_FpaWarning::create()->run('file-exists', _FPA_PATH_ROOT . _FPA_XML_PHP_NAME,
            _PS_ROOT_DIR_ . '/' . _FPA_XML_PHP_NAME);
        $aAssign['bFileStopExec'] = BT_FpaWarning::create()->bStopExecution;

        // check curl_init and file_get_contents to get the distant Facebook taxonomy file
        BT_FpaWarning::create()->run('directive', 'allow_url_fopen', array(), true);
        $bTmpStopExec = BT_FpaWarning::create()->bStopExecution;
        BT_FpaWarning::create()->bStopExecution = false;
        BT_FpaWarning::create()->run('function', 'curl_init', array(), true);
        if ($bTmpStopExec && BT_FpaWarning::create()->bStopExecution) {
            $aAssign['bCurlAndContentStopExec'] = true;
        }

        // check if multi-shop configuration
        if (version_compare(_PS_VERSION_, '1.5', '>')
            && Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')
            && strpos(Context::getContext()->cookie->shopContext, 'g-') !== false
        ) {
            $aAssign['bMultishopGroupStopExec'] = true;
        }

        // check if shipping weight unit
        $sWeightUnit = Configuration::get('PS_WEIGHT_UNIT');
        if (!empty($sWeightUnit)
            && !in_array($sWeightUnit, $GLOBALS[_FPA_MODULE_NAME . '_WEIGHT_UNITS'])
        ) {
            $aAssign['bWeightUnitStopExec'] = true;
        }

        // check if we hide the config
        if (!empty($aAssign['bFileStopExec'])
            || !empty($aAssign['bCurlAndContentStopExec'])
            || !empty($aAssign['bMultishopGroupStopExec'])
            || !empty($aAssign['bWeightUnitStopExec'])
        ) {
            $aAssign['bHideConfiguration'] = true;
        }

        if (!empty(FacebookProductAd::$bCompare15)) {
            $aAssign['autocmp_js'] = __PS_BASE_URI__ . 'js/jquery/plugins/autocomplete/jquery.autocomplete.js';
            $aAssign['autocmp_css'] = __PS_BASE_URI__ . 'js/jquery/plugins/autocomplete/jquery.autocomplete.css';
        } else {
            $aAssign['autocmp_js'] = __PS_BASE_URI__ . 'js/jquery/jquery.autocomplete.js';
            $aAssign['autocmp_css'] = __PS_BASE_URI__ . 'css/jquery.autocomplete.css';
        }

        // use case - get display data of basics settings
        $aData = $this->_displayBasics($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // use case - get display data of feed data settings
        $aData = $this->_displayFeed($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // use case - get display data of facebook settings
        $aData = $this->_displayFacebook($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // use case - get display data of feed list settings
        $aData = $this->_displayFeedList($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // use case - get display data of feed list settings
        $aData = $this->_displayReporting($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // use case - get display pixel settings
        $aData = $this->_displayPixel($aPost);

        $aAssign = array_merge($aAssign, $aData['assign']);

        // assign all included templates files
        $aAssign['sBasicsInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_BASICS);
        $aAssign['sFeedInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_FEED_SETTINGS);
        $aAssign['sFacebookInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_FACEBOOK_SETTINGS);
        $aAssign['sFeedListInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_FEED_LIST);
        $aAssign['sReportingInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_REPORTING);
        $aAssign['sPixelInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_PIXEL_CONFIG);
        $aAssign['sModuleVersion'] = FacebookProductAd::$oModule->version;
        $aAssign['sModuleVersion'] = FacebookProductAd::$oModule->version;

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_BODY,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayBasics() method displays basic settings
     *
     * @param array $aPost
     * @return array
     */
    private function _displayBasics(array $aPost = null)
    {
        $aAssign = array(
            'sDocUri' => _MODULE_DIR_ . _FPA_MODULE_SET_NAME . '/',
            'sDocName' => 'readme_' . ((FacebookProductAd::$sCurrentLang == 'fr') ? 'fr' : 'en') . '.pdf',
            'sLink' => (!empty(FacebookProductAd::$aConfiguration['FPA_LINK']) ? FacebookProductAd::$aConfiguration['FPA_LINK'] : FacebookProductAd::$sHost),
            'sPrefixId' => FacebookProductAd::$aConfiguration['FPA_ID_PREFIX'],
            'iProductPerCycle' => FacebookProductAd::$aConfiguration['FPA_AJAX_CYCLE'],
            'sImgSize' => FacebookProductAd::$aConfiguration['FPA_IMG_SIZE'],
            'aHomeCatLanguages' => FacebookProductAd::$aConfiguration['FPA_HOME_CAT'],
            'iHomeCatId' => FacebookProductAd::$aConfiguration['FPA_HOME_CAT_ID'],
            'bAddCurrency' => FacebookProductAd::$aConfiguration['FPA_ADD_CURRENCY'],
            'iAdvancedProductName' => FacebookProductAd::$aConfiguration['FPA_ADV_PRODUCT_NAME'],
            'iAdvancedProductTitle' => FacebookProductAd::$aConfiguration['FPA_ADV_PROD_TITLE'],
            'bFeedProtection' => FacebookProductAd::$aConfiguration['FPA_FEED_PROTECTION'],
            'sFeedToken' => FacebookProductAd::$aConfiguration['FPA_FEED_TOKEN'],
            'aImageTypes' => ImageType::getImagesTypes('products'),
            'sCondition' => FacebookProductAd::$aConfiguration['FPA_COND'],
            'aAvailableCondition' => BT_FpaModuleTools::getConditionType(),
        );

        $aCategories = Category::getCategories(intval(FacebookProductAd::$iCurrentLang), false);
        $aAssign['aHomeCat'] = BT_FpaModuleTools::recursiveCategoryTree($aCategories, array(),
            current(current($aCategories)), 1);
        unset($aCategories);

        // get all active languages in order to loop on field form which need to manage translation
        $aAssign['aLangs'] = Language::getLanguages();

        // use case - detect if home category name has been filled
        $aAssign['aHomeCatLanguages'] = $this->_getDefaultTranslations('FPA_HOME_CAT', 'HOME_CAT_NAME');

        foreach ($aAssign['aLangs'] as $aLang) {
            if (!isset($aAssign['aHomeCatLanguages'][$aLang['id_lang']])) {
                $aAssign['aHomeCatLanguages'][$aLang['id_lang']] = $GLOBALS[_FPA_MODULE_NAME . '_HOME_CAT_NAME']['en'];
            }
        }

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_BASICS,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displayFeedSettings() method displays feeds settings
     *
     * @param array $aPost
     * @return array
     */
    private function _displayFeed(array $aPost = null)
    {
        if (FacebookProductAd::$sQueryMode == 'xhr') {
            // clean headers
            @ob_end_clean();
        }

        $aAssign = array(
            'bExportMode' => FacebookProductAd::$aConfiguration['FPA_EXPORT_MODE'],
            'bExportOOS' => FacebookProductAd::$aConfiguration['FPA_EXPORT_OOS'],
            'bExcludeNoEan' => FacebookProductAd::$aConfiguration['FPA_EXC_NO_EAN'],
            'bExcludeNoMref' => FacebookProductAd::$aConfiguration['FPA_EXC_NO_MREF'],
            'iMinPrice' => FacebookProductAd::$aConfiguration['FPA_MIN_PRICE'],
//			'sDefaultCurrency' => BT_FpaModuleTools::getCurrency('sign'),
            'bProductCombos' => FacebookProductAd::$aConfiguration['FPA_P_COMBOS'],
            'iDescType' => FacebookProductAd::$aConfiguration['FPA_P_DESCR_TYPE'],
            'aDescriptionType' => BT_FpaModuleTools::getDescriptionType(),
            'iIncludeStock' => FacebookProductAd::$aConfiguration['FPA_INC_STOCK'],
            'bIncludeTagAdult' => FacebookProductAd::$aConfiguration['FPA_INC_TAG_ADULT'],
            'bIncludeSize' => FacebookProductAd::$aConfiguration['FPA_INC_SIZE'],
            'aAttributeGroups' => AttributeGroup::getAttributesGroups((int)FacebookProductAd::$oContext->cookie->id_lang),
            'aFeatures' => Feature::getFeatures((int)FacebookProductAd::$oContext->cookie->id_lang),
            'aSizeOptions' => FacebookProductAd::$aConfiguration['FPA_SIZE_OPT'],
            'sIncludeColor' => FacebookProductAd::$aConfiguration['FPA_INC_COLOR'],
            'aExcludedProducts' => FacebookProductAd::$aConfiguration['FPA_PROD_EXCL'],
            'bIncludeMaterial' => FacebookProductAd::$aConfiguration['FPA_INC_MATER'],
            'bIncludePattern' => FacebookProductAd::$aConfiguration['FPA_INC_PATT'],
            'bIncludeGender' => FacebookProductAd::$aConfiguration['FPA_INC_GEND'],
            'bIncludeAge' => FacebookProductAd::$aConfiguration['FPA_INC_AGE'],
            'bShippingUse' => FacebookProductAd::$aConfiguration['FPA_SHIPPING_USE'],
            'sGtinPreference' => FacebookProductAd::$aConfiguration['FPA_GTIN_PREF'],
            'aShippingCarriers' => array(),
        );

        // handle product IDs and Names list to format them for the autocomplete feature
        if (!empty($aAssign['aExcludedProducts'])) {
            $sProdIds = '';
            $sProdNames = '';

            foreach ($aAssign['aExcludedProducts'] as $iKey => $sProdId) {
                $aProdIds = explode('¤', $sProdId);
                $oProduct = new Product($aProdIds[0], false, FacebookProductAd::$iCurrentLang);

                // check if we export with combinations
                if (!empty($aProdIds[1])) {
                    $oProduct->name .= BT_FpaModuleTools::getProductCombinationName($aProdIds[1],
                        FacebookProductAd::$iCurrentLang, FacebookProductAd::$iShopId);
                }

                $sProdIds .= $sProdId . '-';
                $sProdNames .= $oProduct->name . '||';

                $aAssign['aProducts'][] = array(
                    'id' => $sProdId,
                    'name' => $oProduct->name,
                    'attrId' => $aProdIds[1],
                    'stringIds' => $sProdId
                );
                unset($oProduct);
            }
            $aAssign['sProductIds'] = $sProdIds;
            $aAssign['sProductNames'] = str_replace('"', '', $sProdNames);
            unset($sProdIds);
            unset($sProdNames);
        }

        $aAssign['aColorOptions']['attribute'] = !empty(FacebookProductAd::$aConfiguration['FPA_COLOR_OPT']['attribute']) ? FacebookProductAd::$aConfiguration['FPA_COLOR_OPT']['attribute'] : array(0);
        $aAssign['aColorOptions']['feature'] = !empty(FacebookProductAd::$aConfiguration['FPA_COLOR_OPT']['feature']) ? FacebookProductAd::$aConfiguration['FPA_COLOR_OPT']['feature'] : array(0);

        // get available categories and manufacturers
        $aCategories = Category::getCategories(intval(FacebookProductAd::$iCurrentLang), false);
        $aBrands = Manufacturer::getManufacturers();

        $aStartCategories = current($aCategories);
        $aFirst = current($aStartCategories);
        $iStart = 1;

        // get registered categories and brands
        $aIndexedCategories = array();
        $aIndexedBrands = array();

        // use case - get categories or brands according to the export mode
        if (FacebookProductAd::$aConfiguration['FPA_EXPORT_MODE'] == 1) {
            $aIndexedBrands = BT_FpaModuleDao::getFpaBrands(FacebookProductAd::$iShopId);
        } else {
            $aIndexedCategories = BT_FpaModuleDao::getFpaCategories(FacebookProductAd::$iShopId);
        }

        // format categories and brands
        $aAssign['aFormatCat'] = BT_FpaModuleTools::recursiveCategoryTree($aCategories, $aIndexedCategories, $aFirst,
            $iStart, null, true);
        $aAssign['aFormatBrands'] = BT_FpaModuleTools::recursiveBrandTree($aBrands, $aIndexedBrands, $aFirst, $iStart);

        $aAssign['iShopCatCount'] = count($aAssign['aFormatCat']);
        $aAssign['iMaxPostVars'] = ini_get('max_input_vars');
//		$aAssign['iMaxPostVars'] = 3;

        unset($aIndexedCategories);
        unset($aIndexedBrands);
        unset($aCategories);
        unset($aBrands);

        // handle tax and shipping fees
        foreach ($GLOBALS[_FPA_MODULE_NAME . '_AVAILABLE_COUNTRIES'] as $sLang => $aCountries) {
            if (BT_FpaModuleDao::checkActiveLanguage($sLang)) {
                foreach ($aCountries as $sCountry => $aLocaleData) {
                    $iCountryId = Country::getByIso($sCountry);
                    if (!empty($iCountryId)) {
                        $iCountryZone = Country::getIdZone($iCountryId);
                        if (!empty($iCountryZone)) {
                            $aCarriers = BT_FpaModuleDao::getAvailableCarriers((int)$iCountryZone);
                            foreach ($aLocaleData['currency'] as $sCurrency) {
                                if (Currency::getIdByIsoCode($sCurrency)) {
                                    if (!empty($aCarriers) && Currency::getIdByIsoCode($sCurrency)) {
                                        if (!array_key_exists($sCountry, $aAssign['aShippingCarriers'])) {
                                            $aAssign['aShippingCarriers'][$sCountry] = array(
                                                'name' => $sCountry,
                                                'carriers' => $aCarriers,
                                                'shippingCarrierId' => (!empty(FacebookProductAd::$aConfiguration['FPA_SHIP_CARRIERS'][$sCountry]) ? FacebookProductAd::$aConfiguration['FPA_SHIP_CARRIERS'][$sCountry] : 0),
                                            );
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_FEED_SETTINGS,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displayFacebook() method displays Facebook settings
     *
     * @param array $aPost
     * @return array
     */
    private function _displayFacebook(array $aPost = null)
    {
        if (FacebookProductAd::$sQueryMode == 'xhr') {
            // clean headers
            @ob_end_clean();
        }

        $aAssign = array(
            'aCountryTaxonomies' => BT_FpaModuleDao::getAvailableTaxonomyCountries($GLOBALS[_FPA_MODULE_NAME . '_AVAILABLE_COUNTRIES']),
            'sFacebookCatListInclude' => BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_ADMIN_PATH . _FPA_TPL_FACEBOOK_CATEGORY_LIST),
            'aTags' => BT_FpaModuleDao::getFpaTags(FacebookProductAd::$iShopId),
            'sUtmCampaign' => FacebookProductAd::$aConfiguration['FPA_UTM_CAMPAIGN'],
            'sUtmSource' => FacebookProductAd::$aConfiguration['FPA_UTM_SOURCE'],
            'sUtmMedium' => FacebookProductAd::$aConfiguration['FPA_UTM_MEDIUM'],
        );

        foreach ($aAssign['aCountryTaxonomies'] as $sIsoCode => &$aTaxonomy) {
            $aTaxonomy['countryList'] = implode(', ', $aTaxonomy['countries']);
            $aTaxonomy['updated'] = BT_FpaModuleDao::checkTaxonomyUpdate($sIsoCode);
        }

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_FACEBOOK_SETTINGS,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayFacebookCategories() method displays Fancybox Google categories
     *
     * @param array $aPost
     * @return array
     */
    private function _displayFacebookCategories(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        $aAssign = array(
            'iLangId' => Tools::getValue('iLangId'),
            'sLangIso' => Tools::getValue('sLangIso'),
            'sCurrentIso' => Language::getIsoById(FacebookProductAd::$iCurrentLang),
        );
        // get shop categories
        $aShopCategories = BT_FpaModuleDao::getShopCategories(FacebookProductAd::$iShopId, $aAssign['iLangId'],
            FacebookProductAd::$aConfiguration['FPA_HOME_CAT_ID']);

        foreach ($aShopCategories as &$aCategory) {
            // get google taxonomy
            $aGoogleCat = BT_FpaModuleDao::getFacebookCategories(FacebookProductAd::$iShopId, $aCategory['id_category'],
                $aAssign['sLangIso']);
            // assign the current taxonomy
            $aCategory['google_category_name'] = is_array($aGoogleCat) && isset($aGoogleCat['txt_taxonomy']) ? $aGoogleCat['txt_taxonomy'] : '';
        }

        $aAssign['aShopCategories'] = $aShopCategories;
        $aAssign['iShopCatCount'] = count($aShopCategories);
        $aAssign['iMaxPostVars'] = ini_get('max_input_vars');
//		$aAssign['iMaxPostVars'] = 3;

        // force xhr mode
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_FACEBOOK_CATEGORY_POPUP,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayAutocomplete() method displays autocomplete facebook categories
     *
     * @param array $aPost
     * @return array
     */
    private function _displayAutocomplete(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        // set
        $sOutput = '';

        $sLangIso = Tools::getValue('sLangIso');
        $sQuery = Tools::getValue('q');

        // explode query string
        $aWords = explode(' ', $sQuery);

        // get matching query
        $aItems = BT_FpaModuleDao::autocompleteSearch($sLangIso, $aWords);

        if (!empty($aItems)
            && is_array($aItems)
        ) {
            foreach ($aItems AS $aItem) {
                $sOutput .= trim($aItem['value']) . "\n";
            }
        }
        echo $sOutput;
        exit(0);
    }

    /**
     * _displayCustomLabel() method displays custom labels
     *
     * @param array $aPost
     * @return array
     */
    private function _displayCustomLabel(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        $aAssign = array();

        // get available categories and manufacturers
        $aCategories = Category::getCategories(intval(FacebookProductAd::$iCurrentLang), false);
        $aBrands = Manufacturer::getManufacturers();
        $aSuppliers = Supplier::getSuppliers();

        $aStartCategories = current($aCategories);
        $aFirst = current($aStartCategories);
        $iStart = 1;

        // get registered categories and brands and suppliers
        $aIndexedCategories = array();
        $aIndexedBrands = array();
        $aIndexedSuppliers = array();

        // use case - get categories or brands or suppliers according to the id tag
        $iTagId = Tools::getValue('iTagId');
        $aTag = array();
        if (!empty($iTagId)) {
            $aTag = BT_FpaModuleDao::getFpaTags(FacebookProductAd::$iShopId, $iTagId);
            $aIndexedCategories = BT_FpaModuleDao::getFpaTags(null, $iTagId, 'cats', 'category');
            $aIndexedBrands = BT_FpaModuleDao::getFpaTags(null, $iTagId, 'brands', 'brand');
            $aIndexedSuppliers = BT_FpaModuleDao::getFpaTags(null, $iTagId, 'suppliers', 'supplier');
        }

        // format categories and brands and suppliers
        $aAssign['aTag'] = (count($aTag) == 1 && isset($aTag[0])) ? $aTag[0] : $aTag;
        $aAssign['aFormatCat'] = BT_FpaModuleTools::recursiveCategoryTree($aCategories, $aIndexedCategories, $aFirst,
            $iStart);
        $aAssign['aFormatBrands'] = BT_FpaModuleTools::recursiveBrandTree($aBrands, $aIndexedBrands, $aFirst, $iStart);
        $aAssign['aFormatSuppliers'] = BT_FpaModuleTools::recursiveSupplierTree($aSuppliers, $aIndexedSuppliers,
            $aFirst, $iStart);
        $aAssign['iShopCatCount'] = count($aAssign['aFormatCat']);
        $aAssign['iMaxPostVars'] = ini_get('max_input_vars');
//		$aAssign['iMaxPostVars'] = 3;

        unset($aTag);
        unset($aIndexedCategories);
        unset($aIndexedBrands);
        unset($aIndexedSuppliers);
        unset($aCategories);
        unset($aBrands);
        unset($aSuppliers);

        // force xhr mode
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_FACEBOOK_CUSTOM_LABEL,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displayFeedList() method displays feed list
     *
     * @param array $aPost
     * @return array
     */
    private function _displayFeedList(array $aPost = null)
    {
        if (FacebookProductAd::$sQueryMode == 'xhr') {
            // clean headers
            @ob_end_clean();
        }

        $aAssign = array(
            'iShopId' => FacebookProductAd::$iShopId,
            'sFpaLink' => FacebookProductAd::$aConfiguration['FPA_LINK'],
            'bReporting' => FacebookProductAd::$aConfiguration['FPA_REPORTING'],
            'iTotalProductToExport' => BT_FpaModuleDao::getProductIds(FacebookProductAd::$iShopId,
                (int)FacebookProductAd::$aConfiguration['FPA_EXPORT_MODE'], true),
            'iTotalProduct' => BT_FpaModuleDao::countProducts(FacebookProductAd::$iShopId,
                (int)FacebookProductAd::$aConfiguration['FPA_P_COMBOS']),
            'bCheckOutputFile' => BT_FpaModuleTools::checkOutputFile(),
            'aFeedFileList' => array(),
            'aFlyFileList' => array(),
        );
        $aAssign['aCronLang'] = (!empty(FacebookProductAd::$aConfiguration['FPA_CHECK_EXPORT']) ? FacebookProductAd::$aConfiguration['FPA_CHECK_EXPORT'] : array());

        // handle data feed file name
        if (!empty($aAssign['sFpaLink'])) {
            if (!empty(FacebookProductAd::$aAvailableLangCurrencyCountry)) {
                foreach (FacebookProductAd::$aAvailableLangCurrencyCountry as $aData) {
                    // check if file exist
                    $sFileSuffix = BT_FpaModuleTools::buildFileSuffix($aData['langIso'], $aData['countryIso']);
                    $sFilePath = FacebookProductAd::$sFilePrefix . '.' . $sFileSuffix . '.xml';

                    if (is_file(_FPA_SHOP_PATH_ROOT . $sFilePath)) {
                        $aAssign['aFeedFileList'][] = array(
                            'link' => $aAssign['sFpaLink'] . __PS_BASE_URI__ . $sFilePath,
                            'filename' => $sFilePath,
                            'filemtime' => date("d-m-Y H:i:s", filemtime(_FPA_SHOP_PATH_ROOT . $sFilePath)),
                            'checked' => (in_array($aData['langIso'] . '_' . $aData['countryIso'] . '_' . $aData['currencyIso'],
                                $aAssign['aCronLang']) ? true : false),
                            'country' => $aData['countryIso'],
                            'lang' => $aData['langIso'],
                            'langId' => $aData['langId'],
                            'sCurrencyIso' => $aData['currencyIso'],
                        );
                    }

                    // handle cron URLs for each country on product and stock data feed
                    $sLink = $aAssign['sFpaLink'] . _FPA_MODULE_URL . 'cron.php?id_shop=' . FacebookProductAd::$iShopId . '&id_lang=' . (int)$aData['langId'] . '&country=' . $aData['countryIso'] . '&currency_iso=' . $aData['currencyIso'];
                    $sLink .= (!empty(FacebookProductAd::$aConfiguration['FPA_FEED_PROTECTION']) ? '&token=' . FacebookProductAd::$aConfiguration['FPA_FEED_TOKEN'] : '');

                    $aAssign['aCronList'][] = array(
                        'link' => $sLink,
                        'lang' => $aData['langIso'],
                        'country' => $aData['countryIso'],
                        'country' => $aData['countryIso'],
                        'sCurrencyIsoCron' => $aData['currencyIso'],
                    );
                }
            }

            // handle on-the-fly output
            if (!empty($aAssign['bCheckOutputFile'])) {
                if (!empty(FacebookProductAd::$aAvailableLangCurrencyCountry)) {
                    foreach (FacebookProductAd::$aAvailableLangCurrencyCountry as $aData) {
                        $sLink = $aAssign['sFpaLink'] . __PS_BASE_URI__ . 'facebookproductad.xml.php?id_shop=' . FacebookProductAd::$iShopId . '&id_lang=' . (int)$aData['langId'] . '&country=' . $aData['countryIso'] . '&currency_iso=' . $aData['currencyIso'];
                        $sLink .= (!empty(FacebookProductAd::$aConfiguration['FPA_FEED_PROTECTION']) ? '&token=' . FacebookProductAd::$aConfiguration['FPA_FEED_TOKEN'] : '');

                        $aAssign['aFlyFileList'][] = array(
                            'link' => $sLink,
                            'country' => $aData['countryIso'],
                            'iso_code' => $aData['langIso'],
                            'sCurrencyIso' => $aData['currencyIso'],
                        );
                    }
                }
            }
            // handle the cron URL
            $aAssign['sCronUrl'] = $aAssign['sFpaLink'] . _FPA_MODULE_URL . 'cron.php?id_shop=' . FacebookProductAd::$iShopId;

            // check if the feed protection is activated
            if (!empty(FacebookProductAd::$aConfiguration['FPA_FEED_PROTECTION'])
                && !empty(FacebookProductAd::$aConfiguration['FPA_FEED_TOKEN'])
            ) {
                $aAssign['sCronUrl'] .= '&token=' . FacebookProductAd::$aConfiguration['FPA_FEED_TOKEN'];
            }
        }

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_FEED_LIST,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayReporting() method displays reporting settings
     *
     * @param array $aPost
     * @return array
     */
    private function _displayReporting(array $aPost = null)
    {
        $aAssign = array(
            'aLangCurrencies' => BT_FpaModuleTools::getGeneratedReport(),
            'bReporting' => FacebookProductAd::$aConfiguration['FPA_REPORTING'],
        );

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_REPORTING,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayAdvice() method displays advice form
     *
     * @param array $aPost
     * @return array
     */
    private function _displayAdvice(array $aPost = null)
    {
        $aAssign = array();

        // clean headers
        @ob_end_clean();

        $aAssign['sFbImageUrl'] = _FPA_PATH_IMG_ADVICE;

        // force xhr mode activated
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_ADVICE,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displayAdvice() method displays advice form
     *
     * @param array $aPost
     * @return array
     */
    private function _displayNewCustomFeed(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        $aAssign = array();

        $aAssign['aShopLang'] = Language::getLanguages(false, (int)FacebookProductAd::$iShopId);
        $aAssign['aCountry'] = Country::getCountries(FacebookProductAd::$iCurrentLang, true, false, false);
        $aAssign['aCurrency'] = Currency::getCurrenciesByIdShop((int)FacebookProductAd::$iShopId);

        // force xhr mode activated
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_NEW_CUSTOM_FEED,
            'assign' => $aAssign,
        )
        );
    }

    /**
     * _displayPixel() method displays pixel config
     *
     * @param array $aPost
     * @return array
     */
    private function _displayPixel(array $aPost = null)
    {
        $aAssign = array();

        $aAssign = array(
            'sPixel' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_PIXEL'],
            'bUseTax' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_TAX'],
            'bUseShipping' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_SHIPPING'],
            'bUseWrapping' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_WRAPPING'],
            'bDisplayFunnel' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'],
            'bDisplayCustomDomCode' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_CUSTOM_DOM_ELEM'],
            'sDomProductAddToCart' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_JS_CART_SELECTOR_PROD'],
            'sDomProductAddToWish' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_JS_WISH_SELECTOR_PROD'],
            'sDomListAddToCart' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_JS_CART_SELECTOR_CAT'],
            'sDomListAddToWish' => FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_JS_WISH_SELECTOR_CAT'],
        );

        return
            array(
                'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_PIXEL_CONFIG,
                'assign' => $aAssign,
            );
    }


    /**
     * _displayReporting() method displays reporting fancybox
     *
     * @param array $aPost
     * @return array
     */
    private function _displayReportingBox(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        $aAssign = array();
        $aTmp = array();

        // get the current lang ID
        $sLang = Tools::getValue('lang');
        $iProductCount = Tools::getValue('count');
        $sCurrencyIso = Tools::getValue('sCurrencyIso');

        // Transform sLang to get the good country / lang / currency association
        $sLang = $sLang . '_' . $sCurrencyIso;

        if (!empty($sLang)
            && strstr($sLang, '_')
        ) {
            list($sLangIso, $sCountryIso, $sCurrencyIso) = explode('_', $sLang);

            // get the identify lang ID
            $iLangId = BT_FpaModuleTools::getLangId($sLangIso);

            // include
            require_once(_FPA_PATH_LIB . 'module-reporting_class.php');

            // set reporting object
            BT_FpaReporting::create(true)->setFileName(_FPA_REPORTING_DIR . 'reporting-' . $sLangIso . '-' . Tools::strtolower($sCountryIso) . '-' . $sCurrencyIso . '.txt');

            // get the current report
            $aReporting = BT_FpaReporting::create()->get();


            if (!empty($aReporting)) {

                static $aTmpProduct = array();

                // get the language name
                $aLanguage = Language::getLanguage($iLangId);
                $sLanguageName = $aLanguage['name'];
                // get the country name
                $sCountryName = Country::getNameById($iLangId, Country::getByIso(Tools::strtolower($sCountryIso)));
                unset($aLanguage);

                // check if exists counter key in the reporting
                if (!empty($aReporting['counter'][0])) {
                    if (empty($iProductCount)) {
                        $iProductCount = $aReporting['counter'][0]['products'];
                    }
                    unset($aReporting['counter']);
                }

                // load facebook tags
                $aGoogleTags = BT_FpaModuleTools::loadFacebookTags();

                foreach ($aReporting as $sTagName => &$aGTag) {
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['count'] = count($aGTag);
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['label'] = (isset($aGoogleTags[$sTagName]) ? $aGoogleTags[$sTagName]['label'] : '');
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['msg'] = (isset($aGoogleTags[$sTagName]) ? $aGoogleTags[$sTagName]['msg'] : '');
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['faq_id'] = (isset($aGoogleTags[$sTagName]) ? (int)($aGoogleTags[$sTagName]['faq_id']) : 0);
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['anchor'] = (isset($aGoogleTags[$sTagName]) ? $aGoogleTags[$sTagName]['anchor'] : '');
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['mandatory'] = (isset($aGoogleTags[$sTagName]) ? $aGoogleTags[$sTagName]['mandatory'] : false);

                    // detect the old format system and the new format
                    if (isset($aGTag[0]['productId'])
                        && strstr($aGTag[0]['productId'], '_')
                    ) {
                        foreach ($aGTag as $iKey => &$aProdValue) {
                            list($iProdId, $iAttributeId) = explode('_', $aProdValue['productId']);
                            if (empty($aTmpProduct[$aProdValue['productId']])) {
                                // get the product obj
                                $oProduct = new Product((int)$iProdId, true, (int)$iLangId);
                                $oCategory = new Category((int)($oProduct->id_category_default), (int)$iLangId);

                                // set the product URL
                                $aProdValue['productUrl'] = BT_FpaModuleTools::getProductLink($oProduct, $iLangId,
                                    $oCategory->link_rewrite);
                                // set the product name
                                $aProdValue['productName'] = $oProduct->name;

                                // if combination
                                if (!empty($iAttributeId)) {
                                    if (!empty(FacebookProductAd::$bCompare15)) {
                                        $aProdValue['productUrl'] = BT_FpaModuleDao::getProductComboLink($aProdValue['productUrl'],
                                            $iAttributeId, $iLangId, FacebookProductAd::$iShopId);
                                    }

                                    // get the combination attributes to format the product name
                                    $aCombinationAttr = BT_FpaModuleDao::getProductComboAttributes($iAttributeId,
                                        $iLangId, FacebookProductAd::$iShopId);

                                    if (!empty($aCombinationAttr)) {
                                        $sExtraName = '';
                                        foreach ($aCombinationAttr as $c) {
                                            $sExtraName .= ' ' . Tools::stripslashes($c['name']);
                                        }
                                        $aProdValue['productName'] .= $sExtraName;
                                    }
                                }
                                unset($oProduct);
                                unset($oCategory);

                                $aTmpProduct[$aProdValue['productId']] = array(
                                    'productId' => $iProdId,
                                    'productAttrId' => $iAttributeId,
                                    'productUrl' => $aProdValue['productUrl'],
                                    'productName' => $aProdValue['productName'],
                                );
                            }
                            $aProdValue = $aTmpProduct[$aProdValue['productId']];
                        }
                    }
                    $aTmp[$aGoogleTags[$sTagName]['type']][$sTagName]['data'] = $aGTag;
                }
                $aTmpProduct = array();
                ksort($aTmp);
                unset($aReporting);
                unset($aGoogleTags);

                $aAssign = array(
                    'sLangName' => $sLanguageName,
                    'sCountryName' => $sCountryName,
                    'aReport' => $aTmp,
                    'iProductCount' => (int)$iProductCount,
                    'sPath' => _FPA_PATH_ROOT,
                    'sFaqURL' => _FPA_BT_FAQ_MAIN_URL . '/',
                    'sFaqLang' => $sLangIso,
                    'sToken' => Tools::getAdminTokenLite('AdminProducts'),
                    'sProductLinkController' => $_SERVER['SCRIPT_URI'] . '?controller=AdminProducts',
                    'sProductAction' => '&updateproduct',
                );
            } else {
                $aAssign['aErrors'][] = array(
                    'msg' => FacebookProductAd::$oModule->l('There isn\'t any report for this language and country',
                            'admin-display_class.php') . ' : ' . $sLangIso . ' - ' . $sCountryIso,
                    'code' => 190
                );
            }
        } else {
            $aAssign['aErrors'][] = array(
                'msg' => FacebookProductAd::$oModule->l('Language ISO and country ISO aren\'t well formatted',
                    'admin-display_class.php'),
                'code' => 191
            );
        }

        // force xhr mode
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_REPORTING_BOX,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displayAdvancedTagCategory() method displays advanced tag category settings
     *
     * @param array $aPost
     * @return array
     */
    private function _displayAdvancedTagCategory(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        $aShopCategories = BT_FpaModuleDao::getShopCategories(FacebookProductAd::$iShopId,
            FacebookProductAd::$iCurrentLang, FacebookProductAd::$aConfiguration['FPA_HOME_CAT_ID']);

        foreach ($aShopCategories as &$aCat) {
            // get feature by category Id
            $aFeatures = BT_FpaModuleDao::getFeaturesByCategory($aCat['id_category'], FacebookProductAd::$iShopId);

            if (!empty($aFeatures)) {
                $aCat['material'] = $aFeatures['material'];
                $aCat['pattern'] = $aFeatures['pattern'];
                $aCat['agegroup'] = $aFeatures['agegroup'];
                $aCat['gender'] = $aFeatures['gender'];
                $aCat['adult'] = $aFeatures['adult'];
            } else {
                $aCat['material'] = '';
                $aCat['pattern'] = '';
                $aCat['agegroup'] = '';
                $aCat['gender'] = '';
                $aCat['adult'] = '';
            }
        }

        $aAssign = array(
            'bCompare149' => FacebookProductAd::$bCompare149,
            'aShopCategories' => $aShopCategories,
            'aFeatures' => Feature::getFeatures(FacebookProductAd::$iCurrentLang),
            'sUseTag' => Tools::getValue('sUseTag'),
            'bMaterial' => FacebookProductAd::$aConfiguration['FPA_INC_MATER'],
            'bPattern' => FacebookProductAd::$aConfiguration['FPA_INC_PATT'],
            'bGender' => FacebookProductAd::$aConfiguration['FPA_INC_GEND'],
            'bAgeGroup' => FacebookProductAd::$aConfiguration['FPA_INC_AGE'],
            'bTagAdult' => FacebookProductAd::$aConfiguration['FPA_INC_TAG_ADULT'],
        );
        unset($aShopCategories);

        // force xhr mode
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_ADVANCED_TAG_CATEGORY,
            'assign' => $aAssign,
        )
        );
    }


    /**
     * _displaySearchProduct() method displays search product name for autocomplete
     *
     * @param array $aPost
     * @return array
     */
    private function _displaySearchProduct(array $aPost = null)
    {
        // clean headers
        @ob_end_clean();

        // set
        $sOutput = '';

        // get the query to search
        $sSearch = Tools::getValue('q');

        if (!empty($sSearch)) {
            $aMatchingProducts = BT_FpaModuleDao::searchProducts($sSearch,
                (int)FacebookProductAd::$aConfiguration['FPA_P_COMBOS']);

            if (!empty($aMatchingProducts)) {
                foreach ($aMatchingProducts as $aProduct) {
                    // check if we export with combinations
                    if (!empty($aProduct['id_product_attribute'])) {
                        $aProduct['name'] .= BT_FpaModuleTools::getProductCombinationName($aProduct['id_product_attribute'],
                            FacebookProductAd::$iCurrentLang, FacebookProductAd::$iShopId);
                    }
                    $sOutput .= trim($aProduct['name']) . '|' . (int)$aProduct['id_product'] . '|' . (!empty($aProduct['id_product_attribute']) ? $aProduct['id_product_attribute'] : '0') . "\n";
                }
            }
        }

        // force xhr mode
        FacebookProductAd::$sQueryMode = 'xhr';

        return (
        array(
            'tpl' => _FPA_TPL_ADMIN_PATH . _FPA_TPL_PROD_SEARCH,
            'assign' => array('json' => $sOutput),
        )
        );
    }

    /**
     * _getDefaultTranslations() method returns the matching requested translations
     *
     * @param string $sSerializedVar
     * @param string $sGlobalVar
     * @return array
     */
    private function _getDefaultTranslations($sSerializedVar, $sGlobalVar)
    {
        $aTranslations = array();

        if (!empty(FacebookProductAd::$aConfiguration[strtoupper($sSerializedVar)])) {
            $aTranslations = is_string(FacebookProductAd::$aConfiguration[strtoupper($sSerializedVar)]) ? unserialize(FacebookProductAd::$aConfiguration[strtoupper($sSerializedVar)]) : FacebookProductAd::$aConfiguration[strtoupper($sSerializedVar)];
        } else {
            foreach ($GLOBALS[_FPA_MODULE_NAME . '_' . strtoupper($sGlobalVar)] as $sIsoCode => $sTranslation) {
                $iLangId = BT_FpaModuleTools::getLangId($sIsoCode);

                if ($iLangId) {
                    // get Id by iso
                    $aTranslations[$iLangId] = $sTranslation;
                }
            }
        }

        return $aTranslations;
    }


    /**
     * _getFlagIds() method returns ids used for PrestaShop flags displaying
     *
     * @return string
     */
    private function _getFlagIds()
    {
        // set
        $sFlagIds = '';

        if (!empty($this->aFlagIds)) {
            // loop on each ids
            foreach ($this->aFlagIds as $sId) {
                $sFlagIds .= $sId . '¤';
            }

            $sFlagIds = substr($sFlagIds, 0, (strlen($sFlagIds) - 2));
        }

        return $sFlagIds;
    }

    /**
     * _setFlagIds() method sets ids used for PrestaShop flags displaying
     */
    private function _setFlagIds()
    {
        // set
        $sFlagIds = '';

        $this->aFlagIds = array(
            strtolower(_FPA_MODULE_NAME) . 'Title',
        );
    }

    /**
     * create() method set singleton
     *
     * @return obj
     */
    public static function create()
    {
        static $oDisplay;

        if (null === $oDisplay) {
            $oDisplay = new BT_AdminDisplay();
        }
        return $oDisplay;
    }
}