<?php
/**
 * hook-action_class.php file defines controller which manage hooks sequentially
 */

class BT_FpaHookAction extends BT_FpaHookBase
{
    /**
     * @var string $sHookAction : define the hook type
     */
    protected $sHookAction = null;

    public function __construct($sHookAction)
    {
        // set hook action
        $this->sHookAction = $sHookAction;
    }

    /**
     * Magic Method __destruct
     */
    public function __destruct()
    {

    }

    /**
     * run() method execute hook
     *
     * @param array $aParams
     * @return array
     */
    public function run(array $aParams = null)
    {
        //to handle DAO
        require_once(_FPA_PATH_LIB . 'module-dao_class.php');

        // set variables
        $aDisplayHook = array();

        switch ($this->sHookAction) {
            case 'validateOrder' :
                // use case - display nothing only process storage in order to send an email
                $aDisplayHook = call_user_func_array(array($this, 'validateOrder'), array($aParams));
                break;
            default :
                break;
        }

        return $aDisplayHook;
    }


    /**
     * validateOrder() method add order in Prestashop
     *
     * @param array $aParams
     * @return bool
     */
    private function validateOrder(array $aParams = null)
    {
        $bResult = false;

        if (!empty($aParams['cart']->id)
            && !empty($aParams['order']->id)
        ) {
            // detect if the module has already sent the code and create and update the order in the table
            if (!BT_FpaModuleDao::checkOrder($aParams['cart']->id, 'cart', true)) {
                $bResult = BT_FpaModuleDao::addOrder($aParams['cart']->id, 0, $aParams['order']->id, 0, 'confirmation');
            } // the cart has been registered and not yet the order id because the code is placed before in the payment
            else {
                $bResult = BT_FpaModuleDao::updateOrder((int)$aParams['order']->id, null, $aParams['cart']->id, 'cart',
                    0);
            }
        }
        return $bResult;
    }
}