<?php
/**
 * hook-ctrl_class.php file defines controller which manage type of hook object derived of abstract type as factory pattern
 */

class BT_FpaHookCtrl
{
    /**
     * @var obj $_oHook : defines hook object to display
     */
    private $oHook = null;

    /**
     * Magic Method __construct instantiate the matching hook class
     *
     * @param string $sType : type of interface to execute
     * @param string $sAction
     */
    public function __construct($sType, $sAction)
    {
        // include interface of hook executing
        require_once(_FPA_PATH_LIB_HOOK . 'hook-base_class.php');

        // check if file exists
        if (!file_exists(_FPA_PATH_LIB_HOOK . 'hook-' . $sType . '_class.php')) {
            throw new Exception("no valid file", 100);
        } else {
            // include matched hook object
            require_once(_FPA_PATH_LIB_HOOK . 'hook-' . $sType . '_class.php');

            if (!class_exists('BT_FpaHook' . ucfirst($sType))
                && !method_exists('BT_FpaHook' . ucfirst($sType), 'run')
            ) {
                throw new Exception("no valid class and method", 101);
            } else {
                // set class name
                $sClassName = 'BT_FpaHook' . ucfirst($sType);

                // instantiate
                $this->oHook = new $sClassName($sAction);
            }
        }
    }

    /**
     * run() method execute hook
     *
     * @category hook collection
     * @param array $aParams
     * @return array $aDisplay : empty => false / not empty => true
     */
    public function run(array $aParams = null)
    {
        return (
        $this->oHook->run($aParams)
        );
    }
}