<?php
/**
 * hook-display_class.php file defines controller which manage hooks sequentially
 */

class BT_FpaHookDisplay extends BT_FpaHookBase
{
    /**
     * @var bool $bAlreadyExecute : define if one hook is already executed
     */
    protected static $bAlreadyExecute = false;

    /**
     * Magic Method __construct assigns few information about hook
     */
    public function __construct($sHookAction)
    {
        // set hook action
        $this->sHook = $sHookAction;
    }

    /**
     * Magic Method __destruct
     */
    public function __destruct()
    {

    }

    /**
     * run() method execute hook
     *
     * @param array $aParams
     * @return array
     */
    public function run(array $aParams = null)
    {
        require_once(_FPA_PATH_LIB . 'module-dao_class.php');

        // set variables
        $aDisplayHook = array();

        switch ($this->sHook) {
            case 'header' :
            case 'orderConfirmation' :
            case 'footer':
            case 'paymentByBinaries':
                // use case - display in header
                $aDisplayHook = call_user_func_array(array($this, 'display' . ucfirst($this->sHook)), array($aParams));
                break;
            default :
                break;
        }

        return $aDisplayHook;
    }

    /**
     * displayHeader() method display header
     *
     * @param array $aParams
     * @return array
     */
    private function displayHeader(array $aParams = null)
    {
        $aAssign = array();

        // include base class of dynamic tags
        require_once(_FPA_PATH_LIB_PIXEL_TAGS . 'base-pixel-tags_class.php');
        require_once(_FPA_PATH_LIB . 'module-tools_class.php');

        $aDynTags = array(
            'iProductId' => Tools::getvalue('id_product'),
            'iCategoryId' => Tools::getvalue('id_category'),
            'iManufacturerId' => Tools::getvalue('id_manufacturer'),
            'iCartId' => Context::getContext()->cart->id,
            'iOrderId' => Tools::getvalue('id_order'),
            'js' => array(
                'cartSelectorProd' => FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_PROD'],
                'wishSelectorProd' => FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_PROD'],
                'cartSelectorCat' => FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_CAT'],
                'wishSelectorCat' => FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_CAT'],
            )
        );

        // use case - check if we've configured the module to position the code into the last step of the funnel
        if (!empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])
            && Tools::getValue('controller') == 'order'
            && Tools::getValue('step') == 3
        ) {
            //simulate the page  as purchase
            $sPageType = 'purchase';

            //check if the order is not already registered in the database
            if (!BT_FpaModuleDao::checkOrder(Context::getContext()->cart->id, 'cart', true)) {
                // add the order
                BT_FpaModuleDao::addOrder(Context::getContext()->cart->id, 0, null, 0, 'payment');
            }
        } else {
            //detect the page
            $sPageType = (!empty($aParams['sPageType']) ? $aParams['sPageType'] : BT_FpaModuleTools::detectCurrentPage());
        }

        $aAssign = BT_FpaModuleTools::buildDynDisplayTag($aDynTags, $sPageType);

        return (
            array('tpl' => _FPA_TPL_HOOK_PATH . _FPA_TPL_HEADER, 'assign' => $aAssign)
        );
    }


    /**
     * displayOrderConfirmation() method display order confirmation page
     *
     * @param array $aParams
     * @return array
     */
    private function displayOrderConfirmation(array $aParams = null)
    {
        // detect if we've already sent the code in the funnel's last step
        if (!empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])) {
            BT_FpaModuleDao::updateOrder(null, null,
                (isset($aParams['objOrder']->id_cart) ? $aParams['objOrder']->id_cart : Context::getContext()->cart->id),
                'cart', 1);
        }

        return (
        array('tpl' => _FPA_TPL_HOOK_PATH . _FPA_TPL_EMPTY, 'assign' => $aAssign = array())
        );
    }

    /**
     * _displayFooter() method
     *
     * @return array
     */
    private function displayFooter()
    {
        return (
            array('tpl' => _FPA_TPL_HOOK_PATH . _FPA_TPL_FOOTER, 'assign' => array())
        );
    }


    /**
     * displayPaymentByBinaries() method display header
     *
     * @param array $aParams
     * @return array
     */
    private function displayPaymentByBinaries(array $aParams = null)
    {
        if (!empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])) {
            // include base class of dynamic tags
            require_once(_FPA_PATH_LIB_PIXEL_TAGS . 'base-pixel-tags_class.php');

            $aDynTags = array(
                'iProductId' => Tools::getvalue('id_product'),
                'iCategoryId' => Tools::getvalue('id_category'),
                'iManufacturerId' => Tools::getvalue('id_manufacturer'),
                'iCartId' => Context::getContext()->cart->id,
                'iOrderId' => Tools::getvalue('id_order'),
                'js' => array(
                    'cartSelectorProd' => FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_PROD'],
                    'wishSelectorProd' => FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_PROD'],
                    'cartSelectorCat' => FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_CAT'],
                    'wishSelectorCat' => FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_CAT'],
                )
            );

            $aAssign['sPixel'] = FacebookProductAd::$aConfiguration['FPA_PIXEL'];

            $sPageType = 'purchase';

            $aAssign = BT_FpaModuleTools::buildDynDisplayTag($aDynTags, $sPageType);

            return (
            array('tpl' => _FPA_TPL_HOOK_PATH . _FPA_TPL_FOOTER, 'assign' => $aAssign)
            );
        } else {

            $aAssign['sFacebookJsInclude'] = BT_FpaModuleTools::getTemplatePath(_FPA_PATH_TPL_NAME . _FPA_TPL_HOOK_PATH . _FPA_TPL_PIXEL_JS);

            return (
            array('tpl' => _FPA_TPL_HOOK_PATH . _FPA_TPL_FOOTER, 'assign' => $aAssign)
            );
        }
    }

}