<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Hook;

use FacebookProductAd\Hook\hookDisplay;
use FacebookProductAd\Hook\hookAction;

class hookController
{
    /**
     * @var obj $_oHook : defines hook object to display
     */
    private $oHook = null;

    /**
     * Magic Method __construct instantiate the matching hook class
     *
     * @param string $sType : type of interface to execute
     * @throws
     * @param string $sAction
     */
    public function __construct($sType, $sAction)
    {
        if ($sType == 'display') {
            $this->oHook = new hookDisplay($sAction);
        } else if ($sType == 'action') {
            $this->oHook = new hookAction($sAction);
        } else {
            return '';
        }
    }

    /**
     * method execute hook
     *
     * @category hook collection
     * @param array $aParams
     * @return array $aDisplay : empty => false / not empty => true
     */
    public function run(array $aParams = null)
    {
        return ($this->oHook->run($aParams));
    }
}
