<?php

/**
 * declare Dynamic tags Exception class
 */
class BT_DynPixelException extends Exception
{
}

abstract class BT_BasePixelTags
{
    /**
     * @var string $sName : stock tag type name
     */
    public static $sName = '';

    /**
     * @var string $sQuote : character used for tagging values
     */
    public static $sQuote = '\'';

    /**
     * @var string $sOpenTag : character used for open complex tag
     */
    public static $sOpenTag = '[';

    /**
     * @var string $sOpenTag : character used for open complex tag
     */
    public static $sCloseTag = ']';

    /**
     * @var bool $aPageInfo : current page information
     */
    public $aPageInfo = array();

    /**
     * @var bool $bValid : current object valid or not
     */
    public $bValid = false;

    /**
     * @var bool $bValid : current object valid or not
     */
    public $sTrakingType = '';

    /**
     * @var string $sContent_type : type of content ( see $GLOBALS[_FPA_MODULE_NAME . '_AUDIENCE_TYPE'] to have allow values )
     */
    public $sContent_type = null;

    /**
     * @var string $sContent_ids : the content ids for the tag
     */
    public $sContent_ids = null;

    /**
     * @var string $sContent_name : content the name
     */
    public $sContent_name = null;

    /**
     * @var string $sContent_Category : content cotent category path
     */
    public $sContent_Category = null;

    /**
     * @var string $fValue : the float value ex price
     */
    public $fValue = null;

    /**
     * @var string $sCurrency : the currency
     */
    public $sCurrency = null;

    /**
     * @var string $sQuerySearch : the search result
     */
    public $sQuerySearch = null;

    /**
     * @var array $aJsParams : get the JS params for some pages need to include JS code
     */
    public $aJsParams = false;

    /**
     * @var string $sJsCode : the JS code
     */
    public $sJsCode = '';

    /**
     * @var array $aProducts : current products
     */
    public $aProducts = array();

    /**
     * get params keys
     *
     * @param array $aParams
     */
    abstract public function __construct(array $aParams);

    /**
     * setContentType() method set content type
     */
    abstract public function setTrackingType();

    /**
     * setContentType() method set content type
     */
    abstract public function setContentType();

    /**
     * setContentIds() method set ContentIds
     */
    abstract public function setContentIds();

    /**
     * setContentName() method set content name
     */
    abstract public function setContentName();

    /**
     * setCategory() method set Content Categoru
     */
    abstract public function setContentCategory();

    /**
     * setValue() method set value like a price
     */
    abstract public function setValue();

    /**
     * setContentIds() method set currency
     */
    abstract public function setCurrency();

    /**
     * setQuerySearch() method set query search
     */
    abstract public function setQuerySearch();

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    abstract public function setJsCode();


    /**
     * set() method set values
     *
     * @param string $sTagsType
     * @param array $aParams
     * @return obj tags type abstract type
     */
    public function set()
    {
        // set tracking type
        $this->setTrackingType();

        // set content type
        $this->setContentType();

        // set Content ids
        $this->setContentIds();

        // set Content name
        $this->setContentName();

        //set the content category
        $this->setContentCategory();

        // set price value
        $this->setValue();

        // set the currency
        $this->setCurrency();

        // set the query search
        $this->setQuerySearch();

        // set the JS code
        $this->setJsCode();
    }


    /**
     * display() method display properties
     *
     * @return array of properties + labels
     */
    public function display()
    {
        $aProperties = array();

        if (!empty($this->sTrakingType)) {
            $aProperties['tracking_type'] = array('label' => 'tracking_type', 'value' => $this->sTrakingType);
        }

        if (!empty($this->sContent_type)) {
            $aProperties['content_type'] = array('label' => 'content_type', 'value' => $this->sContent_type);
        }

        if (!empty($this->sContent_ids)) {
            $aProperties['content_ids'] = array('label' => 'content_ids', 'value' => $this->sContent_ids);
        }

        if (!empty($this->fValue)) {
            $aProperties['value'] = array('label' => 'value', 'value' => $this->fValue);
        }

        if (!empty($this->sQuerySearch)) {
            $aProperties['search_string'] = array('label' => 'search_string', 'value' => $this->sQuerySearch);
        }

        if (!empty($this->sCurrency)) {
            $aProperties['currency'] = array('label' => 'currency', 'value' => $this->sCurrency);
        }

        if (!empty($this->sContent_name)) {
            $aProperties['content_name'] = array('label' => 'content_name', 'value' => $this->sContent_name);
        }

        if (!empty($this->sContent_Category)) {
            $aProperties['content_category'] = array(
                'label' => 'content_category',
                'value' => $this->sContent_Category
            );
        }

        if (!empty($this->sJsCode)) {
            $aProperties['js_code'] = array('label' => 'js_code', 'value' => $this->sJsCode);
        }

        return $aProperties;
    }

    /**
     * get() method instantiate matched connector object
     *
     * @param string $sEventType
     * @param array $aParams
     * @return obj tags type abstract type
     */
    public static function get($sTagsType, array $aParams = null)
    {
        // if valid tag class
        if (in_array($sTagsType, array_keys($GLOBALS[_FPA_MODULE_NAME . '_TAGS_TYPE']))) {
            // include
            require_once('pixel-' . $sTagsType . '-tags_class.php');

            // set class name
            $sClassName = 'BT_Pixel' . ucfirst($sTagsType) . 'Tags';

            // get tags type name
            self::$sName = $sTagsType;

            return (new $sClassName($aParams));
        } else {
            throw new BT_DynPixelException(FacebookProductAd::$oModule->l('Internal server error => invalid dynamic tags type',
                'base-dynamic-tags_class'), 510);
        }
    }
}

