<?php
/**
 * pixel-cart-tags_class.php file defines methods to handle properties related to the cart
 */

class BT_PixelCartTags extends BT_BasePixelTags
{

    /**
     * @var bool $iCartId : current object is a cart
     */
    public $iCartId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        //get the cart id
        $this->iCartId = $aParams['iCartId'];

        $this->oCart = New Cart((int)$this->iCartId);

        if (!empty($this->oCart)) {
            $this->aProducts = $this->oCart->getProducts();

            if (!empty($this->aProducts)) {
                $this->bValid = true;

                //get the context information
                $this->sCurrentLang = new Language((int)Context::getContext()->cookie->id_lang);
            }
        }
    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'AddToCart' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        if (!empty($this->aProducts)) {
            $aLastKey = end($this->aProducts);
            reset($this->aProducts);

            //init the string
            $this->sContent_ids = parent::$sOpenTag;

            foreach ($this->aProducts as $aProduct) {
                $this->sContent_ids .= parent::$sQuote;
                $this->sContent_ids .= Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code);
                $this->sContent_ids .= (String)$aProduct['id_product'];
                $this->sContent_ids .= parent::$sQuote;

                //check if we are at the end of the array to manage the come adds
                if (($aProduct['id_product'] != $aLastKey['id_product'])
                    || $aProduct['id_product_attribute'] != $aLastKey['id_product_attribute']) {
                    $this->sContent_ids .= ',';
                }
            }

            $this->sContent_ids .= parent::$sCloseTag;
        }
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
        // get the cart amount
        $this->fValue = parent::$sQuote . $this->oCart->getOrderTotal() . parent::$sQuote;
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = parent::$sQuote . Context::getContext()->currency->iso_code . parent::$sQuote;
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
    }
}