<?php
/**
 * pixel-category-tags_class.php file defines methods to handle properties related to the category
 */

class BT_PixelCategoryTags extends BT_BasePixelTags
{
    /**
     * @var bool $iCategoryId : current object is a category
     */
    public $iCategoryId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        require_once(_FPA_PATH_LIB . 'module-tools_class.php');

        $this->bValid = false;

        // use case - detect if we've got JS params
        $this->aJsParams = !empty($aParams['js']) && is_array($aParams['js']) ? $aParams['js'] : false;

        //get the category id
        $this->iCategoryId = (int)$aParams['iCategoryId'];
        $this->oCategory = new Category($this->iCategoryId, FacebookProductAd::$iCurrentLang);

        if (!empty($this->oCategory)) {

            //handle the pagnitation
            $iPostPage = Tools::getValue('p');
            $iPostProductPerPage = Tools::getValue('n');
            $sPostOrderBy = Tools::getValue('orderby');
            $sPostOrderWay = Tools::getValue('orderby');

            $iPage = !empty($iPostPage) ? $iPostPage : 0;
            $iProductPerPage = !empty($iPostProductPerPage) ? $iPostProductPerPage : Configuration::get('PS_PRODUCTS_PER_PAGE');
            $sOrderby = !empty($sPostOrderBy) ? $sPostOrderBy : null;
            $sOrderway = !empty($sPostOrderWay) ? $sPostOrderWay : null;

            $this->aProducts = $this->oCategory->getProducts(FacebookProductAd::$iCurrentLang, $iPage, $iProductPerPage,
                $sOrderby, $sOrderway, false, true, false, 1, true, null);

            if (!empty($this->aProducts)) {
                //get the context information
                $this->sCurrentLang = new Language(FacebookProductAd::$iCurrentLang);
                $this->bValid = true;
            }
        }
    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'ViewCategory' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        if (!empty($this->aProducts)) {
            $aLastKey = end($this->aProducts);
            reset($this->aProducts);

            //init the string
            $this->sContent_ids = parent::$sOpenTag;

            foreach ($this->aProducts as $aProduct) {
                $this->sContent_ids .= parent::$sQuote;
                $this->sContent_ids .= Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code);
                $this->sContent_ids .= (String)$aProduct['id_product'];
                $this->sContent_ids .= parent::$sQuote;

                //check if we are at the end of the array to manage the come adds
                if ($aProduct['id_product'] != $aLastKey['id_product']) {
                    $this->sContent_ids .= ',';
                }
            }
            $this->sContent_ids .= parent::$sCloseTag;
        }
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
        //get the current category name
        $this->sContent_name = parent::$sQuote . str_replace(array('\'', '"'), ' ',
                $this->oCategory->name) . parent::$sQuote;
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
        $this->sContent_Category = parent::$sQuote . str_replace(array('\'', '"'), ' ',
                html_entity_decode(BT_FpaModuleTools::getProductPath($this->iCategoryId,
                    FacebookProductAd::$iCurrentLang))) . parent::$sQuote;
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
        if (!empty($this->sContent_ids)) {
            // handle the content id to have a valid array to set the information for each products element on the list
            $sProducts = $this->sContent_ids;
            $sProducts = str_replace('[', '', $sProducts);
            $sProducts = str_replace(']', '', $sProducts);
            $sProducts = str_replace('\'', '', $sProducts);
            $sProducts = str_replace(Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']), '',
                $sProducts);
            $sProducts = str_replace(Tools::strtoupper($this->sCurrentLang->iso_code), '', $sProducts);
            $aProductsInfo = explode(',', $sProducts);

            foreach ($aProductsInfo as $sKey => $aProductInfo) {
                // set the array to have the good key value association
                $aProductsInfoFormat = array('iProductId' => $aProductInfo);

                $oTagsCtrl = BT_BasePixelTags::get('product', $aProductsInfoFormat);
                $oTagsCtrl->set();
                $aTags = $oTagsCtrl->display();
                $aProduct = array(
                    'content_name' => str_replace('\'','',$aTags['content_name']['value']),
                    'content_category' => str_replace('\'','',$aTags['content_category']['value']),
                    'content_ids' => $aTags['content_ids']['value'],
                    'content_type' => str_replace('\'','',$aTags['content_type']['value']),
                    'value' => $aTags['value']['value'],
                    'currency' => str_replace('\'','',$aTags['currency']['value']),
                );

                //prepare the String with the current product id
                $this->aJsParams['cartSelectorCat'] = FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_CAT'];
                $this->aJsParams['cartSelectorCat'] = str_replace('_PRODUCT_ID_', $aProductInfo,
                    $this->aJsParams['cartSelectorCat']);
                $this->sJsCode .= _FPA_JS_NAME . '.addToCart(' . Tools::jsonEncode($aProduct) . ', \'' . $this->aJsParams['cartSelectorCat'] . '\');';

                // only PS 1.6 has the wishlist selector on the category page
                if (!empty(FacebookProductAd::$bCompare16)) {
                    $this->aJsParams['wishSelectorCat'] = FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_CAT'];
                    $this->aJsParams['wishSelectorCat'] = str_replace('_PRODUCT_ID_', $aProductInfo,
                        $this->aJsParams['wishSelectorCat']);
                    $this->sJsCode .= _FPA_JS_NAME . '.addToWishList(' . Tools::jsonEncode($aProduct) . ', \'' . $this->aJsParams['wishSelectorCat'] . '\');';
                }
            }
        }
    }
}