<?php
/**
 * pixel-home-tags_class.php file defines methods to handle properties related to the home
 */

class BT_PixelHomeTags extends BT_BasePixelTags
{
    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        //get the context information
        $this->sCurrentLang = new Language((int)Context::getContext()->cookie->id_lang);

        //get the information from module installed in the homepage
        foreach ($GLOBALS[_FPA_MODULE_NAME . '_MODULES_LIST'] as $sModuleName => $aParams) {
            if (method_exists($aParams['callback']['class'], $aParams['callback']['method'])
                && BT_FpaModuleTools::isInstalled($sModuleName)
            ) {// get populated products
                $this->aProducts = call_user_func_array(array(
                    $aParams['callback']['class'],
                    $aParams['callback']['method']
                ), array($sModuleName, $aParams['limit']));

                if (!empty($aProducts)) {
                    foreach ($aProducts as $id => $aProduct) {
                        if (!isset($aProductIds[$aProduct['id_product']])) {
                            $aProductIds[$aProduct['id_product']] = $aProduct['id_product'];
                        } else {
                            unset($aProducts[$id]);
                        }
                    }
                }
            }
        }

        if (!empty($this->aProducts)) {
            $this->bValid = true;
        }
    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'ViewContent' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        $aProducts = array();
        $aProductIds = array();

        //init the string
        $this->sContent_ids = parent::$sOpenTag;

        if (!empty($this->aProducts)) {
            $aLastKey = end($this->aProducts);
            reset($this->aProducts);
            foreach ($this->aProducts as $aProduct) {
                $this->sContent_ids .= parent::$sQuote;
                $this->sContent_ids .= Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code);
                $this->sContent_ids .= (String)$aProduct['id_product'];
                $this->sContent_ids .= parent::$sQuote;

                //check if we are at the end of the array to manage the come adds
                if ($aProduct != $aLastKey) {
                    $this->sContent_ids .= ',';
                }
            }
        }

        $this->sContent_ids .= parent::$sCloseTag;
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
        $this->sContent_name = parent::$sQuote . 'Homepage' . parent::$sQuote;
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
        if (!empty($this->sContent_ids)) {
            // handle the content id to have a valid array to set the information for each products element on the list
            $sProducts = $this->sContent_ids;
            $sProducts = str_replace('[', '', $sProducts);
            $sProducts = str_replace(']', '', $sProducts);
            $sProducts = str_replace('\'', '', $sProducts);
            $sProducts = str_replace(Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']), '',
                $sProducts);
            $sProducts = str_replace(Tools::strtoupper($this->sCurrentLang->iso_code), '', $sProducts);
            $aProductsInfo = explode(',', $sProducts);

            if (!empty($aProductsInfo)) {
                foreach ($aProductsInfo as $aProductInfo) {
                    // set the array to have the good key value association
                    $aProductsInfoFormat = array('iProductId' => $aProductInfo);

                    $oTagsCtrl = BT_BasePixelTags::get('product', $aProductsInfoFormat);
                    $oTagsCtrl->set();
                    $aTags = $oTagsCtrl->display();

                    if (!empty($aTags['content_name']['value'])) {
                        $aProduct = array(
                            'content_name' => $aTags['content_name']['value'],
                            'content_category' => $aTags['content_category']['value'],
                            'content_ids' => $aTags['content_ids']['value'],
                            'content_type' => $aTags['content_type']['value'],
                            'value' => $aTags['value']['value'],
                            'currency' => $aTags['currency']['value'],
                        );

                        //prepare the String with the current product id
                        $this->aJsParams['cartSelectorCat'] = FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_CAT'];
                        $this->aJsParams['cartSelectorCat'] = str_replace('_PRODUCT_ID_', $aProductInfo,
                            $this->aJsParams['cartSelectorCat']);
                        $this->sJsCode .= _FPA_JS_NAME . '.addToCart(' . Tools::jsonEncode($aProduct) . ', \'' . $this->aJsParams['cartSelectorCat'] . '\');';
                    }
                }
            }

        }
    }
}