<?php
/**
 * pixel-other-tags_class.php file defines methods to handle properties related to the others pages
 */

class BT_PixelNewProductsTags extends BT_BasePixelTags
{
    /**
     * @var bool $iCategoryId : current object is a category
     */
    public $iManufacturerId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        // use case - detect if we've got JS params
        $this->aJsParams = !empty($aParams['js']) && is_array($aParams['js']) ? $aParams['js'] : false;

        //handle the pagnitation
        $iPostPage = Tools::getValue('p');
        $iPostProductPerPage = Tools::getValue('n');

        $iPage = !empty($iPostPage) ? $iPostPage : 0;
        $iProductPerPage = !empty($iPostProductPerPage) ? $iPostProductPerPage : Configuration::get('PS_PRODUCTS_PER_PAGE');

        // get new products
        $this->aProducts = Product::getNewProducts(FacebookProductAd::$iCurrentLang, $iPage, $iProductPerPage);

        if (!empty($this->aProducts)) {
            $this->bValid = true;
            //get the context information
            $this->sCurrentLang = new Language((int)Context::getContext()->cookie->id_lang);
        }
    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'ViewContent' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        if (!empty($this->aProducts)) {
            $aLastKey = end($this->aProducts);
            reset($this->aProducts);

            //init the string
            $this->sContent_ids = parent::$sOpenTag;

            foreach ($this->aProducts as $aProduct) {
                $this->sContent_ids .= parent::$sQuote;
                $this->sContent_ids .= Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code);
                $this->sContent_ids .= (String)$aProduct['id_product'];
                $this->sContent_ids .= parent::$sQuote;

                //check if we are at the end of the array to manage the come adds
                if ($aProduct['id_product'] != $aLastKey['id_product']) {
                    $this->sContent_ids .= ',';
                }
            }

            $this->sContent_ids .= parent::$sCloseTag;
        }
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
        //get the current category name
        $this->sContent_name = parent::$sQuote . 'New Products' . parent::$sQuote;
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
        if (!empty($this->sContent_ids)) {
            // handle the content id to have a valid array to set the information for each products element on the list
            $sProducts = $this->sContent_ids;
            $sProducts = str_replace('[', '', $sProducts);
            $sProducts = str_replace(']', '', $sProducts);
            $sProducts = str_replace('\'', '', $sProducts);
            $sProducts = str_replace(Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']), '',
                $sProducts);
            $sProducts = str_replace(Tools::strtoupper($this->sCurrentLang->iso_code), '', $sProducts);
            $aProductsInfo = explode(',', $sProducts);

            foreach ($aProductsInfo as $aProductInfo) {
                // set the array to have the good key value association
                $aProductsInfoFormat = array('iProductId' => $aProductInfo);

                $oTagsCtrl = BT_BasePixelTags::get('product', $aProductsInfoFormat);
                $oTagsCtrl->set();
                $aTags = $oTagsCtrl->display();
                $aProduct = array(
                    'content_name' => $aTags['content_name']['value'],
                    'content_category' => $aTags['content_category']['value'],
                    'content_ids' => $aTags['content_ids']['value'],
                    'content_type' => $aTags['content_type']['value'],
                    'value' => $aTags['value']['value'],
                    'currency' => $aTags['currency']['value'],
                );

                // Use case for the addToCartButton from the product page
                $aProductCartData = array(
                    'content_name' => str_replace('\'', '', $aTags['content_name']['value']),
                    'content_category' => str_replace('\'', '',$aTags['content_category']['value']) ,
                    'content_ids' => $aTags['content_ids']['value'],
                    'content_type' => str_replace('\'', '', $aTags['content_type']['value']),
                    'value' => Tools::ConvertPrice($aTags['value']['value']),
                    'currency' => str_replace('\'', '', $aTags['currency']['value']),
                );

                //prepare the String with the current product id
                $this->aJsParams['cartSelectorCat'] = FacebookProductAd::$aConfiguration['FPA_JS_CART_SELECTOR_CAT'];
                $this->aJsParams['cartSelectorCat'] = str_replace('_PRODUCT_ID_', $aProductInfo,
                    $this->aJsParams['cartSelectorCat']);
                $this->sJsCode .= _FPA_JS_NAME . '.addToCart(' . Tools::jsonEncode($aProductCartData) . ', \'' . $this->aJsParams['cartSelectorCat'] . '\');';

                // only PS 1.6 has the wishlist selector on the category page
                if (!empty(FacebookProductAd::$bCompare16)) {
                    $this->aJsParams['wishSelectorCat'] = FacebookProductAd::$aConfiguration['FPA_JS_WISH_SELECTOR_CAT'];
                    $this->aJsParams['wishSelectorCat'] = str_replace('_PRODUCT_ID_', $aProductInfo,
                        $this->aJsParams['wishSelectorCat']);
                    $this->sJsCode .= _FPA_JS_NAME . '.addToWishList(' . Tools::jsonEncode($aProductCartData) . ', \'' . $this->aJsParams['wishSelectorCat'] . '\');';
                }
            }
        }
    }

}