<?php
/**
 * pixel-product-tags_class.php file defines methods to handle properties related to the product
 */

class BT_PixelProductTags extends BT_BasePixelTags
{
    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iProductId = 0;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = false;

        //get the product id
        $this->iProductId = isset($aParams['iProductId']) ? $aParams['iProductId'] : false;

        if (!empty($this->iProductId)) {
            $this->bValid = true;

            // use case - detect if we've got JS params
            $this->aJsParams = !empty($aParams['js']) && is_array($aParams['js']) ? $aParams['js'] : false;

            // get the current object
            $this->oProduct = new Product($this->iProductId, true);
            //get context information
            $this->sCurrentLang = new Language(Context::getContext()->cookie->id_lang);


        }
    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'ViewContent' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        if (!empty($this->sCurrentLang)) {
            $this->sContent_ids = parent::$sOpenTag . parent::$sQuote . Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code) . $this->iProductId . parent::$sQuote . parent::$sCloseTag;
        }
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $this->sContent_name = parent::$sQuote . str_replace(array('\'', '"'), ' ',
                    $this->oProduct->name[FacebookProductAd::$iCurrentLang]) . parent::$sQuote;
        }
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
        // get the static Price with the default function from PS
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $this->fValue = Product::getPriceStatic($this->iProductId, true, false, 2, null, false,
                    true);
        }
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = parent::$sQuote . Context::getContext()->currency->iso_code . parent::$sQuote;
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
        if (!empty($this->oProduct) && is_object($this->oProduct)) {
            $oCategory = new Category($this->oProduct->id_category_default, FacebookProductAd::$iCurrentLang);
            if (!empty($oCategory) && is_object($oCategory)) {
                $this->sContent_Category = parent::$sQuote . str_replace(array('\'', '"'), ' ',
                        $oCategory->name) . parent::$sQuote;
            }
        }
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
        if (!empty($this->sContent_name)
            && !empty($this->sContent_Category)
            && !empty($this->sContent_ids)
            && !empty($this->sContent_type)
            && !empty($this->fValue)
            && !empty($this->sCurrency)) {

            $aProduct = array(
                'content_name' => $this->sContent_name,
                'content_category' => $this->sContent_Category,
                'content_ids' => $this->sContent_ids,
                'content_type' => $this->sContent_type,
                'value' => Tools::ConvertPrice($this->fValue),
                'currency' => $this->sCurrency,
            );

            // Use case for the addToCartButton from the product page
            $aProductCartData = array(
                'content_name' => str_replace('\'', '', $this->sContent_name),
                'content_category' => str_replace('\'', '', $this->sContent_Category) ,
                'content_ids' => $this->sContent_ids,
                'content_type' => str_replace('\'', '', $this->sContent_type),
                'value' => Tools::ConvertPrice($this->fValue),
                'currency' => str_replace('\'', '', $this->sCurrency),
            );

            $this->sJsCode .= _FPA_JS_NAME . '.addToCart(' . Tools::jsonEncode($aProductCartData) . ', \'' . $this->aJsParams['cartSelectorProd'] . '\');';
            $this->sJsCode .= _FPA_JS_NAME . '.addToWishList(' . Tools::jsonEncode($aProduct) . ', \'' . $this->aJsParams['wishSelectorProd'] . '\');';

        }

    }
}