<?php
/**
 * pixel-purchase-tags_class.php file defines methods to handle properties related to the current order
 */

class BT_PixelPurchaseTags extends BT_BasePixelTags
{
    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iOrderId = 0;

    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iCartId = 0;

    /**
     * @var array $aProducts : current object is a Product
     */
    public $bUseSmarty = false;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = true;

        require_once(_FPA_PATH_LIB . 'module-dao_class.php');
        require_once(_FPA_PATH_LIB . 'module-tools_class.php');


        //get the order object when the conversion code is added in the order confirmation page
        if (empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])
            && (Tools::getValue('controller') == 'orderconfirmation' || Tools::getValue('controller') == 'submit')) {

            $this->iOrderId = $aParams['iOrderId'];
            $this->oOrder = New Order((int)$this->iOrderId);
            $aProductInfo['order_information'] = $this->oOrder;
            $aProductInfo['products'] = $this->oOrder->getCartProducts();

        } // for the case when the code is added BEFORE the order confirmation page for the PS 1.6
        elseif (!empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])
            && Tools::getValue('controller') == 'order'
            && empty(FacebookProductAd::$bCompare17)) {

            $aProductInfo = BT_FpaModuleTools::buildOrderTag($aParams['iCartId'],
                Context::getContext()->smarty->tpl_vars['total_shipping'],
                Context::getContext()->smarty->tpl_vars['total_wrapping'],
                Context::getContext()->smarty->tpl_vars['total_shipping_tax_exc'],
                Context::getContext()->smarty->tpl_vars['total_wrapping_tax_exc']);

            $this->bUseSmarty = true;
        } // Use case before order confirmation on the 1.7
        elseif (!empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])
            && !empty(FacebookProductAd::$bCompare17)) {

            $aProductInfo = BT_FpaModuleTools::buildOrderTag($aParams['iCartId']);

            $this->bUseSmarty = true;
        } else {
            $this->bValid = false;
        }

        //get context information
        $this->sCurrentLang = new Language((int)Context::getContext()->cookie->id_lang);

        //build the tag
        $this->aProducts = !empty($aProductInfo['products']) ? $aProductInfo['products'] : array();
        $this->oOrder = !empty($aProductInfo['order_information']) ? $aProductInfo['order_information'] : array();

    }

    /**
     * setTrackingType() method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = parent::$sQuote . 'Purchase' . parent::$sQuote;
    }

    /**
     * setContentType() method set the content type
     */
    public function setContentType()
    {
        $this->sContent_type = parent::$sQuote . 'product' . parent::$sQuote;
    }

    /**
     * setContentIds() method set the content ids
     */
    public function setContentIds()
    {
        if (!empty($this->aProducts)) {
            //init the string
            $aLastKey = end($this->aProducts);
            reset($this->aProducts);

            //init the string
            $this->sContent_ids = parent::$sOpenTag;

            foreach ($this->aProducts as $aProduct) {
                $this->sContent_ids .= parent::$sQuote;
                $this->sContent_ids .= Tools::strtoupper(FacebookProductAd::$aConfiguration['FPA_ID_PREFIX']) . Tools::strtoupper($this->sCurrentLang->iso_code);
                $this->sContent_ids .= (String)$aProduct['id_product'];
                $this->sContent_ids .= parent::$sQuote;

                //check if we are at the end of the array to manage the come adds
                if (($aProduct['id_product'] != $aLastKey['id_product'])
                    || $aProduct['id_product_attribute'] != $aLastKey['id_product_attribute']) {
                    $this->sContent_ids .= ',';
                }
            }

            $this->sContent_ids .= parent::$sCloseTag;
        }
    }

    /**
     * setContentName() method set the content name
     */
    public function setContentName()
    {
    }

    /**
     * setValue() method set total value
     */
    public function setValue()
    {
        // check case on the order confirmation page
        if (empty(FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_DISPLAY_FUNNEL'])) {
            $this->fValue = parent::$sQuote . BT_FpaModuleTools::getOrderPrice($this->oOrder,
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_TAX'],
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_SHIPPING'],
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_WRAPPING']) . parent::$sQuote;
        } //check case before the order confirmation page
        else {
            $this->fValue = parent::$sQuote . BT_FpaModuleTools::getOrderPrice($this->oOrder,
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_TAX'],
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_SHIPPING'],
                    FacebookProductAd::$aConfiguration[_FPA_MODULE_NAME . '_USE_WRAPPING']) . parent::$sQuote;
        }
    }

    /**
     * setCurrency() method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = parent::$sQuote . Context::getContext()->currency->iso_code . parent::$sQuote;
    }

    /**
     * setQuerySearch() method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * setContentCategory() method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * setJsCode() method set JS code if needed by some tags object as category for add to cart and add to wishlist events
     */
    public function setJsCode()
    {
    }
}