<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Pixel;

use FacebookProductAd\ModuleLib\moduleTools;
use FacebookProductAd\Pixel\basePixel;
use FacebookProductAd\FacebookApi\FacebookClient;

class pixelPurchase extends basePixel
{
    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iOrderId = 0;

    /**
     * @var bool $iProductId : current object is a Product
     */
    public $iCartId = 0;

    /**
     * @var array $aProducts : current object is a Product
     */
    public $bUseSmarty = false;

    /**
     * __construct magic method assign
     *
     * @param array $aParams
     */
    public function __construct(array $aParams)
    {
        $this->bValid = true;

        $iCartId = \Tools::getValue('id_cart');
        $iOrderId = $aParams['iOrderId'];

        if (!empty($iOrderId)) {
            $this->iOrderId = $iOrderId;
        } elseif (!empty($iCartId)) {
            $this->iOrderId = \Order::getIdByCartId($iCartId);
        }

        if (!empty($this->iOrderId)) {
            $this->oOrder = new \Order((int) $this->iOrderId);
            $aProductInfo['order_information'] = $this->oOrder;
            $aProductInfo['products'] = $this->oOrder->getCartProducts();
        }

        //Set bValid
        $this->bValid = false;

        //get context information
        $this->sCurrentLang = new \Language((int) \Context::getContext()->cookie->id_lang);

        //build the tag
        $this->aProducts = !empty($aProductInfo['products']) ? $aProductInfo['products'] : array();
        $this->oOrder = !empty($aProductInfo['order_information']) ? $aProductInfo['order_information'] : array();
    }

    /**
     * method set the content type
     */
    public function setTrackingType()
    {
        $this->sTrakingType = 'Purchase';
    }

    /**
     * method set the content type
     */
    public function setContentType()
    {

        $this->sContent_type = 'product';
    }

    /**
     * method set the content ids
     */
    public function setContentIds()
    {
       $this->sContent_ids = ModuleTools::buildContentIds('product_listing', $this->sCurrentLang->iso_code, null, $this->aProducts);
    }

    /**
     * method set the content name
     */
    public function setContentName()
    {
    }

    /**
     * method set total value
     */
    public function setValue()
    {
        // check case on the order confirmation page
        $this->fValue = moduleTools::getOrderPrice($this->oOrder, \FacebookProductAd::$conf['FPA_USE_TAX'], \FacebookProductAd::$conf['FPA_USE_SHIPPING'], \FacebookProductAd::$conf['FPA_USE_WRAPPING']);
    }

    /**
     * method the currency
     */
    public function setCurrency()
    {
        // get the currency code
        $this->sCurrency = \Context::getContext()->currency->iso_code;
    }

    /**
     * method the query search
     */
    public function setQuerySearch()
    {
    }

    /**
     * method set the category values
     */
    public function setContentCategory()
    {
    }

    /**
     * method set the code for conversion API
     */
    public function setApiData()
    {
        $user_data = moduleTools::getApiUserData(\Context::getContext());

        if (empty(\FacebookProductAd::$conf['FPA_HAS_WARNING'])) {
            $data = '{
                    "data": [
                        {
                            "event_name": "Purchase",
                            "event_time": ' . time() . ',
                            "action_source": "website",
                            "event_id": "' . $user_data['event_id'] . '",
                            "user_data": {
                                "em": "' . $user_data['em']  . '",
                                "ph": "' . $user_data['ph']  . '",
                                "fn": "' . $user_data['fn']  . '",
                                "ln": "' . $user_data['ln']  . '",
                                "db": "' . $user_data['db']  . '",
                                "ge": "' . $user_data['ge']  . '",
                                "ct": "' . $user_data['ct']  . '",
                                "st": "' . $user_data['st']  . '",
                                "zp": "' . $user_data['zp']  . '",
                                "country": "' . $user_data['country']  . '",
                                "external_id": "' . $user_data['external_id']  . '",
                                "client_ip_address": "' . $user_data['client_ip_address']  . '",
                                "client_user_agent": "' . $user_data['client_user_agent']  . '"
                            },
                            "custom_data": {
                                "content_category": "",
                                "content_ids": "' . $this->sContent_ids . '",
                                "content_name": "",
                                "content_type": "product",
                                "currency": "' . $this->sCurrency .'",
                                "value": "' . $this->fValue .'",
                            }
                        }
                    ],

                }';
        } else {
            $data = '{
                "data": [
                    {
                        "event_name": "Purchase",
                        "event_time": ' . time() . ',
                        "action_source": "website",
                        "event_id": "' . $user_data['event_id'] . '",
                        "user_data": {
                            "em": "' . $user_data['em']  . '",
                            "ph": "' . $user_data['ph']  . '",
                            "fn": "' . $user_data['fn']  . '",
                            "ln": "' . $user_data['ln']  . '",
                            "db": "' . $user_data['db']  . '",
                            "ge": "' . $user_data['ge']  . '",
                            "zp": "' . $user_data['zp']  . '",
                            "country": "' . $user_data['country']  . '",
                            "external_id": "' . $user_data['external_id']  . '",
                            "client_user_agent": "' . $user_data['client_user_agent']  . '"
                        },
                        "custom_data": {
                            "content_category": "",
                            "content_ids": "' . $this->sContent_ids . '",
                            "content_name": "",
                            "content_type": "product",
                            "currency": "' . $this->sCurrency .'",
                            "value": "' . $this->fValue .'",
                        }
                    }
                ],

            }';
        }

        FacebookClient::send($data);
    }
}
