<?php
/**
 * Dynamic Ads + Pixel
 *
 * @author    businesstech.fr <modules@businesstech.fr> - https://www.businesstech.fr/
 * @copyright Business Tech - https://www.businesstech.fr/
 * @license   see file: LICENSE.txt
 *
 *           ____    _______
 *          |  _ \  |__   __|
 *          | |_) |    | |
 *          |  _ <     | |
 *          | |_) |    | |
 *          |____/     |_|
 */

namespace FacebookProductAd\Models;

class Feeds extends \ObjectModel
{
    /** @var int id_feed **/
    public $id_feed;

    /** @var string values **/
    public $iso_lang;

    //** @var string values **/
    public $iso_country;

    //** @var string values **/
    public $iso_currency;

    //** @var string values **/
    public $taxonomy;

    /** @var int id_shop **/
    public $id_shop;

    /** @var string Object creation date */
    public $date_add;

    /** @var string Object last modification date */
    public $date_upd;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'fpa_feeds',
        'primary' => 'id_feed',
        'fields' => array(
            'iso_lang'      =>  array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
            'iso_country'      =>  array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
            'iso_currency'      =>  array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
            'taxonomy'      =>  array('type' => self::TYPE_STRING, 'validate' => 'isString', 'required' => true),
            'id_shop'     =>  array('type' => self::TYPE_INT, 'validate' => 'isInt', 'required' => true),
            'date_upd'      =>  array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat'),
            'date_add'      =>  array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat'),
        ),
    );

    /**
     * check if data has aleady saved, to handle the new system on module update if needed
     *
     * @param int $id_shop
     * @return bool
     */
    public static function hasSavedData($id_shop)
    {
        $query = new \DbQuery();
        $query->select('id_feed');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return !empty(\Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query)) ? true : false;
    }

    /**
     * get all the data from the taxonomies saved on database
     *
     * @param int $id_shop
     * @return array
     */
    public static function getAvailableFeeds($id_shop)
    {
        $query = new \DbQuery();
        $query->select('*');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return \Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
    }

    /**
     * get the data feed for an iso lang
     *
     * @param string $iso_lang
     * @param int $id_shop
     * @return array
     */
    public static function getFeedLangData($iso_lang, $id_shop)
    {
        $query = new \DbQuery();
        $query->select('*');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.iso_lang="' . \pSQL($iso_lang) . '"');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return \Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
    }

    /**
     * get the data feed for an iso lang
     *
     * @param string $iso_lang
     * @param string $iso_country
     * @param string $iso_currency
     * @param string $taxonomy
     * @param int $id_shop
     * @return bool
     */
    public static function feedExist($iso_lang, $iso_country, $iso_currency, $taxonomy, $id_shop)
    {
        $query = new \DbQuery();
        $query->select('ff.id_feed');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.iso_lang="' . \Tools::strtoupper(\pSQL($iso_lang)) . '"');
        $query->where('ff.iso_country="' . \Tools::strtolower(\pSQL($iso_country)) . '"');
        $query->where('ff.iso_currency="' . \pSQL($iso_currency) . '"');
        $query->where('ff.taxonomy="' . \pSQL($taxonomy) . '"');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return !empty(\Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query)) ? true : false;
    }

    /**
     * get the data feed taxonomy
     *
     * @param string $iso_lang
     * @param string $iso_country
     * @param string $iso_currency
     * @param int $id_shop
     * @return bool
     */
    public static function getFeedTaxonomy($iso_lang, $iso_country, $iso_currency, $id_shop)
    {
        $query = new \DbQuery();
        $query->select('ff.taxonomy');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.iso_lang="' . \Tools::strtoupper(\pSQL($iso_lang)) . '"');
        $query->where('ff.iso_country="' . \Tools::strtolower(\pSQL($iso_country)) . '"');
        $query->where('ff.iso_currency="' . \pSQL($iso_currency) . '"');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return \Db::getInstance(_PS_USE_SQL_SLAVE_)->getValue($query);
    }

    /**
     * get all saved taxonomies for a shop
     * @param int $id_shop
     * @return array
     */
    public static function getSavedTaxonomies($id_shop)
    {
        $query = new \DbQuery();
        $query->select('*');
        $query->from('fpa_feeds', 'ff');
        $query->where('ff.id_shop=' . (int)$id_shop);

        return \Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
    }
}
