DROP TABLE IF EXISTS `PREFIX_fpa_categories`;
DROP TABLE IF EXISTS `PREFIX_fpa_taxonomy_categories`;
DROP TABLE IF EXISTS `PREFIX_fpa_taxonomy`;
DROP TABLE IF EXISTS `PREFIX_fpa_brands`;
DROP TABLE IF EXISTS `PREFIX_fpa_tags`;
DROP TABLE IF EXISTS `PREFIX_fpa_tags_brands`;
DROP TABLE IF EXISTS `PREFIX_fpa_tags_cats`;
DROP TABLE IF EXISTS `PREFIX_fpa_tags_suppliers`;
DROP TABLE IF EXISTS `PREFIX_fpa_features_by_cat`;
DROP TABLE IF EXISTS `PREFIX_fpa_reporting`;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_categories` (`id_category` int(11) NOT NULL, `id_shop` int(11) NOT NULL DEFAULT "1",  UNIQUE KEY `id_category` (`id_category`, `id_shop`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_taxonomy_categories` (`id_category` int(11) NOT NULL, `id_shop` int(3) NOT NULL DEFAULT "1", `txt_taxonomy` text NOT NULL, `lang` char(5) NOT NULL, KEY `id_category` (`id_category`,`lang`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_taxonomy` (`id_taxonomy` int(11) NOT NULL AUTO_INCREMENT, `value` text NOT NULL, `lang` varchar(5) NOT NULL, PRIMARY KEY (`id_taxonomy`), KEY `lang` (`lang`), FULLTEXT KEY `ft_index` (`value`)) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_brands` (`id_brands` int(11) NOT NULL, `id_shop` int(11) NOT NULL DEFAULT "1",  UNIQUE KEY `id_brands` (`id_brands`, `id_shop`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags` (`id_tag` int(11) NOT NULL AUTO_INCREMENT, `id_shop` int(11) NOT NULL DEFAULT "1", `name` char(255) NOT NULL, `type` char(255) NOT NULL, `active` TINYINT NOT NULL, `position` INT NOT NULL, `end_date` DATE, PRIMARY KEY (`id_tag`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_brands` (`id_tag` int(11) NOT NULL, `id_brand` int(11) NOT NULL, UNIQUE KEY `tag_brand` (`id_tag`,`id_brand`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_cats` (`id_tag` int(11) NOT NULL, `id_category` int(11) NOT NULL, UNIQUE KEY `tag_cat` (`id_tag`,`id_category`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_suppliers` (`id_tag` int(11) NOT NULL, `id_supplier` int(11) NOT NULL, UNIQUE KEY `tag_supplier` (`id_tag`,`id_supplier`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_features_by_cat` (`id_cat` int(11) NOT NULL DEFAULT '0', `values` text NOT NULL, PRIMARY KEY (`id_cat`), `id_shop` int(11) NOT NULL DEFAULT "1") ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_advanced_exclusion` (`id` int(11) NOT NULL AUTO_INCREMENT, `status` int(11) NOT NULL DEFAULT "1", `id_shop` int(11) NOT NULL DEFAULT "1", `name` char(255) NOT NULL, `type` char(255) NOT NULL, `exclusion_value` longtext NOT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_product_excluded` (`id_rule` int(11) NOT NULL DEFAULT "0",`id_product` int(11) NOT NULL DEFAULT "0", `id_product_attribute` int(11)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tmp_rules`(`id` int(11) NOT NULL AUTO_INCREMENT, `id_shop` int(11) NOT NULL DEFAULT "1",`type` char(255) NOT NULL, `exclusion_values` longtext NOT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_brands` (`id_tag` int(11) NOT NULL, `id_brand` int(11) NOT NULL, UNIQUE KEY `tag_brand` (`id_tag`,`id_brand`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_cats` (`id_tag` int(11) NOT NULL, `id_category` int(11) NOT NULL, UNIQUE KEY `tag_cat` (`id_tag`,`id_category`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_products` (`id_tag` int(11) NOT NULL, `id_product` int(11) NOT NULL, product_name VARCHAR (255) NOT NULL, UNIQUE KEY `tag_product` (`id_tag`,`id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_suppliers` (`id_tag` int(11) NOT NULL, `id_supplier` int(11) NOT NULL, UNIQUE KEY `tag_supplier` (`id_tag`,`id_supplier`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_best_sale` (`id_tag` int(11) NOT NULL, `amount` CHAR(255) NOT NULL, `unit` CHAR(255) ,`start_date` DATETIME, `end_date` DATETIME, `id_product` CHAR(255), UNIQUE KEY `tag_best_sales` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_price_range` (`id_tag` int(11) NOT NULL, `price_min` CHAR(255) NOT NULL, `price_max` CHAR(255), `id_product` CHAR(255), UNIQUE KEY `tag_price_range` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_categories` (`id_tag` int(11) NOT NULL, `id_category` int(11) NOT NULL, `id_shop` int(11) NOT NULL,  UNIQUE KEY `tag_feature` (`id_tag`, `id_category`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_features` (`id_tag` int(11) NOT NULL, `id_feature` int(11) NOT NULL,  UNIQUE KEY `tag_feature` (`id_tag`, `id_feature`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_new_product` (`id_tag` int(11) NOT NULL,  `from_date` DATETIME, `id_product` int,  UNIQUE KEY `tag_new_product` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_price_range` (`id_tag` int(11) NOT NULL, `price_min` CHAR(255) NOT NULL, `price_max` CHAR(255), `id_product` CHAR(255), UNIQUE KEY `tag_price_range` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_last_product_ordered` (`id_tag` int(11) NOT NULL,`start_date` DATETIME, `end_date` DATETIME, `id_product` CHAR(255), UNIQUE KEY `last_product_ordered` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_tags_dynamic_promotion` (`id_tag` int(11) NOT NULL,`start_date` DATETIME, `end_date` DATETIME, `id_product` CHAR(255), UNIQUE KEY `promotion` (`id_tag`, `id_product`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_reporting` (`id_reporting` int(11) NOT NULL AUTO_INCREMENT,`iso_feed` LONGTEXT NOT NULL,    `reporting_content` LONGTEXT NOT NULL,`id_shop` int(11) NOT NULL,`date_add` datetime NOT NULL,`date_upd` datetime NOT NULL,PRIMARY KEY (`id_reporting`)) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;
CREATE TABLE IF NOT EXISTS `PREFIX_fpa_feeds` (`id_feed` int(11) NOT NULL AUTO_INCREMENT,`iso_lang` LONGTEXT NOT NULL,`iso_country` LONGTEXT NOT NULL,`iso_currency` LONGTEXT NOT NULL, `taxonomy` LONGTEXT NOT NULL, `id_shop` int(11) NOT NULL,`date_add` datetime NOT NULL,`date_upd` datetime NOT NULL,PRIMARY KEY (`id_feed`)) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;