<?php
/**
 * Crop images instead of adding whitespace around them
 *
 * @package   gmcrop
 * @author    Dariusz Tryba (contact@greenmousestudio.com)
 * @copyright Copyright (c) Green Mouse Studio (http://www.greenmousestudio.com)
 * @license   http://greenmousestudio.com/paid-license.txt
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class Gmcrop extends Module
{
    protected $cropOrigin;
    protected $croppedImageTypes = array();
    protected $backgroundColor;
    protected $cropBackground = false;
    protected $optimizeForBandwitdh = false;
    protected $fittedImageTypes = array();

    public function __construct()
    {
        $this->name = 'gmcrop';
        $this->prefix = strtoupper($this->name);
        $this->tab = 'administration';
        $this->version = '1.2.3';
        $this->author = 'GreenMouseStudio.com';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Perfect Thumbnails');
        $this->description = $this->l('Crop images instead of adding whitespace around them');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->getConfiguration();
    }

    protected function getConfiguration()
    {
        $this->cropOrigin = Configuration::get($this->prefix.'_ORIGIN');
        $this->backgroundColor = Configuration::get($this->prefix.'_BGCOLOR');
        $imageTypesString = Configuration::get($this->prefix.'_CROPPEDTYPES');
        $this->croppedImageTypes = explode(',', $imageTypesString);
        $this->cropBackground = (bool)Configuration::get($this->prefix.'_CROPBG');
        $this->optimizeForBandwitdh = (bool)Configuration::get($this->prefix.'_BANDWIDTH');
        $optimizedTypesString = Configuration::get($this->prefix.'_FITTEDTYPES');
        $this->fittedImageTypes = explode(',', $optimizedTypesString);
    }

    public function install()
    {
        return parent::install() &&
            Configuration::updateValue($this->prefix.'_ORIGIN', 4) &&
            Configuration::updateValue($this->prefix.'_BGCOLOR', '#ffffff') &&
            Configuration::updateValue($this->prefix.'_CROPPEDTYPES', 'home_default') &&
            Configuration::updateValue($this->prefix.'_CROPBG', true) &&
            Configuration::updateValue($this->prefix.'_FITTEDTYPES', 'thickbox_default') &&
            $this->registerHook('displayBackOfficeHeader');
    }

    public function uninstall()
    {
        Configuration::deleteByName($this->prefix.'_ORIGIN');
        Configuration::deleteByName($this->prefix.'_BGCOLOR');
        Configuration::deleteByName($this->prefix.'_CROPPEDTYPES');
        Configuration::deleteByName($this->prefix.'_FITTEDTYPES');
        Configuration::deleteByName($this->prefix.'_CROPBG');
        return parent::uninstall();
    }

    public function getContent()
    {
        $this->getConfiguration();
        $output = '';
        if (((bool) Tools::isSubmit($this->name.'submit')) == true) {
            $this->postProcess();
            $output .= $this->displayConfirmation($this->l('Settings updated'));
        }
        $output .= $this->renderForm();
        return $output;
    }

    protected function getImagesTypes()
    {
        $data = array();
        $imagesTypes = ImageType::getImagesTypes();
        foreach ($imagesTypes as $type) {
            $data[] = $type['name'];
        }
        return $data;
    }

    protected function renderTypesCheckboxes($name, $label, $selectedTypes)
    {
        $content = '<div class="form-group media-body">
                        <label class="control-label col-lg-3">'.$label.'</label>
                        <div class="col-lg-9">';
        $imageTypes = $this->getImagesTypes();
        foreach ($imageTypes as $type) {
            $content .= '<div class="checkbox">';
            $content .= '<label for="img_'.$name.$type.'">';
            $content .= '<input id="img_'.$name.$type.'" type="checkbox" name="'.$name.'[]" value="'.$type.'" ';
            if (is_array($selectedTypes) && in_array($type, $selectedTypes)) {
                $content .= ' checked ';
            }
            $content.= '>';
            $content .= $type.'</label>';
            $content .= '</div>';
        }
        $content .= '</div></div>';
        return $content;
    }

    protected function renderPanelFooter()
    {
        $output = '<div class="panel-footer">
                        <button type="submit" value="1" id="module_form_submit_btn" name="'.$this->name.'submit" class="btn btn-default pull-right">
						<i class="process-icon-save"></i>'.$this->l('Save').'
					</button></div>';
        return $output;
    }

    protected function renderForm()
    {
        $output = '<div class="panel">'
            .'<div class="panel-heading"><i class="icon-cogs"></i> '
            .$this->l('Settings')
            .'</div>'
            .'<form action="" method="post">'
            .'<div class="form-wrapper">';
        if (function_exists('imagecropauto')) {
            $output .= $this->renderCheckbox($this->prefix.'_CROPBG', $this->l('Extract product from background'), $this->cropBackground, $this->l('Removes white or transparent background around the product on the original image.'));
        }
        $output .= $this->renderTypesCheckboxes('GMCROP_FITTEDTYPES', $this->l('Keep original proportions for images of type:'), $this->fittedImageTypes);
        $output .= $this->renderOriginMatrix();
        $output .= $this->renderTypesCheckboxes('GMCROP_CROPPEDTYPES', $this->l('Crop images of type:'), $this->croppedImageTypes);
        $output .= $this->renderColorPicker();
        $output .= $this->renderPanelFooter();
        $output .= '</form></div>';
        return $output;
    }

    protected function renderOriginMatrix()
    {
        $output = '<div class="form-group media-body">
        <label class="control-label col-lg-3">'.$this->l('Cropping origin').'</label><div class="col-lg-9">';
        $output .= '<table><tr>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="0" ';
        if ($this->cropOrigin == 0) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="1" ';
        if ($this->cropOrigin == 1) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="2" ';
        if ($this->cropOrigin == 2) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '</tr>';
        $output .= '<tr>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="3" ';
        if ($this->cropOrigin == 3) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="4" ';
        if ($this->cropOrigin == 4) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="5" ';
        if ($this->cropOrigin == 5) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '</tr>';
        $output .= '<tr>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="6" ';
        if ($this->cropOrigin == 6) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="7" ';
        if ($this->cropOrigin == 7) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '<td style="padding:5px"><input type="radio" name="GMCROP_ORIGIN" value="8" ';
        if ($this->cropOrigin == 8) {
            $output .= ' checked="checked" ';
        }
        $output .= '/></td>';
        $output .= '</tr>';
        $output .= '</table>';
        $output .= '</div></div>';
        return $output;
    }

    protected function renderTextInput($name, $label, $value = null, $help = null)
    {
        $content = '<div class="form-group media-body">
                        <label class="control-label col-lg-3">'.$label.'</label>
                        <div class="col-lg-9">
                            <input type="text" name="'.$name.'" id="'.$name.'" value="'.$value.'" class="">';
        if ($help != null) {
            $content .= '<p class="help-block">'.$help.'</p>';
        }
        $content .= '</div>
					</div>';
        return $content;
    }

    protected function renderCheckbox($name, $label, $checked = false, $help = null, $onText = null,
                                      $offText = null)
    {
        if (!$onText) {
            $onText = $this->l('Yes');
        }
        if (!$offText) {
            $offText = $this->l('No');
        }
        $content = '<div class="form-group media-body">
                        <label class="control-label col-lg-3">'.$label.'</label>
                        <div class="col-lg-9">
                            <span class="switch prestashop-switch fixed-width-lg">
                                <input type="radio" name="'.$name.'" id="'.$name.'_on" value="1" ';
        if ($checked) {
            $content .= ' checked="checked" ';
        }
        $content .= '>
                                <label for="'.$name.'_on">'.$onText.'</label>
                                <input type="radio" name="'.$name.'" id="'.$name.'_off" value="" ';
        if (!$checked) {
            $content .= ' checked="checked" ';
        }
        $content .= '">
                                <label for="'.$name.'_off">'.$offText.'</label>
                                <a class="slide-button btn"></a>
                            </span>';
        if ($help != null) {
            $content .= '<p class="help-block">'.$help.'</p>';
        }

        $content .='</div>
					</div>';
        return $content;
    }

    protected function renderColorPicker()
    {
        $content = '';
        $content .= '<div class="form-group media-body">
            <label class="control-label col-lg-3">'.$this->l('Background color').'</label>
				<div class="col-lg-9 ">
                    <div class="form-group">
                        <div class="col-lg-2">
                            <div class="row">
                                <div class="input-group">
                                    <input type="color" data-hex="true" name="'.$this->prefix.'_BGCOLOR" value="'.$this->backgroundColor.'"/>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>';
        return $content;
    }

    protected function postProcess()
    {
        $this->cropOrigin = Tools::getValue($this->prefix.'_ORIGIN');
        $this->backgroundColor = Tools::getValue($this->prefix.'_BGCOLOR');
        $this->croppedImageTypes = Tools::getValue($this->prefix.'_CROPPEDTYPES');
        $this->cropBackground = Tools::getValue($this->prefix.'_CROPBG');
        $this->optimizeForBandwitdh = Tools::getValue($this->prefix.'_BANDWIDTH');
        $this->fittedImageTypes = Tools::getValue($this->prefix.'_FITTEDTYPES');
        $this->updateConfiguration();
    }

    protected function updateConfiguration()
    {
        Configuration::updateValue($this->prefix.'_ORIGIN', $this->cropOrigin);
        Configuration::updateValue($this->prefix.'_BGCOLOR', $this->backgroundColor);
        $croppedTypesString = '';
        if (is_array($this->croppedImageTypes)) {
            $croppedTypesString = implode(',', $this->croppedImageTypes);
        }
        Configuration::updateValue($this->prefix.'_CROPPEDTYPES', $croppedTypesString);
        Configuration::updateValue($this->prefix.'_CROPBG', $this->cropBackground);
        $fittedTypesString = '';
        if (is_array($this->fittedImageTypes)) {
            $fittedTypesString = implode(',', $this->fittedImageTypes);
        }
        Configuration::updateValue($this->prefix.'_FITTEDTYPES', $fittedTypesString);
        return true;
    }

    public function hookDisplayBackOfficeHeader()
    {
        $this->context->controller->addJquery();
        $this->context->controller->addjqueryPlugin('colorpicker');
    }
}
