<?php
/**
 * 2007-2020 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş. <devops@paytr.com>
 * @copyright PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş.
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş.
 */

require_once(dirname(__FILE__) . '/../../classes/PaytrNotification.php');

class PaytrCheckoutNotificationModuleFrontController extends ModuleFrontController
{
    private $uniq_separator = 'PAYTRYPS';

    public function postProcess()
    {
        if (!isset($_POST) or empty(Tools::getValue('hash'))) {
            echo '';
            exit;
        }

        $notification = new PaytrNotification();
        $notification->context = Context::getContext();

        if (Tools::getValue('payment_type') == 'eft') {
            $notification->module = Module::getInstanceByName('paytrefttransfer');
            $notification->eftCallback($_POST, $this->uniq_separator);
        } else {
            $notification->module = $this->module;
            $notification->iframeCallback($_POST, $this->uniq_separator);
        }
    }
}
