{*
 * 2007-2020 PrestaShop and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş. <devops@paytr.com>
 * @copyright PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş.
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PayTR Ödeme ve Elektronik Para Kuruluşu A.Ş.
*}

<style>
    #paytrRefundTable thead th:not(:first-child), #paytrRefundTable tbody td:not(:first-child) {
        text-align: center;
    }
</style>
<div id="formPaytrTransactionPanel" class="panel">
    <div class="panel-heading">
        <img src="{$pt.icon_paytr|escape:'htmlall':'UTF-8'}"/>
        {l s='TRANSACTIONS' mod='paytrcheckout'}
        <span class="panel-heading-action">
            <a href="javascript:;" class="list-toolbar-btn" onclick="loadTransactionTable()">
                <span data-toggle="tooltip" class="label-tooltip" data-html="true" data-placement="top">
                    <i class="process-icon-refresh"></i>
                </span>
            </a>
        </span>
    </div>

    <div class="table-responsive">
        <table class="table" id="paytrRefundTable">
            <thead>
            <tr>
                <th><span class="title_box">{l s='Order Number' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Total' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Total Paid' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Notification Status' mod='paytrcheckout'}</span>
                </th>
                <th class="text-center"><span class="title_box">{l s='Status Message' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Refunded' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Refunded Status' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Refunded Amount' mod='paytrcheckout'}</span></th>
                <th class="text-center"><span class="title_box">{l s='Date' mod='paytrcheckout'}</span></th>
                <th class="text-center"></th>
            </tr>
            </thead>
            <tbody id="paytrRefundTableBody">
            <tr>
                <td colspan="10" align="center">
                    <img src="{$pt.icon_loader|escape:'htmlall':'UTF-8'}" width="30" style="margin: 20px 0;">
                </td>
            </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="paytrRefundModal" tabindex="-1" role="dialog" aria-labelledby="paytrRefundModalLabel"
     aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <form id="paytrRefundForm">
                    <div class="form-group">
                        <label for="paytrRefundAmount"
                               class="col-form-label">{l s='Amount of Refund' mod='paytrcheckout'}:</label>
                        <div class="input-group">
                            <div class="input-group-addon">{$pt.currency_icon|escape:'htmlall':'UTF-8'}</div>
                            <input type="text" class="form-control" id="txtPaytrRefundAmount">
                        </div>
                    </div>
                </form>
                <div id="paytrRefundResponseBody" style="margin-bottom: 0!important;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="btnCloseModal"
                        data-dismiss="modal">{l s='Cancel' mod='paytrcheckout'}</button>
                <button type="button" id="paytrRefundBtn"
                        class="btn btn-warning">{l s='Refund Payment' mod='paytrcheckout'}</button>
            </div>
        </div>
    </div>
</div>


<script type="text/javascript">

    // <![CDATA[
    // Translations
    var paytr_error = '{l s='An error occurred.' mod='paytrcheckout' js=1}';
    var paytr_error_table_load = '{l s='An error occurred while loading the table.' mod='paytrcheckout' js=1}';
    var paytr_error_check_console = '{l s='Check the console(F12) for more info.' mod='paytrcheckout' js=1}';
    var paytr_trans_wait = '{l s='Please Wait' mod='paytrcheckout' js=1}';
    var paytr_trans_error = '{l s='Error!' mod='paytrcheckout' js=1}';
    var paytr_trans_success = '{l s='Success!' mod='paytrcheckout' js=1}';
    var paytr_success_refund = '{l s='The refund process is completed successfully.' mod='paytrcheckout' js=1}';
    var paytr_btn_refund_payment = '{l s='Refund Payment' mod='paytrcheckout' js=1}';
    //]]>

    var paytr_id_order = {$pt.id_order|escape:'htmlall':'UTF-8'},
        paytr_path = '{$pt.path|escape:'htmlall':'UTF-8'}',
        paytr_icon_loader = '{$pt.icon_loader|escape:'htmlall':'UTF-8'}';

    function loadTransactionTable() {

        const tableBody = $('#paytrRefundTableBody');
        tableBody.html('<tr><td colspan="10" align="center"><img src="' + paytr_icon_loader + '" width="30" style="margin: 20px 0;"></td></tr>');

        $.ajax({
            url: paytr_path,
            cache: false,
            type: 'POST',
            data: {
                ajax: 1,
                submitPaytrRefundTable: 1,
                token: '{getAdminToken tab="AdminOrders"}',
                action: 'transactions',
                id_order: paytr_id_order
            },
            success: function (res) {
                res = $.parseJSON(res);
                tableBody.html(res.body);
            },
            error: function (res) {
                tableBody.html("<tr><td colspan='10' align='center'>" + paytr_error_table_load + "<br/><small>" + paytr_error_check_console + "</small></td></tr>");
                console.log(res.responseText);
            }
        });
    }

    function resetBtn(btn) {
        btn
            .html(paytr_btn_refund_payment)
            .attr('disabled', false)
            .removeClass()
            .addClass('btn btn-warning');
    }

    $(window).on('load', function () {
        loadTransactionTable();
    });

    $('#paytrRefundModal').on('show.bs.modal', function (event) {
        const button = $(event.relatedTarget);
        const modal = $(this);
        modal.find('.modal-body #txtPaytrRefundAmount').val(button.data('amount'));
    });

    $(document).on('click', '#paytrRefundBtn', function (e) {

        const button = $('#paytrRefundBtn');
        const btnModal = $('#btnCloseModal');
        const amount = document.getElementById('txtPaytrRefundAmount').value;
        const responseBody = $('#paytrRefundResponseBody');

        responseBody
            .html('')
            .removeClass();

        button
            .html('<img src="' + paytr_icon_loader + '" width="10" style="margin-right: 5px; vertical-align:middle;" />' + paytr_trans_wait + '')
            .attr('disabled', true)
            .removeClass()
            .addClass('btn btn-disabled');

        btnModal
            .attr('disabled', true);

        $.ajax({
            url: paytr_path,
            cache: false,
            type: 'POST',
            data: {
                ajax: 1,
                submitPaytrRefund: 1,
                token: '{getAdminToken tab="AdminOrders"}',
                action: 'refundApi',
                'amount': amount,
                id_order: paytr_id_order
            },
            success: function (res) {

                res = $.parseJSON(res);

                if (!res.status) {
                    responseBody
                        .addClass('alert alert-danger')
                        .html('<p>' + paytr_trans_error + ' ' + res + '</p>');

                    resetBtn(button);
                    btnModal.attr('disabled', false);
                }
                if (res.status === 'error') {
                    responseBody
                        .addClass('alert alert-danger')
                        .html('<p>' + paytr_trans_error + ' ' + res.err_msg + '</p>');

                    resetBtn(button);
                    btnModal.attr('disabled', false);
                }
                if (res.status === 'success') {
                    responseBody
                        .addClass('alert alert-success')
                        .html('<p>' + paytr_trans_success + ' ' + paytr_success_refund + '</p>');

                    setTimeout(function () {
                        $('#paytrRefundModal').modal('hide');

                        if (res.refund_status === 'partial') {
                            resetBtn(button);
                            btnModal.attr('disabled', false);
                            responseBody
                                .removeClass()
                                .html('');
                        }
                    }, 1000);

                    loadTransactionTable();
                }
            },
            error: function (res) {

                responseBody
                    .addClass('alert alert-danger')
                    .html('<p>' + paytr_trans_error + ' ' + paytr_error + '<br/><small>' + paytr_error_check_console + '</small></p>');

                console.log(res.responseText);

                resetBtn(button);
            }
        });
    });

</script>