<?php
/**
 * @author PayTR Ödeme Hizmetleri A.Ş. <devops@paytr.com>
 * @copyright 2020 PayTR
 * @license PAYTR https://www.paytr.com/
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class PaytrTaksitTablosu extends Module
{
    private $contentHtml = '';
    private $postErrors = array();

    public function __construct()
    {
        $this->name = 'paytrtaksittablosu';
        $this->tab = 'others';
        $this->version = '1.0.0';
        $this->author = 'PayTR';
        $this->className = 'PaytrTaksitTablosu';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->need_instance = 0;

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('PayTR Taksit Tablosu');
        $this->description = $this->l('Ürün detay sayfasında taksit tablosunu gösterebilirsiniz.');
        $this->confirmUninstall = $this->l('PAYTR modülünü kaldırmak istediğinizden emin misiniz?');
    }

    public function install()
    {
        if (!parent::install() or
            !$this->registerHook('displayProductExtraContent')) {
            return false;
        }

        Configuration::updateValue('paytrtaksittablosu_tab_title', 'Taksit Tablosu');

        return true;
    }

    public function uninstall()
    {
        Configuration::deleteByName('paytrtaksittablosu_tab_title');
        Configuration::deleteByName('paytrtaksittablosu_merchant_id');
        Configuration::deleteByName('paytrtaksittablosu_taksit_token');
        Configuration::deleteByName('paytrtaksittablosu_max_installment');
        Configuration::deleteByName('paytrtaksittablosu_advantage_installment');
        Configuration::deleteByName('paytrtaksittablosu_description_top');
        Configuration::deleteByName('paytrtaksittablosu_description_bottom');

        return parent::uninstall();
    }

    public function hookDisplayProductExtraContent($params)
    {
        $tab = array();
        $price = null;
        $catalog = false;

        $id_group = (int)Group::getCurrent()->id;
        $group = new Group($id_group);

        $product = $params['product'];

        $catalog_mode = Configuration::get('PS_CATALOG_MODE');
        $catalog_mode_with_price = Configuration::get('PS_CATALOG_MODE_WITH_PRICES');

        if ($group->price_display_method != 0) {
            $price = Product::getPriceStatic($params['product']->id, false, null, 2);
        } else {
            $price = Product::getPriceStatic($params['product']->id, true, null, 2);
        }

        if ($catalog_mode == 1 and $catalog_mode_with_price == 0) {
            $catalog = false;
        } elseif ($catalog_mode == 1 and $catalog_mode_with_price == 1) {
            $catalog = true;
        } else {
            $catalog = true;
        }

        if ($catalog and $group->show_prices and $product->show_price) {
            $this->context->controller->addCSS(_PS_MODULE_DIR_ . $this->name . '/views/css/paytrtaksittablosu.css');
            $this->context->smarty->assign(
                [
                    'taksit_merchant_id' => Configuration::get('paytrtaksittablosu_merchant_id'),
                    'taksit_token' => Configuration::get('paytrtaksittablosu_taksit_token'),
                    'taksit_max_installment' => Configuration::get('paytrtaksittablosu_max_installment'),
                    'taksit_advantage_installment' => Configuration::get('paytrtaksittablosu_advantage_installment'),
                    'taksit_description_top' => Configuration::get('paytrtaksittablosu_description_top'),
                    'taksit_description_bottom' => Configuration::get('paytrtaksittablosu_description_bottom'),
                    'taksit_price' => $price
                ]
            );

            $tab[] = (new PrestaShop\PrestaShop\Core\Product\ProductExtraContent())
                ->setTitle(Configuration::get('paytrtaksittablosu_tab_title'))
                ->setContent($this->context->smarty->fetch('module:paytrtaksittablosu/views/templates/hook/product_tab_content.tpl'));
            return $tab;
        } else {
            return false;
        }
    }

    protected function getConfigFieldsValues()
    {
        $form_inputs = null;
        $form_inputs = array(
            'tab_title' => Tools::getValue('tab_title', Configuration::get('paytrtaksittablosu_tab_title')),
            'merchant_id' => Tools::getValue('merchant_id', Configuration::get('paytrtaksittablosu_merchant_id')),
            'taksit_token' => Tools::getValue('taksit_token', Configuration::get('paytrtaksittablosu_taksit_token')),
            'max_installment' => Tools::getValue('max_installment', Configuration::get('paytrtaksittablosu_max_installment')),
            'advantage_installment' => Tools::getValue('advantage_installment', Configuration::get('paytrtaksittablosu_advantage_installment')),
            'description_top' => Tools::getValue('description_top', Configuration::get('paytrtaksittablosu_description_top')),
            'description_bottom' => Tools::getValue('description_bottom', Configuration::get('paytrtaksittablosu_description_bottom'))
        );
        return $form_inputs;
    }

    protected function displayFormInfo()
    {
        $this->context->smarty->assign(
            [
                'img' => Media::getMediaPath(_PS_MODULE_DIR_ . $this->name . '/views/img/paytr.png')
            ]
        );

        return $this->display(__FILE__, 'infos.tpl');
    }

    protected function displayForm()
    {
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));

        // Advantage Installment
        $advantage_options = array(
            array('id_option' => 0, 'name' => $this->l('Avantajlı Taksitleri Göster')),
            array('id_option' => 1, 'name' => $this->l('Tüm Taksitleri Göster'))
        );

        // Installment Option
        $installment_options = array();

        for ($i = 0; $i < 13; $i++) {
            if ($i == 0) {
                $installment_options[] = array(
                    'id_option' => $i,
                    'name' => $this->l('Tüm Taksit Seçenekleri')
                );
            } else if ($i == 1) {
                continue;
            } else {
                $installment_options[] = array(
                    'id_option' => $i,
                    'name' => $this->l($i . ' Taksit')
                );
            }
        }

        // Store Information Form
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('PayTr Taksit Tablosu'),
                    'icon' => 'icon-pencil'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Sekme Başlığı'),
                        'name' => 'tab_title',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Mağaza No'),
                        'name' => 'merchant_id',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Token'),
                        'name' => 'taksit_token',
                        'required' => true
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Maksimum Taksit'),
                        'name' => 'max_installment',
                        'options' => array(
                            'query' => $installment_options,
                            'id' => 'id_option',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Avantajlı Taksit'),
                        'name' => 'advantage_installment',
                        'options' => array(
                            'query' => $advantage_options,
                            'id' => 'id_option',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Üst Açıklama'),
                        'name' => 'description_top',
                        'cols' => 8,
                        'rows' => 4,
                        'autoload_rte' => 'rte'
                    ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Alt Açıklama'),
                        'name' => 'description_bottom',
                        'cols' => 8,
                        'rows' => 4,
                        'autoload_rte' => 'rte'
                    )
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                )
            )
        );

        // Helper
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->default_form_language = $lang->id;
        $helper->submit_action = 'btnPayTrTaksitTablosuSubmit';
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues()
        );
        return $helper->generateForm(array($fields_form));
    }

    protected function postValidation()
    {
        if (Tools::isSubmit('btnPayTrTaksitTablosuSubmit')) {
            $tab_title = Tools::safeOutput(Tools::getValue('tab_title'));
            $merchant_id = Tools::safeOutput(Tools::getValue('merchant_id'));
            $taksit_token = Tools::safeOutput(Tools::getValue('taksit_token'));

            // Check Merchant Key != null
            if ($tab_title == null) {
                $this->postErrors[] = $this->l('Sekme başlığının girilmesi zorunludur.');
            }

            // Check Merchant ID != null
            if ($merchant_id == null) {
                $this->postErrors[] = $this->l('Mağaza No\' nun girilmesi zorunludur');
            } else if (!is_numeric($merchant_id)) {
                $this->postErrors[] = $this->l('Mağaza No numerik olmalıdır.');
            }

            // Check Merchant Salt != null
            if ($taksit_token == null) {
                $this->postErrors[] = $this->l('Token girilmesi zorunludur.');
            }
        }
    }

    protected function postProcess()
    {
        if (Tools::isSubmit('btnPayTrTaksitTablosuSubmit')) {
            // Register values to configuration table in database.
            Configuration::updateValue('paytrtaksittablosu_tab_title', Tools::safeOutput(Tools::getValue('tab_title')));
            Configuration::updateValue('paytrtaksittablosu_merchant_id', Tools::safeOutput(Tools::getValue('merchant_id')));
            Configuration::updateValue('paytrtaksittablosu_taksit_token', Tools::safeOutput(Tools::getValue('taksit_token')));
            Configuration::updateValue('paytrtaksittablosu_max_installment', Tools::getValue('max_installment'));
            Configuration::updateValue('paytrtaksittablosu_advantage_installment', Tools::getValue('advantage_installment'));
            Configuration::updateValue('paytrtaksittablosu_description_top', Tools::getValue('description_top'));
            Configuration::updateValue('paytrtaksittablosu_description_bottom', Tools::getValue('description_bottom'));

            $this->contentHtml .= $this->displayConfirmation($this->l('Ayarlar Güncellendi.'));
        }
    }

    public function getContent()
    {
        if (Tools::isSubmit('btnPayTrTaksitTablosuSubmit')) {
            $this->postValidation();

            if (!count($this->postErrors)) {
                $this->postProcess();
            } else {
                foreach ($this->postErrors as $err) {
                    $this->contentHtml .= $this->displayError($err);
                }
            }
        }

        $this->contentHtml .= $this->displayFormInfo();
        $this->contentHtml .= $this->displayForm();

        return $this->contentHtml;
    }
}
