<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class ShopierResponseModuleFrontController extends ModuleFrontController
{
    public $display_column_left = false;
    public $display_column_right = false;
    public $error = '';
    public function postProcess()
    {
        $cart = $this->context->cart;
        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
        }
        $currency = $this->context->currency;
        $total = (float)$cart->getOrderTotal(true, Cart::BOTH);
        $data = '';
        if (Tools::getIsset('platform_order_id')) {
            $cart_id = Tools::getValue('platform_order_id');
            $status = Tools::getValue('status');
            $payment_id = Tools::getValue('payment_id');
            $installment = Tools::getValue('installment');
            if ($cart_id != '' && $cart_id == $cart->id) {
                foreach ($_POST as $key => $value) {
                    if (
                        ($key != "signature") &&
                        ($key != "submit") &&
                        ($key != "successfull_payment") &&
                        ($key != "error_payment")
                    ) {
                        $data = $data.$value;
                    }
                }
                $signature = Tools::getValue('signature');
                $signature = $this->module->base64Decode($signature);
                $expected = $this->module->customHmac($_POST['random_nr'].$_POST['platform_order_id'], Configuration::get('shopier_secret'));
                if ($signature == $expected) {
                    $status = Tools::strtolower($status);
                    if ($status == "success") {
                        $this->module->validateOrder(
                            $cart->id,
                            Configuration::get('PS_OS_PAYMENT'),
                            $total,
                            $this->module->displayName,
                            null,
                            null,
                            (int)$currency->id,
                            false,
                            $customer->secure_key
                        );
                        $this->module->addTransaction($this->module->currentOrder, $payment_id, $installment);
                        $redirectUrl = 'index.php?controller=order-confirmation&id_cart='.$cart->id;
                        $redirectUrl .= '&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder;
                        $redirectUrl .= '&key='.$customer->secure_key;
                        Tools::redirect($redirectUrl);
                    } else {
                        $this->error = $this->module->trans('Transaction Declined: ').Tools::getValue('error_message');
                    }
                } else {
                    $this->error = $this->module->trans('Security Error. Illegal access detected');
                }
            } else {
                $this->error = $this->module->trans('Security Error. Illegal access detected');
            }
        } else {
            $this->error = $this->module->trans('Security Error. Illegal access detected');
        }
    }
    public function initContent()
    {
        if ($this->error != '') {
            parent::initContent();
            $this->context->smarty->assign(array(
                'error' => $this->error
            ));
            $this->setTemplate('module:shopier/views/templates/front/payment_execution.tpl');
        }
    }
}
