<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 */
class ShopierValidationModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function initContent()
    {
		self:$initialized = false;
        parent::initContent();

        $cart = $this->context->cart;
        $customer = $this->context->customer;
        $user_id = $customer->id;
        $user_registered = $customer->date_add;
        $time_elapsed = time() - strtotime($user_registered);
        $buyer_account_age = (int)($time_elapsed/86400);
        $id_currency = $cart->id_currency;
        $currency = new Currency($id_currency);
        $currency = $currency->iso_code;
        if ($currency == 'USD') {
            $currency = 1;
        } elseif ($currency == 'EUR') {
            $currency = 2;
        } else {
            $currency = 0;
        }
        $productinfo = "";
        $producttype = '2';
        $items = $cart->getProducts();
        foreach ($items as $item) {
            $productinfo .= $item['name'].';';
            $is_virtual = $item['is_virtual'];
            if ($producttype != 0 && $is_virtual == 1) {
                $producttype = 1;
            } else {
                $producttype = 0;
            }
        }
        $productinfo = str_replace('"', '', $productinfo);
        $productinfo = str_replace('&quot;', '', $productinfo);
		
        $billing = new Address($cart->id_address_invoice);
        $shipping = new Address($cart->id_address_delivery);
        $billingPhone = $billing->phone;
        if (empty($billingPhone)) {
            $billingPhone = $billing->phone_mobile;
        }
        $billingAddress = $billing->address1;
        if (!empty($billing->address2)) {
            $billingAddress .= ' '.$billing->address2;
        }
        if ($billing->id_state > 0) {
            $state = new State($billing->id_state);
            $billingAddress .= ' '.$state->name;
        }
        $country = new Country($billing->id_country);
        if (is_array($country->name)) {
            $billingCountry = $country->name[$cart->id_lang];
        } else {
            $billingCountry = $country->name;
        }
        $shippingPhone = $shipping->phone;
        if (empty($shippingPhone)) {
            $shippingPhone = $shipping->phone_mobile;
        }
        $shippingAddress = $shipping->address1;
        if (!empty($shipping->address2)) {
            $shippingAddress .= ' '.$shipping->address2;
        }
        if ($shipping->id_state > 0) {
            $state = new State($shipping->id_state);
            $shippingAddress .= ' '.$state->name;
        }
        $country = new Country($shipping->id_country);
        if (is_array($country->name)) {
            $shippingCountry = $country->name[$cart->id_lang];
        } else {
            $shippingCountry = $country->name;
        }
		$current_lang=$this->context->language->iso_code;
		$current_lan=1;
		if ($current_lang == "tr") $current_lan=0;
		$modul_version='1.0.4';
		srand(time(NULL));
        $args = array(
            'API_key' => Configuration::get('shopier_api_key'),
			'website_index' => Configuration::get('shopier_website_index'),
            'platform_order_id' => $cart->id,
            'product_name' => $productinfo,
            'product_type' => $producttype,
            'buyer_name' => $billing->firstname,
            'buyer_surname' => $billing->lastname,
            'buyer_email' => $customer->email,
            'buyer_account_age' => $buyer_account_age,
            'buyer_id_nr' => $user_id,
            'buyer_phone' => $billingPhone,
            'billing_address' => $billingAddress,
            'billing_city' => $billing->city,
            'billing_country' => $billingCountry,
            'billing_postcode' => $billing->postcode,
            'shipping_address' => $shippingAddress,
            'shipping_city' => $shipping->city,
            'shipping_country' => $shippingCountry,
            'shipping_postcode' => $shipping->postcode,
            'total_order_value' => $cart->getOrderTotal(true, Cart::BOTH),
            'currency' => $currency,
            'platform' => 2,
            'is_in_frame' => 0,
			'current_language' => $current_lan,
			'random_nr' => rand(100000,999999)
        );
        $data = implode('', $args);
		$signature = $this->module->customHmac($args['random_nr'].$args['platform_order_id'].$args['total_order_value'].$args['currency'], Configuration::get('shopier_secret'));
        $signature = base64_encode($signature);
        $args['signature'] = $signature;
        $this->context->smarty->assign(array(
            'payment_url' => Configuration::get('shopier_paypoint_url'),
            'args' => $args
        ));

        $this->setTemplate('module:shopier/views/templates/front/payment.tpl');
    }
}
