<?php

class StProAsAttrClass extends ObjectModel
{
	/** @var integer*/
	public $id;
    /** @var string*/
    public $group_name;
    /** @var integer*/
    public $item_per_row;
    /** @var boolen*/
    public $active;
    /** @var integer*/
    public $id_shop;
	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table'     => 'st_pro_as_attr',
		'primary'   => 'id_st_pro_as_attr',
        'multilang' => true,
		'fields'    => array(
            'item_per_row'   =>array('type' => self::TYPE_STRING, 'validate' => 'isunsignedInt'),
            'active'         =>array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'id_shop'        =>array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt'),
            //
            'group_name'             => array('type' => self::TYPE_STRING, 'lang' => true,'validate' => 'isGenericName',  'size' => 255),
        ),
	);
    
	public function copyFromPost()
	{
		/* Classical fields */
		foreach ($_POST AS $key => $value)
			if (key_exists($key, $this) && $key != 'id_'.$this->table && !isset($_FILES[$key]))
				$this->{$key} = $value;

        /* Multilingual fields */
        if (sizeof($this->fieldsValidateLang))
        {
            $languages = Language::getLanguages(false);
            foreach ($languages AS $language)
                foreach ($this->fieldsValidateLang AS $field => $validation)
					if (isset($_POST[$field.'_'.(int)($language['id_lang'])]) && !isset($_FILES[$field.'_'.(int)($language['id_lang'])]))
                        $this->{$field}[(int)($language['id_lang'])] = $_POST[$field.'_'.(int)($language['id_lang'])];
        }
	}
    
    public static function getContent($active = true)
    {
        $id_lang = Context::getContext()->language->id;
        $result = Db::getInstance()->executeS('
            SELECT paa.*, paal.*
            FROM `'._DB_PREFIX_.'st_pro_as_attr` paa
            LEFT JOIN `'._DB_PREFIX_.'st_pro_as_attr_lang` paal ON (paa.`id_st_pro_as_attr` = paal.`id_st_pro_as_attr`)
            WHERE paal.`id_lang` = '.$id_lang.'
            AND paa.`id_shop` = '.Context::getContext()->shop->id.'
            '.($active ? ' AND paa.`active` = 1' : '')
            );
        return $result;
    }
    public static function getEverythingByIdProduct($id_product)
    {
        $id_lang = Context::getContext()->language->id;
        $result = Db::getInstance()->executeS('
            SELECT paa.*, paal.*
            FROM `'._DB_PREFIX_.'st_pro_as_attr` paa
            LEFT JOIN `'._DB_PREFIX_.'st_pro_as_attr_lang` paal ON (paa.`id_st_pro_as_attr` = paal.`id_st_pro_as_attr`)
            WHERE paal.`id_lang` = '.$id_lang.'
            AND paa.`id_shop` = '.Context::getContext()->shop->id.'
            AND paa.`id_st_pro_as_attr` IN (SELECT `id_st_pro_as_attr`
            FROM `'._DB_PREFIX_.'st_pro_as_attr_pro` 
            WHERE `id_product` = '.(int)$id_product.'
            AND `active` = 1
            GROUP BY `id_st_pro_as_attr`)
            AND paa.`active` = 1'
            );
        if(is_array($result) && count($result)){
            foreach ($result as $ak => $attr) {
                $pros = StProAsAttrProsClass::getByAttrId($attr['id_st_pro_as_attr'], true);
                if(!$pros)
                    unset($result[$ak]);
                
                $result[$ak]['products'] = $pros;
            }
        }
        return $result;
    }
}