<?php
class StProAsAttrProsClass extends ObjectModel
{
    /** @var integer*/
    public $id;
    /** @var integer*/
    public $id_st_pro_as_attr;
    /** @var integer*/
    public $id_product;
    /** @var boolen*/
    public $position;
    /** @var boolen*/
    public $active;
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table'     => 'st_pro_as_attr_pro',
        'primary'   => 'id_st_pro_as_attr_pro',
        'multilang' => true,
        'fields'    => array(
            'id_st_pro_as_attr'   =>array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt'),
            'id_product'   =>array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt'),
            'position'         =>array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt'),
            'active'         =>array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            //
            'short_name'             => array('type' => self::TYPE_STRING, 'lang' => true,'validate' => 'isGenericName',  'size' => 255),
        ),
    );
    
    public function copyFromPost()
    {
        /* Classical fields */
        foreach ($_POST AS $key => $value)
            if (key_exists($key, $this) && $key != 'id_'.$this->table && !isset($_FILES[$key]))
                $this->{$key} = $value;

        /* Multilingual fields */
        if (sizeof($this->fieldsValidateLang))
        {
            $languages = Language::getLanguages(false);
            foreach ($languages AS $language)
                foreach ($this->fieldsValidateLang AS $field => $validation)
                    if (isset($_POST[$field.'_'.(int)($language['id_lang'])]) && !isset($_FILES[$field.'_'.(int)($language['id_lang'])]))
                        $this->{$field}[(int)($language['id_lang'])] = $_POST[$field.'_'.(int)($language['id_lang'])];
        }
    }
    public static function getByAttrId($id_st_pro_as_attr = null, $active = false)
    {
        if(!$id_st_pro_as_attr)
            return false;
        $id_lang = Context::getContext()->language->id;
        $result = Db::getInstance()->executeS('
            SELECT paap.*, paapl.*
            FROM `'._DB_PREFIX_.'st_pro_as_attr_pro` paap
            LEFT JOIN `'._DB_PREFIX_.'st_pro_as_attr_pro_lang` paapl ON (paap.`id_st_pro_as_attr_pro` = paapl.`id_st_pro_as_attr_pro`)
            WHERE paap.`id_st_pro_as_attr` = '.(int)$id_st_pro_as_attr.'
            AND paapl.`id_lang` = '.(int)$id_lang.'
            '.($active ? ' AND paap.`active` = 1' : '').'
            ORDER BY paap.`position` asc'
            );
        return $result;
    }
    
    public static function getListContent($id_st_pro_as_attr = null, $active = false)
    {
        $result = self::getByAttrId($id_st_pro_as_attr, $active);

        if(!$result)
            return false;

        foreach ($result as &$v) {
            $lang = array();
            $res = Db::getInstance()->executeS('
                SELECT *
                FROM `'._DB_PREFIX_.'st_pro_as_attr_pro_lang`
                WHERE `id_st_pro_as_attr_pro` = '.$v['id_st_pro_as_attr_pro']
                );
            foreach ($res as $r) {
                $lang[$r['id_lang']] = $r['short_name'];
            }
            $v['short_name_lang'] = $lang;
        }
        return $result;
    }
    public static function checkExi($id_st_pro_as_attr, $id_product)
    {
        return Db::getInstance()->getValue('
            SELECT count(0)
            FROM `'._DB_PREFIX_.'st_pro_as_attr_pro`
            WHERE `id_st_pro_as_attr` = '.(int)$id_st_pro_as_attr.'
            AND `id_product` = '.(int)$id_product
            );
    }
    public static function updateShortName($id_st_pro_as_attr_pro, $short_name, $id_lang)
    {
        return Db::getInstance()->execute('
            UPDATE `'._DB_PREFIX_.'st_pro_as_attr_pro_lang`
            SET `short_name` = "'.pSQL($short_name).'"
            WHERE `id_st_pro_as_attr_pro` = '.(int)$id_st_pro_as_attr_pro.'
            AND `id_lang`='.$id_lang
            );
    }
}