<?php
/*
* 2007-2019 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
*  @author ST themes <www.sunnytoo.com>
*  @copyright 2018 ST themes team.
*/
if (!defined('_PS_VERSION_'))
    exit;

use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Core\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;

require_once implode(DIRECTORY_SEPARATOR, array(
    __DIR__, 'classes', 'StProAsAttrClass.php',
));
require_once implode(DIRECTORY_SEPARATOR, array(
    __DIR__, 'classes', 'StProAsAttrProsClass.php',
));
class StProductsAsAttrs extends Module
{
    public  $fields_list;
    public  $fields_value;
    public  $fields_form;
    private $_html = '';
    private $spacer_size = '5';
    public $_prefix_st = 'ST_PRO_AS_ATTR_';
    public $pages = array();
    public $selected_controller = array();
    public $validation_errors = array();
    private $_as_results = array();
    private $_hooks;
    public  $fields_list_products_form = array();
    function __construct()
    {
        $this->name          = 'stproductsasattrs';
        $this->tab           = 'front_office_features';
        $this->version       = '1.0.4';
        $this->author        = 'SUNNYTOO.COM';
        $this->need_instance = 0;
        $this->bootstrap     = true;
        
        parent::__construct();

        $this->displayName = $this->l('Show products as attributes of another product.');
        $this->description = $this->l('A good way to show similar products.');
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);


        $this->_hooks = array(
            array('displayUnderProductVariants','displayUnderProductVariants','Under the product variants block',1),
        );
    }
    
    function install()
    { 
        $this->_addHook();

        $res = parent::install()
            && $this->installDB()
            && $this->registerHook('displayHeader')
            && $this->registerHook('displayUnderProductVariants')
            && Configuration::updateValue($this->_prefix_st.'USE_TAG', 0)
            && Configuration::updateValue($this->_prefix_st.'USE_CATEGORY', 0)
            && Configuration::updateValue($this->_prefix_st.'CLICK_ACTION', 0)
            && Configuration::updateValue($this->_prefix_st.'AS_RESULTS', 3)
            && Configuration::updateValue($this->_prefix_st.'STOCK', 0)
            && Configuration::updateValue($this->_prefix_st.'SHOW_PRICE', 0)
            && Configuration::updateValue($this->_prefix_st.'CUSTOM_CSS', '')
            && Configuration::updateValue($this->_prefix_st.'TEXT_COLOR', '')
            && Configuration::updateValue($this->_prefix_st.'TEXT_COLOR_HOVER', '')
            && Configuration::updateValue($this->_prefix_st.'BG', '')
            && Configuration::updateValue($this->_prefix_st.'BG_HOVER', '')
            && Configuration::updateValue($this->_prefix_st.'BORDER', '')
            && Configuration::updateValue($this->_prefix_st.'BORDER_HOVER', '')
            && Configuration::updateValue($this->_prefix_st.'ATTR_HEIGHT', '')
            && Configuration::updateValue($this->_prefix_st.'TPL', '')
            ;

        $this->parseAndRenameFile();

        return $res;
    }

    public function installDB()
    {
        $return = (bool)Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'st_pro_as_attr` (
                `id_st_pro_as_attr` INT UNSIGNED NOT NULL AUTO_INCREMENT,
                `item_per_row` tinyint(3) unsigned NOT NULL DEFAULT 2, 
                `active` tinyint(1) unsigned NOT NULL DEFAULT 1, 
                `id_shop` int(11) unsigned NOT NULL DEFAULT 0,
                PRIMARY KEY (`id_st_pro_as_attr`)
            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;');

        $return &= (bool)Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'st_pro_as_attr_lang` (
                `id_st_pro_as_attr` int(10) UNSIGNED NOT NULL,
                `id_lang` int(10) unsigned NOT NULL ,
                `group_name` varchar(255) DEFAULT NULL,
                PRIMARY KEY (`id_st_pro_as_attr`, `id_lang`)
            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;');
        
        $return &= (bool)Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'st_pro_as_attr_pro` (    
                `id_st_pro_as_attr_pro` int(10) unsigned NOT NULL AUTO_INCREMENT,             
                `id_st_pro_as_attr` int(10) unsigned NOT NULL DEFAULT 0,         
                `id_product` int(10) unsigned NOT NULL DEFAULT 0,
                `position` int(10) unsigned NOT NULL DEFAULT 0, 
                `active` tinyint(1) unsigned NOT NULL DEFAULT 1, 
                PRIMARY KEY (`id_st_pro_as_attr_pro`),
                KEY `id_st_pro_as_attr` (`id_st_pro_as_attr`),
                KEY `id_product` (`id_product`)
            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;');
            
        $return &= (bool)Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'st_pro_as_attr_pro_lang` (
                `id_st_pro_as_attr_pro` int(10) UNSIGNED NOT NULL,
                `id_lang` int(10) unsigned NOT NULL ,
                `short_name` varchar(255) DEFAULT NULL,
                PRIMARY KEY (`id_st_pro_as_attr_pro`, `id_lang`)
            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;');
        
        return $return;
    }

    public function uninstall()
    {
        return $this->uninstallDB() && parent::uninstall(); 
    }

    public function uninstallDB()
    {
        return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'st_pro_as_attr`, `'._DB_PREFIX_.'st_pro_as_attr_lang`, `'._DB_PREFIX_.'st_pro_as_attr_pro`, `'._DB_PREFIX_.'st_pro_as_attr_pro_lang`');
    }

    private function _addHook()
    {
        $res = true;
        foreach($this->_hooks as $v)
        {
            if(!$res)
                break;
            if (!Validate::isHookName($v[0]))
                continue;
                
            $id_hook = Hook::getIdByName($v[0]);
            if (!$id_hook)
            {
                $new_hook = new Hook();
                $new_hook->name = pSQL($v[0]);
                $new_hook->title = pSQL($v[1]);
                $new_hook->description = pSQL($v[2]);
                $new_hook->position = pSQL($v[3]);
                $new_hook->add();
                $id_hook = $new_hook->id;
                if (!$id_hook)
                    $res = false;
            }
            else
            {
                Db::getInstance()->execute('UPDATE `'._DB_PREFIX_.'hook` set `title`="'.$v[1].'", `description`="'.$v[2].'", `position`="'.$v[3].'" where `id_hook`='.$id_hook);
            }
        }
        return $res;
    }

    public function getContent()
    {
        $this->initAsResults();
        if (Tools::version_compare(_PS_VERSION_, '1.7.6.0', '>=')) {
            $st_product_url = 'index.php?controller=AdminProducts&token='.Tools::getAdminTokenLite('AdminProducts').'&ajax=1&action=productsList&disableCombination=1';
        } else {
            $st_product_url = 'ajax_products_list.php?disableCombination=true';
        }
        Media::addJsDef(['st_product_url' => $st_product_url]);
        $this->context->controller->addJS(($this->_path).'views/js/admin.js');
        $this->context->controller->addCSS($this->_path.'views/css/admin.css');

        $id_st_pro_as_attr = (int)Tools::getValue('id_st_pro_as_attr');

        if (Tools::isSubmit('automodify'))
        {
            $result = $this->parseAndRenameFile();
            Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.($result ? '&conf=4' : '').'&token='.Tools::getAdminTokenLite('AdminModules'));
        }

        if ((Tools::isSubmit('status'.$this->name)))
        {
            $object = new StProAsAttrClass((int)$id_st_pro_as_attr);
            if($object->id && $object->toggleStatus())
            {
                Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
            }
            else
                $this->_html .= $this->displayError($this->l('An error occurred while updating the status.'));
        }
        if (Tools::getValue('updatePositions') && Tools::getValue('ajax'))
        {
            $result = array(
                'r' => true,
            );
            $msg = 'success';
            $positions = Tools::getValue('module-stproductsasattrs');
            if (is_array($positions))
                foreach ($positions as $position => $value)
                {
                    $pos = explode('_', $value);
                    if (count($pos)==4)
                    {
                        $object = new StProAsAttrProsClass((int)$pos[2]);
                        if ($object->id) {
                            $object->position = $position;
                            $result['r'] &= $object->update() ? true : false;
                        }
                    }
                }
            die($msg);
        }
        if (Tools::getValue('act')=='st_paap_add')
        {
            $result = array(
                'r' => false,
                'm' =>'',
                'id' => 0,
                'short_name_input' => '',
            );
            if(StProAsAttrProsClass::checkExi(Tools::getValue('id_st_pro_as_attr'),Tools::getValue('id_product'))){
                $result['m'] = $this->l('Already exists');
                die(json_encode($result));
            }
            //
            $object = new StProAsAttrProsClass();
            $error = array();
            $object->copyFromPost();
            $object->active=1;
            if (!count($error) && $object->validateFields(false) && $object->validateFieldsLang(false))
            {
                if($object->save()){
                    $result['r'] = true;
                    $result['id'] = $object->id;

                    $languages = Language::getLanguages();
                    $defaultLanguage = new Language((int)(Configuration::get('PS_LANG_DEFAULT')));
                    $result['short_name_input'] = $this->createShortCodeInput($languages,$defaultLanguage,$object->id);
                }
            }
            die(json_encode($result));
        }
        if (Tools::getValue('act')=='st_paap_del')
        {
            $result = array(
                'r' => false,
                'm' =>'',
            );
            $object = new StProAsAttrProsClass((int)Tools::getValue('id'));
            if ($object->id && $object->delete()) {
                $result['r'] = true;
            }
            die(json_encode($result));
        }
        if (Tools::getValue('act')=='st_paap_pro_active')
        {
            $result = array(
                'r' => false,
                'm' =>'',
            );
            $object = new StProAsAttrProsClass((int)Tools::getValue('id'));
            if ($object->id && $object->toggleStatus()) {
                $result['r'] = true;
            }
            die(json_encode($result));
        }
        if (isset($_POST['save'.$this->name]) || isset($_POST['save'.$this->name.'AndStay']))
        {
            if ($id_st_pro_as_attr)
                $object = new StProAsAttrClass((int)$id_st_pro_as_attr);
            else
                $object = new StProAsAttrClass();
            
            $error = array();
            $object->copyFromPost();
            /*$object->id_products = '';
            $id_product = Tools::getValue('id_product');
            if (!$id_product) {
                $error[] = $this->l('Please add a product.');
            } else {
                $object->id_products = ','.implode(',', $id_product).',';
            }*/

            if (!count($error) && $object->validateFields(false) && $object->validateFieldsLang(false))
            {
                $object->id_shop = $this->context->shop->id;
                if($object->save())
                {
                    $pros = StProAsAttrProsClass::getByAttrId($object->id);
                    if(is_array($pros) && count($pros)){
                        foreach ($pros as $pro) {
                            $languages = Language::getLanguages();
                            foreach ($languages as $language){
                                StProAsAttrProsClass::updateShortName($pro['id_st_pro_as_attr_pro'], Tools::getValue('short_name_'.$pro['id_st_pro_as_attr_pro'].'_'.$language['id_lang']), $language['id_lang']);
                            }
                        }
                    }
                    if(isset($_POST['save'.$this->name.'AndStay']))
                    {
                        Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_st_pro_as_attr='.$object->id.'&conf='.($id_st_pro_as_attr?4:3).'&update'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules')); 
                    }    
                    else
                        $this->_html .= $this->displayConfirmation($this->l('Settings').' '.($id_st_pro_as_attr ? $this->l('updated') : $this->l('added')));
                }                    
                else {
                    $this->_html .= $this->displayError($this->l('An error occurred during settings').' '.($id_st_pro_as_attr ? $this->l('updating') : $this->l('creation')));
                }    
            }
            else
                $this->_html .= count($error) ? $this->displayError(implode('',$error)) : $this->displayError($this->l('Invalid value for field(s).'));
        }
        if (isset($_POST['savesetting'.$this->name])) {
            $this->initSettingFieldsForm();

            if (isset($_POST['custom_css']) && $_POST['custom_css']) {
                $_POST['custom_css'] = str_replace('\\', '¤', $_POST['custom_css']);
            }

            foreach($this->fields_form as $form)
                foreach($form['form']['input'] as $field)
                    if(isset($field['validation']))
                    {
                        $errors = array();       
                        $value = Tools::getValue($field['name']);
                        if (isset($field['required']) && $field['required'] && $value==false && (string)$value != '0')
                                $errors[] = sprintf(Tools::displayError('Field "%s" is required.'), $field['label']);
                        elseif($value)
                        {
                            $field_validation = $field['validation'];
                            if (!Validate::$field_validation($value))
                                $errors[] = sprintf(Tools::displayError('Field "%s" is invalid.'), $field['label']);
                        }
                        // Set default value
                        if ($value === false && isset($field['default_value']))
                            $value = $field['default_value'];
                            
                        if(count($errors))
                        {
                            $this->validation_errors = array_merge($this->validation_errors, $errors);
                        }
                        elseif($value==false)
                        {
                            switch($field['validation'])
                            {
                                case 'isUnsignedId':
                                case 'isUnsignedInt':
                                case 'isInt':
                                case 'isBool':
                                    $value = 0;
                                break;
                                default:
                                    $value = '';
                                break;
                            }
                            Configuration::updateValue($this->_prefix_st.strtoupper($field['name']), $value);
                        }
                        else
                            Configuration::updateValue($this->_prefix_st.strtoupper($field['name']), $value);
                    }
            
            $results = 0;
            foreach($this->_as_results as $v)
                $results += (int)Tools::getValue('as_results_'.$v['id']);
            Configuration::updateValue($this->_prefix_st.'AS_RESULTS', $results);

            Configuration::updateValue($this->_prefix_st.'TPL', Tools::getValue('tpl'), true);

            if(count($this->validation_errors)) {
                $this->_html .= $this->displayError(implode('<br/>',$this->validation_errors));
            } else {
                if(isset($_POST['save'.$this->name.'AndStay']))
                    Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&conf=4&token='.Tools::getAdminTokenLite('AdminModules')); 
                else
                    $this->_html .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }
        if(Tools::isSubmit('add'.$this->name) || (Tools::isSubmit('update'.$this->name) && $id_st_pro_as_attr))
        {
            Media::addJsDef(array(
                'come_from' => $this->name,
                'id_st_pro_as_attr' => $id_st_pro_as_attr,
            ));
            $this->context->controller->addJqueryPlugin('tablednd');
            $this->context->controller->addJS(($this->_path).'../../js/admin/dnd.js');
            $helper = $this->initForm();
            return $this->_html.$helper->generateForm($this->fields_form);
        }
        else if (Tools::isSubmit('delete'.$this->name) && $id_st_pro_as_attr)
        {
            $object = new StProAsAttrClass($id_st_pro_as_attr);
            $object->delete();
            Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
        }
        $helper = $this->initList();
        $this->_html .= $helper->generateList(StProAsAttrClass::getContent(false, null), $this->fields_list);
        $this->initSettingFieldsForm();
        $helper = $this->initSettingForm();
        $this->_html .= $helper->generateForm($this->fields_form);
        return $this->_html;
    }
    private function initAsResults()
    {
        $this->_as_results = array(
                array(
                    'id' => 'image',
                    'val' => '1',
                    'name' => $this->l('Product image'),
                ),
                array(
                    'id' => 'name',
                    'val' => '2',
                    'name' => $this->l('Product name'),
                ),
                /*array(
                    'id' => 'price',
                    'val' => '4',
                    'name' => $this->l('Product price'),
                ),*/
            );
    }

    protected function initList()
    {
        $this->fields_list = array(
            'id_st_pro_as_attr' => array(
                'title' => $this->l('ID'),
                'width' => 120,
                'type' => 'text',
                'search' => false,
                'orderby' => false
            ),
            'group_name' => array(
                'title' => $this->l('Group'),
                'width' => 200,
                'type' => 'text',
                'search' => false,
                'orderby' => false
            ),
            'active' => array(
                'title' => $this->l('Status'),
                'align' => 'center',
                'active' => 'status',
                'type' => 'bool',
                'width' => 25,
                'search' => false,
                'orderby' => false
            ),
        );

        $helper = new HelperList();
        $helper->shopLinkType = '';
        $helper->simple_header = false;
        $helper->identifier = 'id_st_pro_as_attr';
        $helper->actions = array('edit', 'delete');
        $helper->show_toolbar = true;
        $helper->imageType = 'jpg';
        $helper->toolbar_btn['new'] =  array(
            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&add'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            'desc' => $this->l('Add an attribute group'),
        );

        $helper->title = $this->l('Attribute groups');
        $helper->table = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        return $helper;
    }

    protected function initForm()
    {
        $id_st_pro_as_attr = (int)Tools::getValue('id_st_pro_as_attr');
        $object = new StProAsAttrClass($id_st_pro_as_attr);
        
        $this->fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Attribute'),
                'icon' => 'icon-cogs'
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('Attribute name:'),
                    'name' => 'group_name',
                    'size' => 64,
                    'lang' => true,
                ),
                /*array(
                    'type' => 'text',
                    'label' => $this->l('Products per row:'),
                    'name' => 'item_per_row',
                    'class' => 'fixed-width-xxl',
                    'desc' => $this->l('Default is 2.'),
                ),*/
                array(
                    'type' => 'switch',
                    'label' => $this->l('Status:'),
                    'name' => 'active',
                    'is_bool' => true,
                    'default_value' => 1,
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Enabled')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Disabled')
                        )
                    ),
                ),
            ),
            'buttons' => array(
                array(
                    'type' => 'submit',
                    'title'=> $this->l('Save all'),
                    'icon' => 'process-icon-save',
                    'class'=> 'pull-right'
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save and stay'),
                'stay' => true
            ),
        );
        
        $this->fields_form[0]['form']['input'][] = array(
            'type' => 'html',
            'id' => 'a_cancel',
            'label' => '',
            'name' => '<a class="btn btn-default btn-block fixed-width-md" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'"><i class="icon-arrow-left"></i> Back to list</a>',                  
        );
        
        if($object->id)
        {
            $this->fields_form[0]['form']['input'][] = array('type' => 'hidden', 'name' => 'id_st_pro_as_attr');

            $this->fields_form[0]['form']['input']['products'] = array(
                    'type' => 'text',
                    'label' => $this->l('Add products:'),
                    'name' => 'products',
                    'autocomplete' => false,
                    'class' => 'fixed-width-xxl',
                );

            $products_html = '';
            $pros = StProAsAttrProsClass::getListContent($object->id);

            if($pros){
                $languages = Language::getLanguages();
                $defaultLanguage = new Language((int)(Configuration::get('PS_LANG_DEFAULT')));
                foreach($pros AS $pk => $pro)
                {
                    $short_name_input = $this->createShortCodeInput($languages,$defaultLanguage,$pro['id_st_pro_as_attr_pro'], $pro['short_name_lang']);

                    $product = new Product($pro['id_product'], false, Context::getContext()->language->id);
                    $products_html .= '<tr id="st_paap_'.$pro['id_st_pro_as_attr_pro'].'_'.$pk.'" data-id="'.$pro['id_st_pro_as_attr_pro'].'" data-id-product="'.$pro['id_product'].'" class="'.(($pk % 2)==0 ? '' : 'odd').'">
                    <td id="st_paap_td_'.$pro['id_product'].'" class="dragHandle"><div class="dragGroup"><div class="positions">'.($pk+1).'</div></div></td>
                    <td>'.$product->name.'['.$product->reference.']</td>
                    <td>'.$short_name_input.'</td>
                    <td><a href="javascript:;" class="st_paap_pro_active"><i class="icon-check '.($pro['active'] ? '' : 'hidden').'"></i><i class="icon-remove '.($pro['active'] ? 'hidden' : '').'"></i></a></td>
                    <td><a href="javascript:;" class="del_product"><img src="../img/admin/delete.gif" /></a></td>
                    </tr>';
                }
            }
                
            $this->fields_form[0]['form']['input']['products']['desc'] = $this->l('Enter some characters to search prodcuts.').'<br/><table id="table-module-stproductsasattrs" class="table tableDnD">
<thead>
    <tr class="nodrag nodrop">
        <th><span class="title_box active"> '.$this->l('Drag to sort').' </span></th>
        <th><span class="title_box"> '.$this->l('Name').' </span></th>
        <th><span class="title_box"> '.$this->l('Short name').' </span></th>
        <th><span class="title_box"> '.$this->l('Active').' </span></th>
        <th><span class="title_box"> '.$this->l('Action').' </span></th>
    </tr>
</thead>
<tbody>'.$products_html.'</tbody>
</table>';
            
        }else{
            $this->fields_form[0]['form']['input']['products'] = array(
                    'type' => 'html',
                    'id' => '',
                    'label' => $this->l('Add products:'),
                    'name' => $this->l('You will be able to add products after save this group.'),
                );
        }
        
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->id = (int)$object->id;
        $helper->module = $this;
        $helper->table =  'st_pro_as_attr';
        $helper->identifier = 'st_pro_as_attr';
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

        $helper->submit_action = 'save'.$this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getFieldsValueSt($object),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );
        
        return $helper;
    }
    public function createShortCodeInput($languages,$defaultLanguage,$id_st_pro_as_attr_pro, $values=null){
        $short_name_input = '';
        foreach ($languages as $language){
            $short_name_input .= '<div class="translatable-field lang-'.$language['id_lang'].'" '.($language['id_lang']!=$defaultLanguage->id ? 'style="display:none"' : '').'>
                                <div class="col-lg-6"><input type="text" name="short_name_'.$id_st_pro_as_attr_pro.'_'.$language['id_lang'].'" value="'.(is_array($values) && isset($values[$language['id_lang']]) ? $values[$language['id_lang']] : '').'" size="64"></div>';
            if(count($languages)>1){
                $short_name_input .= '<div class="col-lg-2"><button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">'.$language['iso_code'].'<i class="icon-caret-down"></i></button>
                                    <ul class="dropdown-menu">';

                foreach ($languages as $language){
                    $short_name_input .= '<li><a href="javascript:hideOtherLanguage('.$language['id_lang'].');" tabindex="-1">'.$language['name'].'</a></li>';
                }
                $short_name_input .= '</ul></div>';
            }
            $short_name_input .= '</div>';
        }
        return $short_name_input;
    }
    
    public function initSettingFieldsForm()
    {
        $this->fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Settings'),
                'icon'  => 'icon-cogs'
            ),
            'input' => array(
                /*array(
                    'type' => 'switch',
                    'label' => $this->l('Use tags to associate products as attributes'),
                    'name' => 'use_tag',
                    'default_value' => 0,
                    'values' => array(
                        array(
                            'id' => 'use_tag_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'use_tag_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                    'validation' => 'isBool',
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Use default category to associate products as attributes'),
                    'name' => 'use_category',
                    'default_value' => 0,
                    'values' => array(
                        array(
                            'id' => 'use_category_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'use_category_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                    'validation' => 'isBool',
                ),*/
                array(
                    'type' => 'checkbox',
                    'label' => $this->l('How to display'),
                    'name' => 'as_results',
                    'values' => array(
                        'query' => $this->_as_results,
                        'id' => 'id',
                        'name' => 'name'
                    ),
                    'desc' => $this->l('Choose content to display'),
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Hide out of stock products'),
                    'name' => 'stock',
                    'default_value' => 1,
                    'values' => array(
                        array(
                            'id' => 'stock_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'stock_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                    'validation' => 'isBool',
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Show product price'),
                    'name' => 'show_price',
                    'default_value' => 1,
                    'values' => array(
                        array(
                            'id' => 'show_price_on',
                            'value' => 1,
                            'label' => $this->l('Yes')
                        ),
                        array(
                            'id' => 'show_price_off',
                            'value' => 0,
                            'label' => $this->l('No')
                        )
                    ),
                    'validation' => 'isBool',
                ),
                /*array(
                    'type' => 'radio',
                    'label' => $this->l('What to do when click on product attribute'),
                    'name' => 'click_action',
                    'default_value' => 1,
                    'values' => array(
                        array(
                            'id' => 'click_action_0',
                            'value' => 0,
                            'label' => $this->l('Redirect to the product page')
                        ),
                        array(
                            'id' => 'click_action_0',
                            'value' => 1,
                            'label' => $this->l('Check the product attribute and load the product information')
                        )
                    ),
                    'validation' => 'isUnsignedInt',
                ),*/
                'automodify' => array(
                    'type' => 'html',
                    'id' => '',
                    'label' => $this->l('Modifiy the product-variants.tpl file:'),
                    'name' => '<a href="'.AdminController::$currentIndex.'&configure='.$this->name.'&automodify&token='.Tools::getAdminTokenLite('AdminModules').'" class="btn btn-default">Do the modification</a>',
                    'desc' => array(
                        $this->l('If you are using Panda theme v2.4.7+ and Transformer theme v4.4.7+, then no need to do the modification, because the new hook is included by default.'),
                        $this->l('Click on this button to automatically modify the "'._PS_THEME_URI_.'templates/catalog/_partials/product-variants.tpl" file to add a new hook under the product variants block.'),
                        $this->l('Click on this button only when "product attributes" block doesn\'t show out, generally you need to click on this button after every theme update.'),
                        $this->l('Do not worry about the modification messing your site up, a back up of the product-variants.tpl file will be created automatically, you can restore the backup if anything goes wrong.'),
                    ),
                ), 
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'stay' => true
            ),
        );
        $this->fields_form[1]['form'] = array(
            'legend' => array(
                'title' => $this->l('Color settings'),
                'icon'  => 'icon-cogs'
            ),
            'input' => array(
                array(
                    'type' => 'color',
                    'label' => $this->l('Color:'),
                    'name' => 'text_color',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Hover color:'),
                    'name' => 'text_color_hover',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Background:'),
                    'name' => 'bg',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Hover background:'),
                    'name' => 'bg_hover',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Border color:'),
                    'name' => 'border',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'color',
                    'label' => $this->l('Hover border color:'),
                    'name' => 'border_hover',
                    'size' => 33,
                    'validation' => 'isColor',
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Attribute height:'),
                    'name' => 'attr_height',
                    'validation' => 'isUnsignedInt',
                    'prefix' => 'px',
                    'class' => 'fixed-width-lg',
                    'desc'=> $this->l('Set to 0 to use the defualt value 52'),
                ),
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('HTML template:'),
                        'name' => 'tpl',
                        'cols' => 20,
                        'rows' => 20,
                        'desc' => $this->l('Gennerally don\'t do changes to this field.'),
                    ),
                array(
                    'type' => 'textarea',
                    'label' => $this->l('Custom CSS Code:'),
                    'name' => 'custom_css',
                    'cols' => 80,
                    'rows' => 20,
                    'validation' => 'isAnything',
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'stay' => true
            ),
        );
    }
    
    private function getConfigFieldsValues()
    {
        $fields_values = array(
            'use_tag'           => Configuration::get($this->_prefix_st.'USE_TAG'),
            'use_category'      => Configuration::get($this->_prefix_st.'USE_CATEGORY'),
            'click_action'      => (int)Configuration::get($this->_prefix_st.'CLICK_ACTION'),
            'stock'             => Configuration::get($this->_prefix_st.'STOCK'),
            'show_price'        => Configuration::get($this->_prefix_st.'SHOW_PRICE'),
            'custom_css'        => Configuration::get($this->_prefix_st.'CUSTOM_CSS'),
            'text_color' => Configuration::get($this->_prefix_st.'TEXT_COLOR'),
            'text_color_hover' => Configuration::get($this->_prefix_st.'TEXT_COLOR_HOVER'),
            'bg' => Configuration::get($this->_prefix_st.'BG'),
            'bg_hover' => Configuration::get($this->_prefix_st.'BG_HOVER'),
            'border' => Configuration::get($this->_prefix_st.'BORDER'),
            'border_hover' => Configuration::get($this->_prefix_st.'BORDER_HOVER'),
            'attr_height' => Configuration::get($this->_prefix_st.'ATTR_HEIGHT'),
            'tpl' => Configuration::get($this->_prefix_st.'TPL'),
        );
        if ($fields_values['tpl'])
            $fields_values['tpl'] = html_entity_decode($fields_values['tpl']);
        if (isset($fields_values['custom_css']) && $fields_values['custom_css'])
            $fields_values['custom_css'] = str_replace('¤', '\\', $fields_values['custom_css']); 
        return $fields_values;
    }

    public function getConfigVars()
    {
        static $vars;
        if (null === $vars) {
            $vars = array(    
                'use_tag'           => Configuration::get($this->_prefix_st.'USE_TAG'),
                'use_category'      => Configuration::get($this->_prefix_st.'USE_CATEGORY'),
                'click_action'      => (int)Configuration::get($this->_prefix_st.'CLICK_ACTION'),
                'stock'             => Configuration::get($this->_prefix_st.'STOCK'),
                'show_price'        => Configuration::get($this->_prefix_st.'SHOW_PRICE'),
                'as_results'        => Configuration::get($this->_prefix_st.'AS_RESULTS'),
            );    
        }
        return $vars;
    }

    public function get($key)
    {
        $vars = $this->getConfigVars();
        if (key_exists($key, $vars)) {
            return $vars[$key];
        }
    }
    
    protected function initSettingForm()
    {
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->module = $this;
        $helper->table =  $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'savesetting'.$this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );
        foreach($this->_as_results as $v)
            $helper->tpl_vars['fields_value']['as_results_'.$v['id']] = (int)$v['val']&(int)Configuration::get($this->_prefix_st.'AS_RESULTS');

        return $helper;
    }
    
    /**
     * Return the list of fields value
     *
     * @param object $obj Object
     * @return array
     */
    public function getFieldsValueSt($obj,$fields_form="fields_form")
    {
        foreach ($this->$fields_form as $fieldset)
            if (isset($fieldset['form']['input']))
                foreach ($fieldset['form']['input'] as $input)
                    if (!isset($this->fields_value[$input['name']]))
                        if (isset($input['type']) && $input['type'] == 'shop')
                        {
                            if ($obj->id)
                            {
                                $result = Shop::getShopById((int)$obj->id, $this->identifier, $this->table);
                                foreach ($result as $row)
                                    $this->fields_value['shop'][$row['id_'.$input['type']]][] = $row['id_shop'];
                            }
                        }
                        elseif (isset($input['lang']) && $input['lang'])
                            foreach (Language::getLanguages(false) as $language)
                            {
                                $fieldValue = $this->getFieldValueSt($obj, $input['name'], $language['id_lang']);
                                if (empty($fieldValue))
                                {
                                    if (isset($input['default_value']) && is_array($input['default_value']) && isset($input['default_value'][$language['id_lang']]))
                                        $fieldValue = $input['default_value'][$language['id_lang']];
                                    elseif (isset($input['default_value']))
                                        $fieldValue = $input['default_value'];
                                }
                                $this->fields_value[$input['name']][$language['id_lang']] = $fieldValue;
                            }
                        else
                        {
                            $fieldValue = $this->getFieldValueSt($obj, $input['name']);
                            if ($fieldValue===false && isset($input['default_value']))
                                $fieldValue = $input['default_value'];
                            $this->fields_value[$input['name']] = $fieldValue;
                        }

        return $this->fields_value;
    }
    
    /**
     * Return field value if possible (both classical and multilingual fields)
     *
     * Case 1 : Return value if present in $_POST / $_GET
     * Case 2 : Return object value
     *
     * @param object $obj Object
     * @param string $key Field name
     * @param integer $id_lang Language id (optional)
     * @return string
     */
    public function getFieldValueSt($obj, $key, $id_lang = null)
    {
        if ($id_lang)
            $default_value = ($obj->id && isset($obj->{$key}[$id_lang])) ? $obj->{$key}[$id_lang] : false;
        else
            $default_value = isset($obj->{$key}) ? $obj->{$key} : false;

        return Tools::getValue($key.($id_lang ? '_'.$id_lang : ''), $default_value);
    }

    public function getProdcuts()
    {
        $result = StProAsAttrClass::getContent(true, Tools::getValue('id_product'));
        $ret = array();
        $image_types = ImageType::getImagesTypes('products');
        foreach($result as $val) {
            $products = explode(',', trim($val['id_products'], ','));
            foreach($products as $id_product) {
                $product = new Product((int)$id_product, false, $this->context->language->id);
                if (!$product->active) {
                    continue;
                }
                $product = get_object_vars($product);
                $urls  = [];
                foreach ($image_types as $image_type) {
                    $urls[$image_type['name']] = [
                        'url'      => $this->context->link->getImageLink(
                            $product['link_rewrite'],
                            $image['id_image'],
                            $image_type['name']
                        ),
                        'width'     => (int)$image_type['width'],
                        'height'    => (int)$image_type['height'],
                    ];
                }
                $image['bySize'] = $urls;
                $product->cover = $image;
                $ret[] = Product::getProductProperties($this->context->language->id, $product);
            }
        }
        return $ret;
    }

    public function hookDisplayHeader($params){
        $this->context->controller->addCSS($this->_path.'views/css/front.css');
        $template_file = 'module:stproductsasattrs/views/templates/hook/header.tpl';
        /*$this->context->controller->addJS($this->_path.'views/js/front.js');
        Media::addJsDef(array('stpaa' => array(
            'click_action'      => (int)Configuration::get($this->_prefix_st.'CLICK_ACTION'),
        )));*/
        if (!$this->isCached($template_file, $this->getCacheId())) {
            $css = '';
            if($text_color = Configuration::get($this->_prefix_st.'TEXT_COLOR'))
                $css .= 'a.st_paa_pro{color:'.$text_color.';}';
            if($text_color_hover = Configuration::get($this->_prefix_st.'TEXT_COLOR_HOVER'))
                $css .= 'a.st_paa_pro:hover, a.st_paa_pro.st_paa_pro_active{color:'.$text_color_hover.';}';
            if($bg = Configuration::get($this->_prefix_st.'BG'))
                $css .= 'a.st_paa_pro{background-color:'.$bg.';}';
            if($bg_hover = Configuration::get($this->_prefix_st.'BG_HOVER'))
                $css .= 'a.st_paa_pro:hover, a.st_paa_pro.st_paa_pro_active{background-color:'.$bg_hover.';}';
            if($border = Configuration::get($this->_prefix_st.'BORDER'))
                $css .= 'a.st_paa_pro{border-color:'.$border.';}';
            if($border_hover = Configuration::get($this->_prefix_st.'BORDER_HOVER'))
                $css .= 'a.st_paa_pro:hover, a.st_paa_pro.st_paa_pro_active{border-color:'.$border_hover.';}';
            if($attr_height = Configuration::get($this->_prefix_st.'ATTR_HEIGHT'))
                $css .= 'a.st_paa_pro{height:'.$attr_height.'px;}';

            if ($custom_css = Configuration::get($this->_prefix_st.'CUSTOM_CSS'))
                $css .= html_entity_decode(str_replace('¤', '\\', $custom_css));

            $this->context->smarty->assign('custom_css', $css);
        }

        return $this->fetch($template_file, $this->getCacheId());
    }
    public function hookDisplayUnderProductVariants($params){
        $id_product = Tools::getValue('id_product');
        if (!$id_product) {
            return;
        }
        if($this->get('stock') && $this->isOutOfStock($id_product))
            return;

        $res = StProAsAttrClass::getEverythingByIdProduct($id_product);
        $assembler = new ProductAssembler($this->context);
        $presenterFactory = new ProductPresenterFactory($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever(
                $this->context->link
            ),
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
        if(is_array($res) && count($res)){
            foreach ($res as $ak=>$av) {
                $active_k = 0;
                foreach ($av['products'] as $pk => $pv) {
                    $p = new product($pv['id_product']);
                    if (!$p->id || !$p->active) {
                        unset($res[$ak]['products'][$pk]);
                        continue;
                    }
                    $pv_a = $pv['active'];
                    unset($pv['active']);
                    $product = $presenter->present(
                        $presentationSettings,
                        $assembler->assembleProduct($pv),
                        $this->context->language
                    );
                    if (!$product['active']){
                        unset($res[$ak]['products'][$pk]);
                        continue;
                    }
                    if (is_array($product)) {
                        if(!$product['id_product'] || ($this->get('stock') && $this->isOutOfStock((int) $pv['id_product'])) || !$product['active'] || !$pv_a){
                            unset($res[$ak]['products'][$pk]);
                            continue;
                        }
                        if($id_product==$product['id'])
                            $active_k = $pk;
                        $res[$ak]['products'][$pk]['active'] = $id_product==$product['id'];
                        $res[$ak]['products'][$pk]['name'] = $product['name'];
                        $res[$ak]['products'][$pk]['price'] = $product['price'];
                        $res[$ak]['products'][$pk]['url'] = $product['url'];
                        $res[$ak]['products'][$pk]['cover'] = $product['cover']['bySize']['cart_default']['url'];
                    } else {
                        if(!Validate::isLoadedObject($product) || ($this->get('stock') && $this->isOutOfStock((int) $pv['id_product'])) || !$product->active || !$pv_a){
                            unset($res[$ak]['products'][$pk]);
                            continue;
                        }
                        if($id_product==$product->id)
                            $active_k = $pk;
                        $res[$ak]['products'][$pk]['active'] = $id_product==$product->id;
                        $res[$ak]['products'][$pk]['name'] = $product->name;
                        $res[$ak]['products'][$pk]['price'] = $product->price;
                        $res[$ak]['products'][$pk]['url'] = $product->url;
                        $res[$ak]['products'][$pk]['cover'] = $product->cover['bySize']['cart_default']['url'];
                    }
                }
                if(!count($res[$ak]['products']))
                    unset($res[$ak]);
                if($active_k){
                    $temp = $res[$ak]['products'][$active_k];
                    unset($res[$ak]['products'][$active_k]);
                    array_unshift($res[$ak]['products'],$temp);
                }
            }
        }
        $tpl = Configuration::get($this->_prefix_st.'TPL');
        $this->context->smarty->assign('st_paa', array(
            'attrs' => $res,
            'as_results' => $this->get('as_results'),            
            'tpl' => $tpl ? html_entity_decode($tpl) : '',
            'show_price' => $this->get('show_price'),
        ));
        $template_file = 'module:stproductsasattrs/views/templates/hook/variants.tpl';
        return $this->fetch($template_file);
    }
    public function isOutOfStock($id){
        $query = new DbQuery();
        $query->select('count(0)');
        $query->from('stock_available');
        $query->where('id_product = '.(int)$id);
        $query->where('id_product_attribute = 0');
        $query->where('quantity = 0');
        $query->where('(out_of_stock = 0 '.(Configuration::get('PS_ORDER_OUT_OF_STOCK') ? '' : ' || out_of_stock=2').' )');
        $query = StockAvailable::addSqlShopRestriction($query, Context::getContext()->shop->id);
        return Db::getInstance()->getValue($query);
    }
    private function parseAndRenameFile()
    {
        $file = _PS_THEME_DIR_.'templates/catalog/_partials/product-variants.tpl';
        if (file_exists($file)) {
            $content    = file_get_contents($file);
            if (preg_match('/displayUnderProductVariants/Us', $content, $match)) {
                return true;
            }

            $data = file($file);
            $last_line = trim(array_pop($data));
            while (trim($last_line)=='') {
                $last_line = trim(array_pop($data));
            }
            if($last_line!='</div>')
                return false;
            $data[] = "{hook h='displayUnderProductVariants'}";
            $data[] = "</div>";

            // rename old file, create new file.
            $folder     = dirname($file);
            $time       = date('YmdH');
            $old_file   = $folder.'/product-variants-'.$time.'.tpl';
            @rename($file, $old_file);

            @file_put_contents($file, implode('', $data));
            // If new file and old file exists, success.
            if (file_exists($file) && file_exists($old_file)) {
                return true;
            }
        }
        return false;
    }
}