
jQuery(function($){
    $('#products').autocomplete(st_product_url, {
        minChars: 1,
        autoFill: true,
        max:200,
        matchContains: true,
        mustMatch:true,
        scroll:true,
        cacheLength:0,
        extraParams:{ excludeIds:getProductExcIds()},
        formatItem: function(item) {
            if (item.length == 2) {
              return item[1]+' - '+item[0];  
            } else {
                return '--';
            }
        }
    }).result(function(event, data, formatted) {
        if (data == null || data.length != 2)
            return false;
        if(typeof(id_st_pro_as_attr)=='undefined' || !id_st_pro_as_attr)
            return false;
        var id = data[1];
        var name = data[0]; 
        $.ajax({
          url: currentIndex+'&token='+token+'&configure='+come_from+'&act=st_paap_add&ts='+new Date().getTime(),
          method: 'POST',
          dataType: 'json',
          data: {
                id_product: id,
                id_st_pro_as_attr: id_st_pro_as_attr
            },
          cache: false
        }).then(function (resp) {
            if(typeof(resp.r)!='undefined' && resp.r){
                var pro_count = $('#table-module-stproductsasattrs tbody tr').length;
                $('#table-module-stproductsasattrs tbody').append('<tr id="st_paap_'+resp.id+'_'+pro_count+'" data-id="'+resp.id+'" data-id-product="'+id+'">'+
                    '<td id="st_paap_td_'+id+'" class="dragHandle"><div class="dragGroup"><div class="positions">'+(pro_count+1)+'</div></div></td>'+
                '<td>'+name+'</td>'+
                '<td>'+resp.short_name_input+'</td>'+
                '<td><a class="" href="javascript:;" class="st_paap_pro_active"><i class="icon-check"></i><i class="icon-remove hidden"></i></a></td>'+
                '<td><a href="javascript:;" class="del_product"><img src="../img/admin/delete.gif" /></a></td>'+
                +'</tr>');
                $('#table-module-stproductsasattrs').tableDnDUpdate();
                
                $('#products').setOptions({
                    extraParams: {
                        excludeIds : getProductExcIds()
                    }
                });
            }
        }).fail(function(resp) {
          
        });  
    });
    $(document).on('click', '.del_product', function(){
        var $that = $(this);
        $.ajax({
          url: currentIndex+'&token='+token+'&configure='+come_from+'&act=st_paap_del&ts='+new Date().getTime(),
          method: 'POST',
          dataType: 'json',
          data: {
                id: $that.closest('tr').data('id')
            },
          cache: false
        }).then(function (resp) {
            if(typeof(resp.r)!='undefined' && resp.r){
                $that.closest('tr').remove();
                $('#table-module-stproductsasattrs').tableDnDUpdate();
                $('#products').setOptions({
                    extraParams: {
                        excludeIds : getProductExcIds()
                    }
                });
            }
        }).fail(function(resp) {
          
        });  
    });
    $(document).on('click', '.st_paap_pro_active', function(){
        var $that = $(this);
        var state = $that.find('.icon-check').hasClass('hidden') ? 0 : 1;
        $.ajax({
          url: currentIndex+'&token='+token+'&configure='+come_from+'&act=st_paap_pro_active&ts='+new Date().getTime(),
          method: 'POST',
          dataType: 'json',
          data: {
                id: $that.closest('tr').data('id')
            },
          cache: false
        }).then(function (resp) {
            if(typeof(resp.r)!='undefined' && resp.r){
                $that.find('i').addClass('hidden').end().find(state ? '.icon-remove' : '.icon-check').removeClass('hidden');
            }
        }).fail(function(resp) {
          
        });  
    });

});

var getProductExcIds = function()
{
    var excludeIds = '';
    $('#table-module-stproductsasattrs tbody tr').each(function(){
        excludeIds += $(this).data('id-product')+',';
    });
    return excludeIds.substr(0, excludeIds.length-1);  
}