<?php

//Prestashop 1.7 Tryoto Module
if (!defined('_PS_VERSION_')) {
    exit;
}

class Tryoto extends Module
{
    public function __construct()
    {
        $this->name = 'tryoto';
        $this->tab = 'front_office_features';
        $this->version = '1.0.0';
        $this->author = 'Tryoto';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Tryoto');
        $this->description = $this->l('Tryoto module for Prestashop 1.7');
    }

    public function install()
    {
        Configuration::updateValue('TRYOTO_ACT_USER', '')
            && Configuration::updateValue('TRYOTO_ACT_PASS', '')
            && Configuration::updateValue('TRYOTO_ACT_ID', '');

        if (!parent::install() || !$this->registerHook('displayAdminOrder') || !$this->registerHook('actionOrderStatusPostUpdate') || !$this->registerHook('actionOrderStatusUpdate') || !$this->registerHook('actionValidateOrder')) {
            return false;
        }

        return true;
    }

    public function isUsingNewTranslationSystem()
    {
        return true;
    }

    public function uninstall()
    {
        return parent::uninstall();
    }

    public function getContent()
    {
        return $this->display(__FILE__, 'views/templates/admin/configure.tpl');
    }

    public function getSupplierSuffix($orderId)
    {
        // Veritabanı bağlantısını alın
        $db = Db::getInstance();

        // Sipariş tedarikçilerini almak için SQL sorgusu
        $sql = 'SELECT od.product_id, od.product_name, ps.id_supplier, s.name as supplier_name
                FROM ' . _DB_PREFIX_ . 'order_detail od
                LEFT JOIN ' . _DB_PREFIX_ . 'product_supplier ps ON od.product_id = ps.id_product
                LEFT JOIN ' . _DB_PREFIX_ . 'supplier s ON ps.id_supplier = s.id_supplier
                WHERE od.id_order = ' . (int)$orderId;

        // Sorguyu çalıştırın ve sonucu alın
        $products = $db->executeS($sql);

        // Tedarikçileri gruplandır
        $supplierGroups = [];
        foreach ($products as $product) {
            $supplierId = $product['id_supplier'];
            if (!isset($supplierGroups[$supplierId])) {
                $supplierGroups[$supplierId] = [];
            }
            $supplierGroups[$supplierId][] = $product;
        }

        // Harflerin atanması
        $supplierSuffixes = [];
        $alphabet = range('A', 'Z');
        $index = 0;
        foreach ($supplierGroups as $supplierId => $products) {
            if ($index >= count($alphabet)) {
                $index = 0; // Harfler bittiğinde başa dön
            }
            $suffix = $alphabet[$index++];
            foreach ($products as $product) {
                $supplierSuffixes[$product['product_id']] = $suffix;
            }
        }

        return $supplierSuffixes;
    }

    public function generateOrderIDWithSuffix($orderId, $supplierSuffixes)
    {
        $productOrderIds = [];
        foreach ($supplierSuffixes as $productId => $suffix) {
            $productOrderIds[$productId] = '5931654' . $orderId . '_' . $suffix;
        }
        return $productOrderIds;
    }

    //get order details
    public function hookDisplayAdminOrder($params)
    {
        // Sipariş kimliğini alın
        $orderId = (int)$params['id_order'];

        $order = new Order($orderId);
        $customer = new Customer((int)$order->id_customer);
        $address = new Address($order->id_address_delivery);
        $products = $order->getProducts();
        $orderTotal = $order->total_paid;
        $adresim = $address->address1 . ' ' . $address->address2;
        $ilce = $address->other ? $address->other : $address->city;
        $adres_id = $address->id_state;
        $getState = new State($adres_id);
        $ilid = $getState->name ? $getState->name : $address->city;
        $telefonev = $address->phone_mobile ? $address->phone_mobile : $address->phone;
        $updatedPhoneNumber = substr(str_replace(' ', '', $telefonev), -10);
        $form_action = (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://') . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__ . 'modules/tryoto/tryotosend.php';

        // Tedarikçilerin harf atamalarını alın
        $supplierSuffixes = $this->getSupplierSuffix($orderId);

        // Yeni sipariş kimliklerini oluşturun
        $newOrderIds = $this->generateOrderIDWithSuffix($orderId, $supplierSuffixes);

        // Tedarikçi bilgilerini Smarty değişkenine aktarın
        $this->context->smarty->assign(array(
            'suppliers' => $this->getSuppliers($params),
            'refund_url' => 'kargo kodu',
            'musteriadi' => $customer->firstname . ' ' . $customer->lastname,
            'orderId' => $orderId, 
            'barkodNo' => $barkodNo,
            'adresi' => $adresim,
            'sehirler' => $sehirler,
            'il_id' => $ilid,
            'adres_id' => $adres_id,
            'urunler' => $products,
            'ilce' => $ilce,
            'il' => $address->city,
            'form_action' => $form_action,
            'telefonev' => $updatedPhoneNumber,
            'telefoncep' => $address->phone_mobile,
            'siparisno' => $newOrderIds,
            'ordertotal' => $orderTotal,
        ));

        // Tedarikçi bilgilerini ve yapılandırma şablonunu görüntüleyin
        return $this->display(__FILE__, 'views/templates/admin/configure.tpl');
    }

    public function getSuppliers($params)
    {
        // Veritabanı bağlantısını al
        $db = Db::getInstance();

        // Belirli bir sipariş kimliği için tedarikçileri almak için SQL sorgusu
        $orderId = (int)$params['id_order'];

        // Sipariş tedarikçilerini almak için SQL sorgusu
        $sql = 'SELECT od.product_id, od.product_name, ps.id_supplier, s.name as supplier_name
                FROM ' . _DB_PREFIX_ . 'order_detail od
                LEFT JOIN ' . _DB_PREFIX_ . 'product_supplier ps ON od.product_id = ps.id_product
                LEFT JOIN ' . _DB_PREFIX_ . 'supplier s ON ps.id_supplier = s.id_supplier
                WHERE od.id_order = ' . (int)$orderId;

        // Sorguyu çalıştırın ve sonucu alın
        return $db->executeS($sql);
    }
}
?>

