<?php
// PrestaShop dosyalarını dahil edin
require_once dirname(__FILE__) . '/../../config/config.inc.php';
require_once dirname(__FILE__) . '/../../init.php';

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

// Verileri AJAX çağrısından alın
$orderId = $data['orderId'];
$musteriadi = $data['musteriadi'];
$adres = $data['adres'];
$il = $data['il'];
$ilce = $data['ilce'];
$updatedPhoneNumber = $data['updatedPhoneNumber'];
$urunler = $data['urunler'];
$siparisno = $data['siparisno'];
$orderTotal = $data['orderTotal']; // Eklenmiş

// Step 1: Get Access Token
$refresh_token = 'AMf-vBxdhHrfF_QmlwK3ktrjHeOlnCI88XnykXZbYvCnpYVvtSJ9iUmZQrWopUdkfgHDVrmLXJeFHBCquXDQG5m-27Fgswss81o0G7JJ47rK1Kq3xjEyDMjH_FT56hFFamLpNrEE4m84485UJG3rST5FEiEJ4Zd2gAQjm0j3zkB1CPiGqkUzVV0Z24a4BTCs0xWMxK_Bi74YpQM-NqVU13GbGFmLfvSRqg';

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://staging-api.tryoto.com/rest/v2/refreshToken',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => json_encode(array('refresh_token' => $refresh_token)),
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
curl_close($curl);

$response_data = json_decode($response, true);
if (isset($response_data['access_token'])) {
    $access_token = $response_data['access_token'];
} else {
    die(json_encode(['error' => 'Access token could not be retrieved']));
}

// Step 2: Create Order
$items = [];
foreach ($urunler as $urun) {
    $items[] = [
        'productId' => $urun['product_id'],
        'name' => $urun['product_name'],
        'price' => $urun['unit_price_tax_incl'],
        'rowTotal' => $urun['total_price_tax_incl'],
        'taxAmount' => $urun['unit_price_tax_incl'] - $urun['unit_price_tax_excl'],
        'quantity' => $urun['product_quantity'],
        'sku' => $urun['product_reference'],
        'image' => $urun['image'] // Ürün görsel URL'si varsa ekleyin
    ];
}

$orderData = [
    'orderId' => $orderId,
    'ref1' => $siparisno[array_key_first($urunler)], // Sipariş numarası ilk ürünün tedarikçi harfi ile
    'pickupLocationCode' => 'blksr', // Örnek tedarikçi kodu, gerçek veriye göre güncellenmeli
    'deliveryOptionId' => '123642',
    'serviceType' => '',
    'createShipment' => false,
    'storeName' => 'ZerzevatOnline',
    'payment_method' => 'cash',
    'amount' => $orderTotal,
    'amount_due' => 0,
    'customsValue' => '12',
    'customsCurrency' => 'TRY',
    'shippingAmount' => 20,
    'subtotal' => $orderTotal,
    'currency' => 'TRY',
    'shippingNotes' => 'dikkatli ol, kırılabilir ürün var',
    'packageSize' => 'small',
    'packageCount' => 2,
    'packageWeight' => 1,
    'boxWidth' => 10,
    'boxLength' => 10,
    'boxHeight' => 10,
    'orderDate' => date('d/m/Y H:i'),
    'deliverySlotDate' => date('d/m/Y', strtotime('+1 day')),
    'deliverySlotTo' => '12pm',
    'deliverySlotFrom' => '2:30pm',
    'senderName' => 'Sender Company',
    'customer' => [
        'name' => $musteriadi,
        'email' => 'test@test.com', // Örnek e-posta, gerçek veriye göre güncellenmeli
        'mobile' => $updatedPhoneNumber,
        'address' => $adres,
        'district' => $ilce,
        'city' => $il,
        'country' => 'TR',
        'postcode' => '10100',
        'lat' => '40.706333',
        'lon' => '29.888211',
        'refID' => '1000012',
        'W3WAddress' => 'alarmed.cards.stuffy'
    ],
    'items' => $items
];

$curl = curl_init();

curl_setopt_array($curl, [
    CURLOPT_URL => 'https://staging-api.tryoto.com/rest/v2/createOrder',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => json_encode($orderData),
    CURLOPT_HTTPHEADER => [
        "Authorization: Bearer $access_token",
        'Content-Type: application/json'
    ],
]);

$response = curl_exec($curl);
curl_close($curl);

echo $response;
?>
