<!-- views/templates/admin/configure.tpl -->

<!-- Bu dosya, PrestaShop 1.7 yapılandırma sayfasında görüntülenen içeriği tanımlar -->
<div class="product-row row">
<div class="col-md-12 left-column">
<!-- Sayfa başlığı -->
<h1>Tedarikçiye Göre Ürün Listesi</h1>
<!-- Sayfa açıklaması -->
<p>TRYOTO İçin, tedarikçiye göre ürün listesini görebilirsiniz.</p>

<!-- Eğer $suppliers değişkeni varsa tedarikçi bilgilerini listele -->
<!-- var dump suppliers --> 
{if $suppliers}
<table class="table">
    <thead>
        <tr>
            <th>Ürün ID</th>
            <th>Ürün Adı</th>
            <th>Tedarikçi ID</th>
            <th>Tedarikçi Adı</th>
            <th>Sipariş No</th>
        </tr>
    </thead>
    <tbody>
        {foreach from=$suppliers item=supplier}
            <tr>
                <td>{$supplier.product_id}</td>
                <td>{$supplier.product_name}</td>
                <td>{$supplier.id_supplier}</td>
                <td>{$supplier.supplier_name}</td>
                <td>{$siparisno[$supplier.product_id]}</td>
            </tr>
        {/foreach}
    </tbody>
</table>
{else}
    <p>No supplier information available for this order.</p>
{/if}


    <table class="table">
        <thead>
            <tr>
                <th>Müşteri Adı Soyadı</th>
                <th>Adres</th>
                <th>Telefon</th>
                <th>Toplam Sipariş</th>
                <th>ORDER ID </th>
            </tr>
        </thead>
        <tbody>
     
                <tr>
                    <td>{$musteriadi}</td>
                    <td>{$adresi}</td>
                    <td>{$telefonev}</td>
                    <td>{$ordertotal}</td>
                    <td>{$orderId}</td>
                </tr>
    
        </tbody>
    </table>
    <!-- Tryoto API'sine gönderim için form -->
<button id="sendToTryoto" type="button" class=" btn btn-primary">Tryoto'ya Gönder</button>
</div>
</div>

<!-- AJAX çağrısı için JavaScript -->
<script type="text/javascript">
    document.getElementById('sendToTryoto').addEventListener('click', function() {
        var data = {
            orderId: '{$orderId}',
            musteriadi: '{$musteriadi}',
            adres: '{$adresi}',
            il: '{$il}',
            ilce: '{$ilce}',
            updatedPhoneNumber: '{$telefonev}',
            urunler: {$urunler|json_encode},
            siparisno: {$siparisno|json_encode},
            orderTotal: '{$ordertotal}'
        };

        var groupedData = {};

        // Ürünleri tedarikçiye göre gruplandır
        data.urunler.forEach(function(urun) {
            var supplierName = urun.supplier_name;
            if (!groupedData[supplierName]) {
                groupedData[supplierName] = [];
            }
            groupedData[supplierName].push(urun);
        });

        // Her tedarikçi için ayrı bir API çağrısı yap
        Object.keys(groupedData).forEach(function(supplierName) {
            var supplierData = {
                orderId: data.orderId,
                musteriadi: data.musteriadi,
                adres: data.adres,
                il: data.il,
                ilce: data.ilce,
                updatedPhoneNumber: data.updatedPhoneNumber,
                urunler: groupedData[supplierName],
                siparisno: data.siparisno,
                orderTotal: data.orderTotal
            };

            fetch('{$form_action}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(supplierData)
            })
            .then(response => response.json())
            .then(response => {
                console.log(response);
                alert(response.message || 'Order sent successfully for ' + supplierName + '!');
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while sending the order for ' + supplierName);
            });
        });
    });
</script>